using namespace System::Xml::Serialization;


namespace CoreSync
{
	#define CONTACT_ASSISTANT		1073872927	//4002001F
	#define CONTACT_ASSISTANT_TEL	1074003999	//4004001F
	#define CONTACT_CAR_TEL			975044639	//3A1E001F
	#define CONTACT_CHILDREN		1074135071	//4006001F
	#define CONTACT_EMAIL			1082327071	//4083001F
	#define CONTACT_EMAIL2			1083375647	//4093001F
	#define CONTACT_EMAIL3			1084424223	//40A3001F
	#define CONTACT_HOME_FAX		975503391	//3A25001F
	#define CONTACT_HOME_TEL		973668383	//3A09001F
	#define CONTACT_HOME_TEL2		976158751	//3A2F001F
	#define CONTACT_MOBILE_TEL		974913567	//3A1C001F
	#define CONTACT_BEEPER			1074331679	//4009001F
	#define CONTACT_RADIO_TEL		974979103	//3A1D001F
	#define CONTACT_SPOUSE			1074397215	//400A001F
	#define CONTACT_WEBPAGE			1074266143	//4008001F
	#define CONTACT_OFFICE_FAX		975437855	//3A24001F
	#define CONTACT_OFFICE_TEL		973602847	//3A08001F
	#define CONTACT_OFFICE_TEL2		1074200607	//4007001F
	#define CONTACT_FULLNAME		1074987039	//4013001F
	#define CONTACT_SOCIETY			974520351	//3A16001F
	#define CONTACT_UNIT			974651423	//3A18001F
	#define CONTACT_FIRSTNAME		973471775	//3A06001F
	#define CONTACT_LASTNAME		974192671	//3A11001F
	#define CONTACT_MIDDLENAME		1076101151	//4024001F
	#define CONTACT_TITLE			1076035615	//4023001F
	#define CONTACT_OFFICE_LOCATION	974716959	//3A19001F
	#define	CONTACT_SUFFIX			973406239	//3A05001F
	#define	CONTACT_JOB				974585887	//3A17001F
	#define CONTACT_HOME_STREET		1077936159	//4040001F
	#define CONTACT_HOME_CITY		1078001695	//4041001F
	#define CONTACT_HOME_PROVINCE	1078067231	//4042001F
	#define CONTACT_HOME_ZIPCODE	1078132767	//4043001F
	#define CONTACT_HOME_COUNTRY	1078198303	//4044001F
	#define CONTACT_OFFICE_STREET	1078263839	//4045001F
	#define CONTACT_OFFICE_CITY		1078329375	//4046001F
	#define CONTACT_OFFICE_PROVINCE	1078394911	//4047001F
	#define CONTACT_OFFICE_ZIPCODE	1078460447	//4048001F
	#define CONTACT_OFFICE_COUNTRY	1078525983	//4049001F
	#define CONTACT_OTHER_STREET	1078591519	//404A001F
	#define CONTACT_OTHER_CITY		1078657055	//404B001F
	#define CONTACT_OTHER_PROVINCE	1078722591	//404C001F
	#define CONTACT_OTHER_ZIPCODE	1078788127	//404D001F
	#define CONTACT_OTHER_COUNTRY	1078853663	//404E001F
	#define CONTACT_ANNIVERSARY		1073938496	//40030040 -- FILETIME
	#define CONTACT_BIRTHDATE		1073807424	//40010040 -- FILETIME

	#define CONTACT_UNKNOWN03		1441857		//00160041  *3* BLOB - testare per le categorie
	#define CONTACT_UNKNOWN04		1507393		//00170041  *4* BLOB - testare per le categorie
	#define CONTACT_UNKNOWN05		4294770707	//FFFD0013  *5* UI4 - non determinabile. E' sempre l'ultimo campo del database.
	#define CONTACT_UNKNOWN06		4294836243	//FFFE0013  *6* UI4 - non determinabile.

	#define CONTACT_CUSTOM_ID			0xAAA0001F
	#define CONTACT_CUSTOM_TIMESTAMP	0xAAA10040
	#define CONTACT_CUSTOM_HASHVALUE	0xAAA2001F

	[XmlRoot("contact")]
	public ref class Contact : System::Object
	{
	public:
		int OID;
		[XmlElement("action")] 
		System::String ^action;
		[XmlElement("assistant")] 
		System::String ^assistant;
		[XmlElement("assistantTel")] 
		System::String ^assistantTel;
		[XmlElement("carTel")] 
		System::String ^carTel;
		[XmlElement("children")] 
		System::String ^children;
		[XmlElement("email")] 
		System::String ^email;
		[XmlElement("email2")] 
		System::String ^email2;
		[XmlElement("email3")] 
		System::String ^email3;
		[XmlElement("homeFax")] 
		System::String ^homeFax;
		[XmlElement("homeTel")] 
		System::String ^homeTel;
		[XmlElement("homeTel2")] 
		System::String ^homeTel2;
		[XmlElement("mobileTel")] 
		System::String ^mobileTel;
		[XmlElement("beeper")] 
		System::String ^beeper;
		[XmlElement("radioTel")] 
		System::String ^radioTel;
		[XmlElement("spouse")] 
		System::String ^spouse;
		[XmlElement("webpage")] 
		System::String ^webpage;
		[XmlElement("officeFax")] 
		System::String ^officeFax;
		[XmlElement("officeTel")] 
		System::String ^officeTel;
		[XmlElement("officeTel2")] 
		System::String ^officeTel2;
		[XmlElement("fullName")] 
		System::String ^fullName;
		[XmlElement("society")] 
		System::String ^society;
		[XmlElement("unit")] 
		System::String ^unit;
		[XmlElement("firstName")] 
		System::String ^firstName;
		[XmlElement("lastName")] 
		System::String ^lastName;
		[XmlElement("middleName")] 
		System::String ^middleName;
		[XmlElement("title")] 
		System::String ^title;
		[XmlElement("officeLocation")] 
		System::String ^officeLocation;
		[XmlElement("suffix")] 
		System::String ^suffix;
		[XmlElement("job")] 
		System::String ^job;
		[XmlElement("homeStreet")] 
		System::String ^homeStreet;
		[XmlElement("homeCity")] 
		System::String ^homeCity;
		[XmlElement("homeProvince")] 
		System::String ^homeProvince;
		[XmlElement("homeZipcode")] 
		System::String ^homeZipcode;
		[XmlElement("homeCountry")] 
		System::String ^homeCountry;
		[XmlElement("officeStreet")] 
		System::String ^officeStreet;
		[XmlElement("officeCity")] 
		System::String ^officeCity;
		[XmlElement("officeProvince")] 
		System::String ^officeProvince;
		[XmlElement("officeZipcode")] 
		System::String ^officeZipcode;
		[XmlElement("officeCountry")] 
		System::String ^officeCountry;
		[XmlElement("otherStreet")] 
		System::String ^otherStreet;
		[XmlElement("otherCity")] 
		System::String ^otherCity;
		[XmlElement("otherProvince")] 
		System::String ^otherProvince;
		[XmlElement("otherZipcode")] 
		System::String ^otherZipcode;
		[XmlElement("otherCountry")] 
		System::String ^otherCountry;
		[XmlElement("birthDate")] 
		System::DateTime birthDate;
		[XmlElement("anniversary")] 
		System::DateTime anniversary;
		[XmlElement("customID")] 
		System::String ^customID;
		[XmlElement("hashValue")] 
		System::String ^hashValue;
		[XmlElement("timeStamp")] 
		System::DateTime timeStamp;

		Contact();

		bool Equals(Contact ^ct);
		void Import(Contact ^ct);
		void MergeWith(Contact ^ct);

	};

	[XmlRoot("contacts")]
	public ref class Contacts : System::Object
	{
	private:
		//int pvt_iCount;
		[XmlElement("item")]
		System::Collections::ArrayList ^pvt_oContacts;

	public:
		Contacts();
		~Contacts();

		/// <summary>
		///  Return the number of items loaded inside this class.
		/// </summary>
		int getCount();
		/// <summary>
		///  Return the Contact object at the specified index.
		///  Will raise an exception if the index is out of bounds.
		/// </summary>
		Contact ^get(int index);
		/// <summary>
		///  Add a new Contact to this collection of contacts.
		/// </summary>
		void add(Contact ^oContact);
		/// <summary>
		/// Remove the Contact at the specified index.
		/// Will raise an exception if the index is out of bounds.
		/// </summary>
		void remove(int index);
		/// <summary>
		/// Remove the Contact specified as parameter.
		/// </summary>
		void remove(Contact ^oContact);

		/// <summary>
		/// Return the number of Contacts present on PocketPC.
		/// </summary>
		int getCountFromPocketPC();
		/// <summary>
		/// Return the Contact object with the supplied CEOID (OID).
		/// </summary>
		Contact ^getFromPocketPC(int OID);					// richiama l'oggetto con l'OID specificato dal PocketPC
		/// <summary>
		/// Put a Contact object on the PocketPC.
		/// If bAdd is True, the contact will be added.
		/// If bAdd is False, the contact will be modified.
		/// If bAdd is False and Contact.OID is 0, the function will fail.
		/// This function return the OID of the Contact just inserted or modified.
		/// If the contact has been added, the OID property of the Contact object is modified to reflect the return value.
		/// </summary>
		int putOnPocketPC(Contact ^oContact, bool bAdd);	// salva l'oggetto sul PocketPC. Se bAdd  True, l'oggetto verr aggiunto. Se l'attributo OID dell'oggetto Contact  0 e bAdd  False, la funzione fallisce. Se la funzione ha successo, restituisce l'OID dell'oggetto salvato.
		/// <summary>
		/// Remove a Contact from the PocketPC. The only parameter that will be looked for is the OID property of the Contact.
		/// Return True if the Contact has been deleted, False otherwise.
		/// </summary>
		bool removeFromPocketPC(Contact ^oContact);			// rimuove l'oggetto con l'OID specificato in oContact dal PocketPC.
		/// <summary>
		/// Remove the Contact on the PocketPC that have the specified CEOID (OID).
		/// Return True if the Contact has been deleted, False otherwise.
		/// </summary>
		bool removeFromPocketPC(int OID);					// rimuove l'oggetto con l'OID specificato come parametro dal PocketPC.
	};
}
