/***
  * The Developer of this Code is HJ van Rantwijk. Copyright
  * (C) 2001-2007 by HJ van Rantwijk.  All Rights Reserved.
  *
  * Contributors:
  *    Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  */

var gManager, gDialogManager, gSidebarPanelPopup, gModified, gSettings = new Array();
var gToolbarList, gThirdPartyList;

var gElementArray = new Array();
var gElementIDs   = new Array("WindowWidth", "WindowHeight", "WindowXPos", "WindowYPos" , "WindowState", 
                              "ToolbarList", "SidebarPanel", "SidebarWidth");


function preLaunch()
{
  gManager = window.top;
  gManager.selectWindowStyling(document.documentElement);
  gDialogManager = gManager.frames['mainWindowFrame'];
  gSidebarPanelPopup = document.getElementById("sidebar-panels-popup");
  gSidebarPanelPopup.database.AddDataSource(gDialogManager.RDF.GetDataSource(gManager.getNavigatorWindow().sidebarObj.datasource_uri));

  for (i in gElementIDs) {
    gElementArray[i] = document.getElementById(gElementIDs[i]);
  }
  gToolbarList = document.getElementById("ToolbarList");
  gThirdPartyList = document.getElementById("ThirdPartyList");

  gToolbarList.addEventListener("CheckboxStateChange", setHiddenToolbars, false);
  gThirdPartyList.addEventListener("CheckboxStateChange", setHiddenToolbars, false);
}

function startup()
{
  gModified = false;
  gSidebarPanelPopup.builder.rebuild();
  setTimeout(initSidebarPanelPopup, 0, gSidebarPanelPopup);
  gToolbarList.selectedIndex = 0;
  gThirdPartyList.selectedIndex = 0;
  activateSettings(gDialogManager.mzGetWindowSettings(gDialogManager.mzRDFStore, gDialogManager.gResource));
}

function activateSettings(aDataCollection)
{
  gElementArray[0].value = aDataCollection.width;
  gElementArray[1].value = aDataCollection.height;
  gElementArray[2].value = aDataCollection.screenX;
  gElementArray[3].value = aDataCollection.screenY;
  gElementArray[4].value = aDataCollection.windowState;
  var hiddenToolbars = aDataCollection.hiddenToolbars;

  if (hiddenToolbars != undefined) {
    hiddenToolbars = hiddenToolbars.split(',').sort();
    gElementArray[5].toolbars = hiddenToolbars;

    for (i in hiddenToolbars) {
      var toolbarCheckbox = document.getElementById(hiddenToolbars[i]);

      if (!toolbarCheckbox) {
        var listItem = document.createElement("listitem");
        listItem.setAttribute("id", hiddenToolbars[i]);
        listItem.setAttribute("type", "checkbox");
        listItem.setAttribute("label", hiddenToolbars[i]);
        gThirdPartyList.appendChild(listItem);
        toolbarCheckbox = document.getElementById(hiddenToolbars[i]);
      }
      toolbarCheckbox.setAttribute("checked", "true");
    }
  }
  else {
    gElementArray[5].toolbars = new Array();
  }
  gElementArray[6].value = aDataCollection.sidebarPanel;
  gElementArray[7].value = (aDataCollection.sidebarWidth == undefined) ? 0 : aDataCollection.sidebarWidth;

  gSettings = getWindowSettings();
  gSettings[5] = (hiddenToolbars == undefined || hiddenToolbars == "") ? new Array() : aDataCollection.hiddenToolbars.split(',').sort();
  gSettings[6] = aDataCollection.sidebarPanel;
  /***
    *
    */
  var defaultSettings = new Array();

  if (aDataCollection.width == undefined || aDataCollection.width < 100) {
    gElementArray[0].value = 640;
    defaultSettings.push("Window Width");
  }
  if (aDataCollection.height == undefined || aDataCollection.height < 100) {
    gElementArray[1].value = 480;
    defaultSettings.push("Window Height");
  }
  if (aDataCollection.screenX == undefined || aDataCollection.screenX < 0) {
    gElementArray[2].value = 0;
    defaultSettings.push("Window ScreenX");
  }
  if (aDataCollection.screenY == undefined || aDataCollection.screenY < 0) {
    gElementArray[3].value = 0;
    defaultSettings.push("Window ScreenY");
  }
  if (aDataCollection.windowState == undefined || aDataCollection.windowState < 1 || aDataCollection.windowState > 4) {
    gElementArray[4].value = 3;
    defaultSettings.push("Window State");
  }
  if (aDataCollection.hiddenToolbars == undefined || aDataCollection.hiddenToolbars == "") {
    hiddenToolbars = ["component-bar", "linktoolbar"];
    gElementArray[5].toolbars = hiddenToolbars;

    for (i in hiddenToolbars) {
      var toolbarCheckbox = document.getElementById(hiddenToolbars[i]);

      if (!toolbarCheckbox) {
        var listItem = document.createElement("listitem");
        listItem.setAttribute("id", hiddenToolbars[i]);
        listItem.setAttribute("type", "checkbox");
        listItem.setAttribute("label", hiddenToolbars[i]);
        gThirdPartyList.appendChild(listItem);
        toolbarCheckbox = document.getElementById(hiddenToolbars[i]);
      }
      toolbarCheckbox.setAttribute("checked", "true");
    }
    defaultSettings.push("Toolbars");
  }
  if (aDataCollection.sidebarPanel == undefined) {
    gElementArray[6].value = "";
    defaultSettings.push("Sidebar Panel");
  }
  var selectedSidebarTextbox = gElementArray[7];

  if (aDataCollection.sidebarWidth == undefined) {
    selectedSidebarTextbox.value = 0;
    defaultSettings.push("Sidebar Width");
  }
  selectedSidebarTextbox.disabled = (gElementArray[6].value == "");
  selectedSidebarTextbox.nextSibling.disabled = selectedSidebarTextbox.disabled;
  
  if (defaultSettings.length > 0) {
    gModified = true;
    hasModifiedSettings(true);
    // setTimeout(alert, 0, "The following items are initialized:" + defaultSettings);
  }
  // dump("\nswitchPage-end  : " + new Date().valueOf());
}

function getWindowSettings()
{
  var aDataCollection = new Array();
  aDataCollection[0] = gElementArray[0].value;
  aDataCollection[1] = gElementArray[1].value;
  aDataCollection[2] = gElementArray[2].value;
  aDataCollection[3] = gElementArray[3].value;
  aDataCollection[4] = gElementArray[4].value;
  aDataCollection[5] = gElementArray[5].toolbars;
  aDataCollection[6] = (gElementArray[6].selectedIndex == 0) ? undefined : gElementArray[6].selectedItem.getAttribute("id");
  aDataCollection[7] = (gElementArray[7].value == "") ? undefined : gElementArray[7].value;

  return aDataCollection;
}

function storeDataCollection()
{
  var dataSource = gDialogManager.mzRDFStore;
  var resource = gDialogManager.gResource;
  // dump("\nresource    : " + resource);
  var sizePosState = gElementArray[0].value + "," + gElementArray[1].value + "," + 
                     gElementArray[2].value + "," + gElementArray[3].value + "," + gElementArray[4].value;
  // dump("\nsizePosState: " + sizePosState);
  var hiddenToolbars = gElementArray[5].toolbars;
  // dump("\nhiddenToolbars: " + hiddenToolbars);
  var sidebarWidthName = gElementArray[7].value + "," + gElementArray[6].selectedItem.getAttribute("id");
  // dump("\nsidebarWidthName: " + sidebarWidthName);

  gDialogManager.mzAddOrChangeProperty(dataSource, resource, "sizePosState", sizePosState);
  gDialogManager.mzAddOrChangeProperty(dataSource, resource, "hiddenToolbars", hiddenToolbars);
  gDialogManager.mzAddOrChangeProperty(dataSource, resource, "sidebar", sidebarWidthName);
  gDialogManager.mzSetModifiedDate(dataSource, resource, "lastModified");
}

function hasModifiedSettings(aForcedFlag)
{
  if (aForcedFlag == undefined) {
    var currentValues = getWindowSettings();

    for (var i = 0; i < 8; i++) {
      if (i == 5)
        continue;
      if (currentValues[i] != undefined && gSettings[i] != currentValues[i]) {
        gModified = true;
        break;
      }
    }
    if (i == 8 && gModified)
      gModified = false;
    if (!gModified) {
      if (currentValues[5].toString() != gSettings[5].toString())
        gModified = true;
    }
  }
  gManager.gAcceptButton.disabled = !gModified;

  if (gModified)
    gManager.gCancelButton.removeAttribute('action');
  else
    gManager.gCancelButton.setAttribute('action', 'back');
  var buttonLabel = (gModified) ? "cancelButtonLabel" : "backButtonLabel";
  gManager.gCancelButton.label = gManager.gStringBundle.getString(buttonLabel);
}

function setHiddenToolbars(aEvent)
{
  var id = aEvent.originalTarget.id;
  var isChecked = aEvent.originalTarget.checked;
  var hiddenToolbars = gElementArray[5].toolbars;
  var index = hiddenToolbars.indexOf(id);

  if (isChecked) {
    if (index == -1)
      hiddenToolbars.push(id);
  }
  else {
    hiddenToolbars.splice(index, 1);
  }
  gElementArray[5].toolbars = hiddenToolbars.sort();
  hasModifiedSettings();
}
// XXX: moved this function to sessionManager.xul
function mzSpinButton(aDocument, aElementId, aStepValue, aMinValue, aMaxValue)
{
  gDialogManager.mzSpinButton(aDocument, aElementId, aStepValue, aMinValue, aMaxValue)
  hasModifiedSettings();
}
// XXX: moved this function to sessionManager.xul
function mzKeySpinButton(aEvent)
{
  gDialogManager.mzKeySpinButton(aEvent)
  hasModifiedSettings();
}
// XXX: moved this function to sessionManager.xul
function mzValidateSpinValue(aEvent)
{
  gDialogManager.mzValidateSpinValue(aEvent)
  hasModifiedSettings();
}

function initSidebarPanelPopup(aPopupMenu)
{
  if (gElementArray[6].value == undefined) {
    menuitem.setAttribute("checked", "true");
    aPopupMenu.parentNode.selectedIndex = 0;
    gElementArray[7].value = 0;
  }
  else {
    for (var i = 0; i < aPopupMenu.childNodes.length; i++) {
      var menuitem = aPopupMenu.childNodes[i];
    
      if (menuitem.getAttribute("id") == gElementArray[6].value) {
        menuitem.setAttribute("checked", "true");
        aPopupMenu.parentNode.selectedIndex = i;
        break;
      }
    }
  }
}

function selectSidebarPanel(aPopupMenu)
{
  var selectedSidebarTextbox = gElementArray[7];
  var selectedIndex = aPopupMenu.parentNode.selectedIndex;

  if (selectedIndex == 0)
    selectedSidebarTextbox.value = 0;
  else {
    var minValue = Number(document.getElementById("SidebarWidthSpinbuttons").getAttribute("min"));
    selectedSidebarTextbox.value = (gSettings[7] > minValue) ? gSettings[7] : minValue;
  }
  selectedSidebarTextbox.disabled = (selectedIndex == 0);
  selectedSidebarTextbox.nextSibling.disabled = selectedSidebarTextbox.disabled;
  hasModifiedSettings();
}

function shutdown()
{
  gToolbarList.removeEventListener("CheckboxStateChange", setHiddenToolbars, false);
  gThirdPartyList.removeEventListener("CheckboxStateChange", setHiddenToolbars, false);
}

function onCancel(aEvent)
{
  if (gModified && gManager.gConfirmForID > 1) { // 1 = [Cancel] button
    if (gManager.getConfirmation('mzWizard', 'prefPanelConfirmCloseText'))
      storeDataCollection();
  }
  return (gManager.gConfirmForID > 2); // return true for Accel+W and Window[X]
}

function onAccept(aEvent)
{
  storeDataCollection();
  return false;
}

