/***
  * The contents of this file are subject to the Mozilla Public
  * License Version 1.1 (the "License"); you may not use this file
  * except in compliance with the License. You may obtain a copy of
  * the License at http://www.mozilla.org/MPL/
  * 
  * Software distributed under the License is distributed on an "AS
  * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
  * implied. See the License for the specific language governing
  * rights and limitations under the License.
  * 
  * The Original Code in this file as it was released publicly upon
  * October 30, 2004 after being tested for several months by a 
  * bunch of CSS co-workers. Thanks guys ;)
  * 
  * The Initial Developer of the Original Code is HJ van Rantwijk.
  * all Portions created by HJ van Rantwijk are Copyright (C) 2004-2007
  * by HJ van Rantwijk. All Rights Reserved.
  * 
  * Contributors:
  *   Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  *
  */
   
function mzFindChildShell(aDocument, aDocShell, aSoughtURL)
{
  aDocShell.QueryInterface(Components.interfaces.nsIWebNavigation);
  aDocShell.QueryInterface(Components.interfaces.nsIInterfaceRequestor);
  var doc = aDocShell.getInterface(Components.interfaces.nsIDOMDocument);

  if ((aDocument && doc == aDocument) && aDocShell.currentURI.spec == aSoughtURL)
    return aDocShell;

  var node = aDocShell.QueryInterface(Components.interfaces.nsIDocShellTreeNode);

  for (var i = 0; i < node.childCount; ++i) {
    var docShell = node.getChildAt(i);
    docShell = mzFindChildShell(aDocument, docShell, aSoughtURL);

    if (docShell == aSoughtURL)
      return docShell;
  }
  return null;
}

var targetDocument = null;

var mzFeedHandler =
{
  initialized       : false,
  _bundle           : null,
  _feedButton       : null,
  _targetBrowser    : null,
  _XSLTProcessor    : null,
  _Stylesheet       : null,
  _StylesheetURL    : "chrome://multiviews/content/feedviewer/feedviewer.xsl",
  _ATOM_10_NS       : "http://www.w3.org/2005/Atom",
  _ATOM_03_NS       : "http://purl.org/atom/ns#",
  _RSS_10_NS        : "http://purl.org/rss/1.0/",
  _RSS_09_NS        : "http://my.netscape.com/rdf/simple/0.9/",
  _RDF_NS           : "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
  _DC_NS            : "http://purl.org/dc/elements/1.1/",
  _feedViewerPath   : "chrome://multiviews/content/feedviewer/",
  _nsIIOService     : null,
  _nsIGlobalHistory : null,
  infoHeaderLength  : 250,
  _newFeedAdded     : false,
  showFeedURL       : "",

  _getContentShell: function(doc, feedURL)
  {
    var browsers = getBrowser().browsers;

    for (var i = 0; i < browsers.length; i++) {
      var shell = mzFindChildShell(doc, browsers[i].docShell, feedURL);

      if (shell)
        return { shell: shell, browser: browsers[i] };
    }
    return null;
  },

  init: function()
  {
    if (!this.initialized) {
      dump("\nmzFeedHandler.init()");
      this._bundle = gMultiZilla.utility.getStringBundle();
      this._nsIIOService = Components.classes["@mozilla.org/network/io-service;1"]
                                     .getService(Components.interfaces.nsIIOService);
      // Builds 20040210 and up (see also mozilla bug 224829)
      if ("@mozilla.org/browser/global-history;2" in Components.classes)
        this._nsIGlobalHistory = Components.classes["@mozilla.org/browser/global-history;2"]
                                           .getService(Components.interfaces.nsIGlobalHistory2);
      else
        this._nsIGlobalHistory = Components.classes["@mozilla.org/browser/global-history;1"]
                                           .getService(Components.interfaces.nsIGlobalHistory);

      this._nsIIOService = Components.classes["@mozilla.org/network/io-service;1"]
                                     .getService(Components.interfaces.nsIIOService);

      const mzWebFeedService = new Components.Constructor("@multizilla.org/webfeed-service;1", "nsIWebFeedService");
      this.webFeedService = new mzWebFeedService();
      this.initialized = true;
    }
    this.infoHeaderLength = gMultiZilla.prefs.readInteger("multizilla.sidebar.feed-panel.info-header.length", 250);
  },

  checkForFeeds: function(aEvent)
  {
    var aDocument = aEvent.originalTarget;
    var aURL = aDocument.location.href;

    if (/* (aDocument instanceof HTMLDocument) || */(aDocument instanceof XMLDocument) ||
          ((aDocument instanceof XULDocument) && aURL.match(/^(https?|file):/))) {
      var tabBrowser = window.getBrowser();
      var shellObj = mzFeedHandler._getContentShell(aDocument, aURL);
      tabBrowser.selectedTab = tabBrowser.getTabForBrowser(shellObj.browser);

      if (shellObj) {
        if (mzFeedHandler.isDocumentFeed(aDocument)) {
          mzFeedHandler._targetBrowser = shellObj.browser;
          mzFeedHandler._XSLTProcessor = new XSLTProcessor();
          mzFeedHandler._Stylesheet = document.implementation.createDocument("", "", null);
          mzFeedHandler._process(mzFeedHandler.transformFeed, aDocument, mzFeedHandler.showFeedURL);
          mzFeedHandler.showFeedURL = "";
        }
      }
    }
    mzFeedHandler.updateFeeds();
  },

  showFeed: function(aURL, inNewTab)
  {
    // dump("\nmzFeedHandler.showFeed()" + aURL);
    var tabBrowser = getBrowser();
    var tab = (inNewTab) ? tabBrowser.addTab() : tabBrowser.selectedTab;

    this.showFeedURL = aURL;
    tab.linkedBrowser.loadURI(aURL);
  },

  validate: function(aDocument, skipCheck) // called by isDocumentTransformedFeed()
  {
    // dump("\nmzFeedHandler.validate() " + aDocument);
    if (!(aDocument instanceof XMLDocument) && !(aDocument instanceof XULDocument))
      return false;
      
    if (!this.isDocumentFeed(aDocument))
      return false;

    if (skipCheck == undefined) {
      if (!this._getContentShell(aDocument, aDocument.location.href))
        return false;
    }
    return true;
  },

  updateFeeds: function()
  {
    dump("\nmzFeedHandler.updateFeeds()");
    if (!this._feedButton)
      this._feedButton = document.getElementById("feed-button");

    var feeds = gBrowser.mCurrentBrowser.feeds;

    if (!feeds || feeds.length == 0) {
      this._feedButton.removeAttribute("feeds");
      this._feedButton.setAttribute("tooltiptext", this._bundle.GetStringFromName("feedNoFeeds"));
    } 
    else {
      this._feedButton.setAttribute("feeds", "true");
      var tooltipText = (feeds.length == 1) ? "showFeed" : "feedHasFeeds";

      if (feeds.length > 1)
        this._feedButton.setAttribute("multiple", "true");
      else
        this._feedButton.removeAttribute("multiple");

      this._feedButton.setAttribute("tooltiptext", this._bundle.GetStringFromName(tooltipText));
    }
  },

  onFeedLinkAdded: function(aEvent)
  {
    // dump("\nzFeedHandler.onFeedLinkAdded()");
    if (!this._feedButton)
      this._feedButton = document.getElementById("feed-button");

    var erel = aEvent.target.rel;
    var etype = aEvent.target.type;
    var etitle = aEvent.target.title;

    const alternateRelRegex = /(^|\s)(alternate|\S*feed\S*)($|\s)/i;
    const titleRegex = /(^|\s)(rss|atom)($|\s)/i;
  
    if (!alternateRelRegex.test(erel) || !etype)
      return;

    etype = etype.replace(/^\s+/, "");
    etype = etype.replace(/\s+$/, "");
    etype = etype.replace(/\s*;.*/, "");
    etype = etype.toLowerCase();

    if (etype == "application/rss+xml" || etype == "application/atom+xml" || 
        etype == "application/rdf+xml" || etype == "application/x.atom+xml" || 
        ((etype == "text/xml" || etype == "application/xml") && titleRegex.test(etitle)) )
    {
      const targetDoc = new XPCNativeWrapper(aEvent.target, "ownerDocument").ownerDocument;
      var shellInfo = this._getContentShell(targetDoc, targetDoc.location.href);
      var browserForLink = shellInfo.browser;

      if (!browserForLink)
        return;

      var feeds = (browserForLink.feeds != null) ? browserForLink.feeds : new Array();
      var wrapper = new XPCNativeWrapper(aEvent.target, "href", "type", "title");

      if (!wrapper.href.match(/^\w+:/))
        wrapper.href = makeURLAbsolute(targetDoc.location.href, wrapper.href);

      feeds.push({ href: wrapper.href, type: etype, title: wrapper.title});
      browserForLink.feeds = feeds;

      if (browserForLink == gBrowser || browserForLink == gBrowser.mCurrentBrowser) {
        this._feedButton.setAttribute("feeds", "true");
        this.updateFeeds();
      }
    }
  },

  initFeedMenu: function(aEvent)
  {
    // dump("\nzFeedHandler.initFeedMenu()");
    var feedList = gBrowser.mCurrentBrowser.feeds;

    if (feedList) {
      var menupopup = aEvent.target;

      if (feedList.length == 1) {
        this.showFeed(feedList[0].href);
      }
      else if (menupopup.parentNode.hasAttribute("multiple")) {
        deleteHistoryItems(menupopup); // this depends on sessionHistoryUI.js

        for (i in feedList) {
          var feedInfo = feedList[i];
          var menuitem = document.createElement("menuitem");
          var title = feedInfo.title || feedInfo.href;
          var label = this._bundle.formatStringFromName("feedShowFeed", [title], 1);

          menuitem.setAttribute("label", label);
          menuitem.setAttribute("index", index);
          menuitem.setAttribute("tooltiptext", feedInfo.href);
          menuitem.setAttribute("feed", feedInfo.href);
          menupopup.appendChild(menuitem);
        }
        return true;
      }
    }
	return false;
  },

  _process: function(callback, aXMLDocument, aURL)
  {
    // dump("\nmzFeedHandler._process()");
    var handler = this;
    handler._Stylesheet = document.implementation.createDocument("", "", null);

      function onStyleSheetLoaded() {
        handler._Stylesheet.removeEventListener("load", onStyleSheetLoaded, false);
        handler._XSLTProcessor.importStylesheet(handler._Stylesheet);
        callback(aXMLDocument, aURL);
      }
    this._Stylesheet.addEventListener("load", onStyleSheetLoaded, false);
    this._Stylesheet.load(this._StylesheetURL);
  },

  doCleanup: function()
  {
    // dump("\nmzFeedHandler.doCleanup()");
    this._targetDocument = null;
    this._XSLTProcessor = null;
    this._Stylesheet = null;
  },

  isDocumentFeed: function(aDocument)
  {
    // dump("\nmzFeedHandler.isDocumentFeed() " + aDocument);
    if (aDocument instanceof HTMLDocument) {
      dump("\nIs HTMLDocument");
      var bodyElement = aDocument.getElementsByTagName("body")[0];

      if (bodyElement) {
        dump("\nHas <body> element");
        var rssElement = bodyElement.getElementsByTagName("rss")[0];

        if (rssElement) {
          dump("\nHas <rss> element");
          var newNode = aDocument.importNode(rssElement, true);

          while (aDocument.documentElement.hasChildNodes()) {
            aDocument.documentElement.removeChild(aDocument.documentElement.lastChild);
          }
          aDocument.documentElement.appendChild(newNode);
          return true;


          dump("\nnewFragment.firstChild: " + newFragment.firstChild.localName);
          for (var i = 0; i < newFragment.firstChild.childNodes.length; i++) {
            dump("\n" + newFragment.firstChild.childNodes[i].localName);
            var newNode = targetDocument.importNode(newFragment.firstChild.childNodes[i], true);
            aDocument.documentElement.appendChild(newNode);
          }
          return true;
        }
      }
    }
    aDocument = aDocument.documentElement;

    var rootName = aDocument.localName;
    // dump("\nrootName: " + rootName);
    var rootNS = aDocument.namespaceURI;
    // dump("\nrootNS: " + rootNS);

    if (rootName == "feed" && (rootNS == this._ATOM_10_NS || rootNS == this._ATOM_03_NS)) {
      return true;
    }
    else {
      var channel;

      if (rootName == "rss" && rootNS == null) {
        channel = aDocument.getElementsByTagName('channel')[0];
      }
      else if (rootName == "RDF" && rootNS == this._RDF_NS) {
        channel = aDocument.getElementsByTagNameNS(this._RDF_NS, 'channel')[0] ||
                  /* aDocument.getElementsByTagNameNS(this._RSS_09_NS, 'channel')[0] || */
                  aDocument.getElementsByTagNameNS(this._RSS_10_NS, 'channel')[0];
      }
      if (channel && channel.parentNode == aDocument) {
        return true;
      }
    }
    return false;
  },

  isDocumentTransformedFeed: function(aDocument)
  {
    // dump("\nmzFeedHandler.isDocumentTransformedFeed()");
    var isTransformed = false;
    /***
      * The given document might already been 'XSL Transformed' so we need to check this
      * Note: The check in Mozilla Firefox fails to detect these documents as feed!
      */
    var linkElements = aDocument.getElementsByTagName('link');
 
    if (linkElements.length) {
      // There are at least two link elements, but there might be more!
      for (var i = 0; i < linkElements.length; i++) {
        if (linkElements[i].getAttribute('rel') == "stylesheet" &&
            linkElements[i].getAttribute('href') == this._feedViewerPath + "feedviewer.css")
        {
          isTransformed = true;
          break;
        }
      }
      /***
        * This should be an XSLTransformed document, or someone is totally nuts (because 
        * he used an invalid link to a chrome: stylsheet) but let's be absolutely sure
        * about it and also check for our <script> element.
        */
      if (isTransformed) {
        var scriptElement = aDocument.getElementsByTagName('script')[0];

        if (scriptElement && scriptElement.getAttribute('type') == "application/x-javascript" &&
            scriptElement.getAttribute('src') == this._feedViewerPath + "feedviewer.js")
        {
          return 2;
        }
      }
    }
    return this.validate(aDocument.documentElement);
  },

  getFeedDescription: function(aDocument, aTitle)
  {
    // dump("\nzFeedHandler.getFeedDescription()");
    var docElement = aDocument.documentElement;
    var rootName = docElement.localName;
    var rootNS = docElement.namespaceURI;
    var description;
  
    if (rootName == "feed" && (rootNS == this._ATOM_10_NS || rootNS == this._ATOM_03_NS))
      description = docElement.getElementsByTagNameNS(rootNS, 'tagline')[0];
    else if (rootName == "rss" && rootNS == null)
      description = docElement.getElementsByTagName('description')[0];
    else if (rootName == "RDF" && rootNS == this._RDF_NS)
      description = docElement.getElementsByTagNameNS(this._RDF_NS, 'description')[0];

    if (description)
      return description.textContent.length ? description.textContent : aTitle;
    else
    {
      /***
        * XSL Transformed documents will have a <meta> element which contains the description
        * Note: this will only be checked when this.isDocumentTransformedFeed() returned 2 !!
        */
      if ((aDocument instanceof HTMLDocument || aDocument instanceof XMLDocument || 
          aDocument instanceof XULDocument) && this.isDocumentTransformedFeed(docElement) == 2)
      {
        var metaElement = docElement.getElementsByTagName('meta');

        for (var i = 0; i < metaElement.length; i++) {
          description = (metaElement[i].getAttribute('name') == 'Description' && 
                         metaElement[i].hasAttribute('content'))

          if (description) {
            description = metaElement[i].getAttribute('content');
            return description.length ? description: aTitle;
          }
        }
      }
    }
    return aTitle;
  },

  transformFeed: function(aXMLDocument, aFeedURL)
  {
    // dump("\nmzHandler.transformFeed() START " + new Date().valueOf());
    var handler = mzFeedHandler;
    var bundle = handler._bundle;
    var processor = handler._XSLTProcessor;
    var xmldoc = aXMLDocument;

    aFeedURL = aFeedURL || xmldoc.documentURI;
    processor.setParameter(null, "url", aFeedURL);
    processor.setParameter(null, "title", bundle.GetStringFromName("feedTitle").replace(/[&lt;|<]([^>|&]*)(&gt;|>)/g, "")); // .replace(/<([^>]*)>/g, ""));
    processor.setParameter(null, "titleHeader", bundle.GetStringFromName("feedTitleHeader"));

    var description = xmldoc.getElementsByTagName("description")[0] ||
                      xmldoc.getElementsByTagName("tagline")[0] ||
                      xmldoc.getElementsByTagName("title")[0];

    processor.setParameter(null, "description", description.textContent.replace(/[&lt;|<]([^>|&]*)(&gt;|>)/g,"")); // .replace(/<([^>]*)>/g, ""));

    var articleCount = xmldoc.getElementsByTagName("item").length ||
                       xmldoc.getElementsByTagName("entry").length;

    processor.setParameter(null, "articleCount", bundle.formatStringFromName("feedDescription", [articleCount], 1));
    processor.setParameter(null, "currentBuildDate", new Date().toUTCString());
    processor.setParameter(null, "versionInfo", bundle.GetStringFromName("feedSoftware"));
    // XXX Localize me!!!
    processor.setParameter(null, "previousArticleTitle", "Previous Article");
    processor.setParameter(null, "nextArticleTitle", "Next Article");
    processor.setParameter(null, "firstArticleTitle", "First Article");
    processor.setParameter(null, "subscribeButtonText", "Subscribe to feed...");
    processor.setParameter(null, "subscribeButtonTitle", "Use this button to receive automatic updates");
    processor.setParameter(null, "shortcutKeys", "PNFS");

    const Cc = Components.classes;
    const Ci = Components.interfaces;
    // Disables all loading of external documents, such as from <xsl:import> and document()
    processor.flags |= Ci.nsIXSLTProcessorPrivate.DISABLE_ALL_LOADS;

    var targetDocument = handler._targetBrowser.contentDocument;
    dump("\ntargetDocument: " + targetDocument); // [object XPCNativeWrapper [object XMLDocument]]
    var newFragment = processor.transformToFragment(xmldoc, targetDocument);
    var articleContainer = newFragment.firstChild.getElementsByTagName("div")[4];
    var articles = articleContainer.childNodes;

    for (var i = 0; i < articles.length; i++) {
      var linkBox = articles[i].firstChild.childNodes[2].lastChild;
      var url = linkBox.lastChild.href;

      if (url != "") {
        var uri = handler._nsIIOService.newURI(url, null, null);
        this.gBrowser.loadFavIcon(uri, "src", linkBox.firstChild);

        if (handler._nsIGlobalHistory.isVisited(uri))
          articles[i].setAttribute("visited", true);// articleContainer.removeChild(articles[i]);
      }
    }
    // targetDocument = xmldoc;
    _documentElement = targetDocument.documentElement;
    // dump("\n_documentElement.firstChild: " + _documentElement.firstChild);
    // Remove everything up to the document's <head> element
    while (_documentElement.hasChildNodes()) {
      _documentElement.removeChild(_documentElement.lastChild);
    }
    dump("\n_documentElement.firstChild: " + _documentElement.firstChild);
    // Import <head> and <body> elements from the document fragment
    for (var i = 0; i < newFragment.firstChild.childNodes.length; i++) {
      var newNode = targetDocument.importNode(newFragment.firstChild.childNodes[i], true);
      _documentElement.appendChild(newNode);
    }
    // Get the title
    var h1s = targetDocument.getElementsByTagName("h1");
    // Do we have a title?
    if (h1s.length) 
      targetDocument.title = h1s[0].textContent;

    var subscribeButton = targetDocument.getElementById("subscribeButton");

    if (handler.webFeedService == undefined)
      handler.init();

    if (handler.webFeedService.isNewFeedURL(aFeedURL)) {
      subscribeButton.addEventListener("click", function(event){handler.subscribeFromButton(event, aFeedURL);}, true);
      subscribeButton.addEventListener("keyup", function(event){handler.subscribeFromButton(event, aFeedURL);}, true);
    }
    else
      subscribeButton.parentNode.style.display = "none";

    handler.doCleanup();
    // dump("\nmzHandler.transformFeed() STOP  " + new Date().valueOf());
  },

  /* showFeedInBrowser: function(aURL, aBrowser)
  {
    // dump("\nmzHandler.showFeedInBrowser");
    this._targetBrowser = aBrowser;
    this.getXMLDocument(aURL, "show");
  },

  isFeedLoad: function(aURL, aBrowser)
  {
    // dump("\nmzHandler.isLoadingAFeed: " + aURL);
    var xmlRequest = new XMLHttpRequest();
    var mimeTypeRegEx = /(^|\s)(application|text)\/(xml|rss\+xml|atom\+xml|rdf\+xml)($|\s)/i

    xmlRequest.open("HEAD", aURL, true);
    xmlRequest.onreadystatechange = function()
    {
      if (xmlRequest.readyState == 4) {
        var contentType = xmlRequest.getResponseHeader("Content-Type");

        if (mimeTypeRegEx.test(contentType)) {
          // dump("\nIS FEED: " + contentType);
          aBrowser.isFeed = true;
        }
      }
    }
    xmlRequest.send(null);
  }, */

  getFeedInfoFromDocument: function(aDocument)
  {
    // dump("\nmzHandler.getFeedInfoFromDocument()" + aDocument);
    var rootNode = aDocument.documentElement;
    var feedInfo = [ "", "", "", "", "", "", "", "" ];
    var imageAtributes = [ "", "", "", "" ];
    var version = rootNode.getAttribute("version");
    feedInfo[0] = rootNode.localName;
    feedInfo[0] += (version) ? " " + version : "";
    feedInfo[6] = imageAtributes;
    var date, hasLastModifiedDate, mostRecentDate = 0;
    var nodes = aDocument.createTreeWalker(rootNode, 1, null, true);
    var node = nodes.currentNode;

    while (node != null) {
      var _nodeName = node.nodeName;

      if (!_nodeName.match(/^rdf:/)) {
        if (hasLastModifiedDate == undefined) {
          if (_nodeName == "title" && feedInfo[3] == "") {
            feedInfo[3] = node.textContent.replace(/<([^>]*)>/g, "").replace(/\s/g, " ");
          }
          else if (_nodeName == "link" && feedInfo[4] == "") {
            feedInfo[4] = (rootNode.localName == "feed") ? node.getAttribute("href") : node.textContent.replace(/[&lt;|<]([^>|&]*)(&gt;|>)/g,""); //.replace(/<([^>]*)>/g, "");
          }
          else if ((_nodeName == "description" || _nodeName == "tagline") && feedInfo[5] == "") {
            feedInfo[5] = node.textContent.replace(/([&lt;|<])([^>|&]*)(&gt;|>)/g, "");// .replace(/<([^>]*)>/g, "");
          }
          else if (_nodeName == "image") {
            var imgSiblings = aDocument.createTreeWalker(node, 1, null, true);
            var sibling = imgSiblings.currentNode;

            while (sibling != null) {
              _nodeName = sibling.nodeName;

              if (_nodeName == "url")
                imageAtributes[0] = sibling.textContent;
              else if (_nodeName == "title")
                imageAtributes[1] = sibling.textContent.replace(/[&lt;|<]([^>|&]*)(&gt;|>)/g,"").replace(/\s/g, " "); // replace(/<([^>]*)>/g, "").replace(/\s/g, " ");
              else if (_nodeName == "width")
                imageAtributes[2] = sibling.textContent;
              else if (_nodeName == "height")
                imageAtributes[3] = sibling.textContent;

              sibling = imgSiblings.nextNode();
            }
            feedInfo[6] = imageAtributes;
          }
        }
        if ((_nodeName == "dc:date" || _nodeName == "lastBuildDate" || _nodeName == "modified" || _nodeName == "pubDate" ||
            _nodeName == "issued" || _nodeName == "updated") && feedInfo[7] == "")
        {
          date = node.textContent;

          if (date.search(/^\d\d\d\d/) != -1)
            date = this._W3CToIETFDate(date);
          date = new Date(date.replace(/BST|IST$/, "GMT +0100")).getTime();

          if (isNaN(date))
            dump("\ninvalid date: " + feedInfo[3]);

          if (hasLastModifiedDate == undefined)
            feedInfo[7] = date;
          else if (date > mostRecentDate)
            mostRecentDate = date;
        }
        if (_nodeName == "item" || _nodeName == "entry") {
          hasLastModifiedDate = (feedInfo[7] != "");

          if (hasLastModifiedDate)
            break;
        }
      }
      node = nodes.nextNode();
    }
    if (!hasLastModifiedDate && mostRecentDate) {
      // dump("\nSetting lastBuildDate from item/entry");
      feedInfo[7] = mostRecentDate;
    }
    return feedInfo;
  },

  getDataCollectionFromDocument: function(aDocument, aDataCollection)
  {
    // dump("\nmzHandler.getDataCollectionFromDocument() " + aDocument);
    var rootNode = aDocument.documentElement;
    var rootNS = rootNode.namespaceURI;
    // dump("\nrootNode.localName: " + rootNode.localName);
    var articleTag = (rootNode.localName == "feed") ? "entry" : "item"
    var articles = aDocument.getElementsByTagName(articleTag);
    var dataCollection = new Array();
    var feedInfo = (aDataCollection == undefined) ? this.getFeedInfoFromDocument(aDocument) : aDataCollection;
    dataCollection[0] = feedInfo;

    for (var i = 0; i < articles.length; i++) {
      var nodes = aDocument.createTreeWalker(articles[i], 1, null, true);
      var node = nodes.currentNode;
      var articleInfo = new Object();
      var collectedNodes = 0;

      while (node != null) {
        var titleFromLink = "";
        var articleLink = "";
        var _nodeName = node.nodeName;

        if (_nodeName == "title") {
          articleInfo.title = node.textContent.replace(/[&lt;|<]([^>|&]*)(&gt;|>)/g,"").replace(/\s/g, " "); // replace(/<([^>]*)>/g, "").replace(/\s/g, " ");
          collectedNodes++;
        }
        else if (_nodeName == "link") {
          var rel = node.getAttribute("rel");

          if (rel && rel.match(/^[service.|self|edit]/)) {
            // skip 'service.edit' See also bug 16912
          }
          else {
            articleLink = (articleTag == "entry") ? node.getAttribute("href") : node.textContent;
            articleInfo.url = (articleLink) ? articleLink.replace(/[&lt;|<]([^>|&]*)(&gt;|>)/g,"").replace(/\s/g, " ") : ""; // articleLink.replace(/<([^>]*)>/g, "").replace(/\s/g, " ") : "";
            titleFromLink = node.getAttribute("title");
            collectedNodes++;
          }
        }
        else if (_nodeName == "updated" || _nodeName == "modified" || _nodeName == "published" || 
                 _nodeName == "pubDate" || _nodeName == "dc:date" || _nodeName == "issued")
        {
          if (articleInfo.published == undefined) {
            var date = node.textContent;
            // Do we have 4 digits at the start i.e. "2004-09-13T09:54:04-08:00"
            if (date.search(/^\d\d\d\d/) != -1)
              date = this._W3CToIETFDate(date);
            date = new Date(date.replace(/BST|IST$/, "GMT +0100"));
            date = new Date(date).getTime();
            articleInfo.published = date;
            collectedNodes++;
          }
        }
        else if (_nodeName == "description" || _nodeName == "content") {
          var text = node.textContent.replace(/<([^>]*)>/g, "").replace(/\s/g, " ");
          var len = text.length;

          if (len > this.infoHeaderLength) {
            len = this.infoHeaderLength;
            articleInfo.infoHeader = text.substr(0, len) + " ... "; // &#8230; ";
          }
          else {
            articleInfo.infoHeader = text; 
          }
          collectedNodes++;
        }
        else if (_nodeName == "enclosure") {
          var enclosure = new Object();
          enclosure.url = node.getAttribute("url");
          enclosure.length = node.getAttribute("length");
          enclosure.type = node.getAttribute("type");
          articleInfo.enclosure = enclosure;
          collectedNodes++;
        }
        if (articleInfo.title == undefined && titleFromLink)
          articleInfo.title = titleFromLink;
        if (collectedNodes == 5) // Bail out as early as we can!
          node = null;
        else
          node = nodes.nextNode();
      }
      dataCollection.push(articleInfo);
    }
    /* if (dataCollection.length >= 1) {
      function sortByDate(a, b)
      {
        if (a.published < b.published) return 1;
        if (a.published > b.published) return -1;
        return 0;
      }
      dataCollection.splice(0, 1);
      dataCollection = dataCollection.sort(sortByDate);
      dataCollection.splice(0, 0, feedInfo);
      return dataCollection;
    }
    return null; */
    return (dataCollection.length >= 1) ? dataCollection : null;
  },

  addFeedFromDataCollection: function(aDataCollection, aRefreshFlag, aCategory)
  {
    // dump("\nmzHandler.addFeedFromDataCollection() " + aCategory);
    try {
    var feedDatasource = mzGetNewOrCurrentDSByFilename("mzWebFeeds.rdf", false, null, false);
    var category = (!aCategory) ? "urn:feeds:root" : aCategory;
    var rootContainer = mzConstructRDFContainer(feedDatasource, "seq", "urn:feeds:root", false);

    if (!rootContainer)
      return;

    var i = 1;
    var attribute = 0;
    var url = aDataCollection[0][1].replace(/www\./,'');
    var mzRDF = "http://multizilla.mozdev.org/rdf#";
    var feedContainer, property, uri, urn, orgURN;
    var checkedArticles = 0;
    var visitedLinks = 0;
    var newArticles = 0;

    if (aRefreshFlag == undefined || aRefreshFlag == false) {
      var value;
      var tabBrowser = getBrowser();

      uri = this._nsIIOService.newURI(url, null, null);
      aDataCollection[0][2] = tabBrowser.buildFavIconString(uri);

      urn = this.webFeedService.getNextURNForHost(uri.host);
      feedContainer = mzConstructRDFContainer(feedDatasource, "seq", urn, false);

      var propertyNames = [ "feed", "url", "image", "title", "link", "description", "imageUrl", 
                            "imageTitle", "imageWidth", "imageHeight", "date" ];

      for (i = 0; i < 6; i++) {
        property = mzRDF + propertyNames[i];
        value = aDataCollection[0][i];

        if (value)
          feedDatasource.Assert(RDF.GetResource(urn), RDF.GetResource(property), RDF.GetLiteral(value), true);
      }
      for (i = 6; i < 10; i++) {
        property = mzRDF + propertyNames[i];
        value = aDataCollection[0][6][attribute++];

        if (value)
          feedDatasource.Assert(RDF.GetResource(urn), RDF.GetResource(property), RDF.GetLiteral(value), true);
      }
      property = mzRDF + propertyNames[10];
      feedDatasource.Assert(RDF.GetResource(urn), RDF.GetResource(property), RDF.GetLiteral(aDataCollection[0][9]), true);
    }
    else {
      urn = aDataCollection[0][8];
      feedContainer = mzConstructRDFContainer(feedDatasource, "seq", urn, false);
    }
    // Add article entries
    for (i = 1; i < aDataCollection.length; i++) {
      var article = RDF.GetResource(urn + ":article-" + String(i));
      property = mzRDF + "title";
      var title = (aDataCollection[i].title == undefined) ? "No Title Provided" : aDataCollection[i].title;
      feedDatasource.Assert(article, RDF.GetResource(property), RDF.GetLiteral(title), true);

      if (aDataCollection[i].url != undefined) {
        property = mzRDF + "link";
        feedDatasource.Assert(article, RDF.GetResource(property), RDF.GetLiteral(aDataCollection[i].url), true);

        checkedArticles++;
        uri = this._nsIIOService.newURI(aDataCollection[i].url, null, null);

        if (this._nsIGlobalHistory.isVisited(uri)) {
          property = mzRDF + "state";
          feedDatasource.Assert(article, RDF.GetResource(property), RDF.GetLiteral("visited"), true);        
          visitedLinks++;
        }
        else {
          newArticles++;
        }
      }
      if (aDataCollection[i].infoHeader) {
        property = mzRDF + "infoHeader";
        var infoHeader = aDataCollection[i].infoHeader;
        // dump("\ninfoHeader-1: " + infoHeader.length);
        infoHeader = infoHeader.replace(/&amp;#(\d?\d?\d?\d?);/g, "&#$1;"); // ' … '); // &#$1;');
        // dump("\ninfoHeader-2: " + infoHeader.length);
        feedDatasource.Assert(article, RDF.GetResource(property), RDF.GetLiteral(infoHeader), true);
      }
      var date;

      if (aDataCollection[i].published) {
        date = aDataCollection[i].published;
        property = mzRDF + "published";
        feedDatasource.Assert(article, RDF.GetResource(property), RDF.GetLiteral(date), true);
      }
      else {
        date = aDataCollection[0][7];
      }
      if (date) {
        property = mzRDF + "prettydate";
        date = new Date(date).toUTCString();
        var prettyDate = date.substr(5, 11);
        feedDatasource.Assert(article, RDF.GetResource(property), RDF.GetLiteral(prettyDate), true);
      }
      feedContainer.AppendElement(article);
    }
    if (category == "urn:feeds:root") {
      if (rootContainer.IndexOf(RDF.GetResource(urn)) == -1)
        rootContainer.AppendElement(RDF.GetResource(urn));
    }
    else {
      var categoryContainer = mzConstructRDFContainer(feedDatasource, "seq", category, false);

      if (categoryContainer.IndexOf(RDF.GetResource(urn)) == -1)
        categoryContainer.AppendElement(RDF.GetResource(urn));

      if (rootContainer.IndexOf(RDF.GetResource(category)) == -1)
        rootContainer.AppendElement(RDF.GetResource(category));
    }
    mzAddOrChangeProperty(feedDatasource, urn, "lastModified", String(aDataCollection[0][7]));
    this.webFeedService.addFeedToFeedCache(RDF.GetResource(urn), url);

    /* dump("\nnewArticles : " + newArticles + 
         "\nvisitedLinks: " + visitedLinks + 
         "\narticles    : " + (aDataCollection.length - 1)); */

    var state = null;

    if (newArticles)
      state = "new";
    else if (visitedLinks == (aDataCollection.length - 0))
      state = "";

    this.webFeedService.hasNewArticles(RDF.GetResource(urn), true, state);
    mzFlushDataSource(feedDatasource);

    } catch(ex) { dump("\n\nEX article: " + i + " : " + ex + "\n\n"); }
  },

  subscribeFromButton: function(aEvent, aURL)
  {
    var key = aEvent.keyCode;
  
    if (aEvent.type == "keyup" && key != 13 && key != 32)
      return;

    var target = aEvent.target;

    while (target.localName != "div") {
      target = target.parentNode;
    }
    if (this.openAddFeedWindow(aURL))
      target.style.display = "none";
  },

  openAddFeedWindow: function(aURL)
  {
    if (aURL && this.webFeedService.isNewFeedURL(aURL) == false) {
      var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                    .getService(Components.interfaces.nsIPromptService);
      var title = gBundle.getString("duplicatedFeedAlertTitle");
      var text = gBundle.getString("duplicatedFeedAlertText");
      promptService.alert(window, title, text);
    }
    else {
      var windowStyle = gMultiZilla.prefs.readBoolean("multizilla.windows.classic-style", false);
      var isMac = /Mac/.test(navigator.platform) || gMultiZilla.prefs.readBoolean("multizilla.windows.mac-style", false);
      window.openDialog("chrome://multiviews/content/feedpanel/miscellaneous/addFeedWindow.xul", 
                        "", "chrome, dependent, modal", window, top.document.defaultView, aURL, null, null, windowStyle, isMac, true);

      if (this._newFeedAdded) {
        var shouldShowWebFeedPanel = gMultiZilla.prefs.readBoolean("multizilla.sidebar.feed-panel.open-after-add", true);

        if (shouldShowWebFeedPanel)
          gMultiZilla.feeds.openWebFeedsSideBarPanel(true);

        return true;
      }
    }
    return false;
  },

  _W3CToIETFDate: function(dateString)
  {  
    var parts = dateString.match(/(\d\d\d\d)(-(\d\d))?(-(\d\d))?(T(\d\d):(\d\d)(:(\d\d)(\.(\d+))?)?(Z|([+-])(\d\d):(\d\d))?)?/);
    var date = new Date(parts[1], parts[3]-1, parts[5], parts[7] || 0, parts[8] || 0, parts[10] || 0, parts[12] || 0);
    var remoteToUTCOffset = 0;

    if (parts[13] && parts[13] != "Z") {
      var direction = (parts[14] == "+" ? 1 : -1);
      if (parts[15])
        remoteToUTCOffset += direction * parts[15] * 3600000; // HOURS_TO_MILLISECONDS
      if (parts[16])
        remoteToUTCOffset += direction * parts[16] * 60000; // MINUTES_TO_MILLISECONDS
    }
    remoteToUTCOffset = remoteToUTCOffset * -1;
    var UTCToLocalOffset = date.getTimezoneOffset() * 60000; // MINUTES_TO_MILLISECONDS
    UTCToLocalOffset = UTCToLocalOffset * -1;
    date.setTime(date.getTime() + remoteToUTCOffset + UTCToLocalOffset);
    return date.toUTCString();
  }

};


