/***
  * For license info visit: http://multizilla.mozdev.org/docs/license.html
  *
  * The Original Developer of this source code is HJ van Rantwijk.
  * Portions created by HJ van Rantwijk are Copyright (C) 2004
  * by HJ van Rantwijk.  All Rights Reserved.
  *
  * Special thanks to: CSS for releasing my work on 30 October 2004
  *                    as Open Source code.  Thank you very much!
  * 
  * Contributor(s):
  *    Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  *
  */

const DC_INFO_ARRAY   = 0;
const DC_TYPE         = 0;
const DC_URL          = 1;
const DC_FAVICON      = 2;
const DC_TITLE        = 3;
const DC_LINK         = 4;
const DC_DESCRIPTION  = 5;
const DC_IMAGE        = 6;
const DC_LASTMODIFIED = 7;

const NO_ERROR        = 0;
const DUPLICATE_ERROR = 1;
const NO_FEED_ERROR   = 2;
const DOC_TYPE_ERROR  = 3;
const DOC_EMPTY_ERROR = 4;

const DC_IMAGE_URL    = 0;
const DC_IMAGE_TITLE  = 1;
const DC_IMAGE_WIDTH  = 2;
const DC_IMAGE_HEIGHT = 3;

var gNavigatorWindow, gEntryField, gErrorCode, gAcceptState = false;
var gDataCollection, gAcceptButton, gImageStat, gBundle, gCategory;

var gAddFeedWindow =
{

  selectWindowStyling: function(aDocumentElement)
  {
    const isLinux = /Linux/.test(navigator.platform);

    if ('arguments' in window) {
      if (window.arguments[5].isClassicStyle)
        aDocumentElement.removeAttribute("extraStyling");
      if (isLinux)
        aDocumentElement.setAttribute("extraStyling", "linux");  
      if (window.arguments[5].isMac)
        aDocumentElement.setAttribute("macStyling", "true");
    }
  },

  initDialog: function()
  {
    // open arguments are: window, navigatorWindow, aURL, aCategory, aTargetResource, windowStyle, isMac, autoCheck
    gAddFeedWindow.selectWindowStyling(document.documentElement);
    gEntryField = document.getElementById("EntryField");
    var url = window.arguments[2];
    gCategory = window.arguments[3];
    gEntryField.value = isValidURL(url) ? url : "http://";
    gNavigatorWindow = window.arguments[1];
    gAcceptButton = document.documentElement.getButton('accept');
    gBundle = document.getElementById("multizilla-properties");
  
    if (window.arguments.length == 8 && window.arguments[7] == true)
      onAccept();
    else
      onTextboxChange();
  }
};

/* Everything below this line must be converted / re-written!!! */ 

function getFeedInfo(aURL)
{
  var tabbrowser = gNavigatorWindow.getBrowser();
  var xmlRequest = new XMLHttpRequest();
  var handler = this;

  const mzWebFeedService = new Components.Constructor("@multizilla.org/webfeed-service;1", "nsIWebFeedService");
  var webFeedService = new mzWebFeedService();

  document.documentElement.getButton('accept').setAttribute("image", "chrome://multiviews/content/images/throbber/Throbber-small.gif");
  gErrorCode = 0;

  xmlRequest.open("GET", aURL);
  xmlRequest.setRequestHeader("User-Agent", "The MultiZilla Feed Reader/Viewer");
  xmlRequest.overrideMimeType("application/xml");
  xmlRequest.onerror = function(event) { onXMLError(event); };
  xmlRequest.onload = function()
  {
    gErrorCode = 0;

    if (xmlRequest.readyState == 4) {
      var channel = xmlRequest.channel.QueryInterface(Components.interfaces.nsIHttpChannel);
      var xmldoc = (channel && channel.responseStatus == 200) ? xmlRequest.responseXML : null;

      if (xmldoc) { 
        if (!(xmldoc instanceof XMLDocument && xmldoc instanceof XULDocument)) {
          if (gNavigatorWindow.mzFeedHandler.isDocumentFeed(xmldoc)) {
            if (webFeedService.isNewFeedURL(aURL)) {
              var dataCollection = gNavigatorWindow.mzFeedHandler.getFeedInfoFromDocument(xmldoc);
              dataCollection[DC_URL] = aURL;
              var _nsIIOService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
              var uri = _nsIIOService.newURI(aURL, null, null);
              dataCollection[DC_FAVICON] = tabbrowser.buildFavIconString(uri);
              dataCollection = gNavigatorWindow.mzFeedHandler.getDataCollectionFromDocument(xmldoc, dataCollection);
              displayFeedInfo(dataCollection);
              return(NO_ERROR);
            }
            return displayErrorMessage(DUPLICATE_ERROR);
          }
          return displayErrorMessage(NO_FEED_ERROR);
        }
        return displayErrorMessage(DOC_TYPE_ERROR);
      }
      return displayErrorMessage(DOC_EMPTY_ERROR);
    }
    return(NO_ERROR);
  }
  xmlRequest.send(null);
}

function onXMLError(aEvent)
{
  var request, status;

  try {
    request = aEvent.target;
    status = request.status;
  }
  catch(ex) {
    request = aEvent.target.channel.QueryInterface(Components.interfaces.nsIRequest);
    status = request.status;
  }
  if (status > 2152398848) // see: http://lxr.mozilla.org/seamonkey/source/netwerk/base/public/nsNetError.h
    status -= status;
    displayErrorMessage(status);
}

function displayErrorMessage(aErrorCode)
{
  if (gErrorCode >= 0) {
    gPreviousErrorCode = aErrorCode;
    document.documentElement.getButton('accept').removeAttribute("image");
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
    var title = gBundle.getString("addFeedWindowAlertTitle");
    var errorHeader = gBundle.getString("addFeedWindowError");
    var errors = gBundle.getString("addFeedWindowErrorText");
    errors = errors.split(',');
    var text = gBundle.getString("addFeedWindowAlertText");
    text = text + errorHeader + " " + errors[aErrorCode] + "\n";
    promptService.alert(window, title, text);
  }
}

function displayFeedInfo(aDataCollection)
{
  /* Images take time to load so let's do those first */
  var feedImageURL = aDataCollection[DC_INFO_ARRAY][DC_IMAGE][DC_IMAGE_URL];

  if (feedImageURL)
    document.getElementById("FeedImage-dummy").setAttribute("src", feedImageURL);

  var feedFaviconURL = aDataCollection[DC_INFO_ARRAY][DC_FAVICON];

  if (feedFaviconURL)
    document.getElementById("FeedImage-dummyFavicon").setAttribute("src", feedFaviconURL);

  var element;
  var mzRDF = "http://multizilla.mozdev.org/rdf#";
  var elementIDArray = [ "Type", "Title", "Url", "Description", "LastModified" ];
  var attributeArray = [ "value", "value", "value", "value", "value" ];
  var dataIndexArray = [ DC_TYPE, DC_TITLE, DC_URL, DC_DESCRIPTION, DC_LASTMODIFIED ];

  for (var i = 0; i < 5; i++) {
    element = document.getElementById(elementIDArray[i]);
    element.setAttribute(attributeArray[i], aDataCollection[DC_INFO_ARRAY][dataIndexArray[i]]);
  }
  document.getElementById("ItemCounter").value = aDataCollection.length;
  var lastModified = "No Date Specified";
  var lastModifiedDate = aDataCollection[DC_INFO_ARRAY][DC_LASTMODIFIED];

  if (lastModifiedDate) {
    lastModified = new Date(aDataCollection[DC_INFO_ARRAY][DC_LASTMODIFIED]).toUTCString();
  }
  document.getElementById("LastModified").value = lastModified;

  if (feedImageURL)
    document.getElementById("FeedImageBox").removeAttribute("collapsed");

  document.getElementById("EntryFieldBox").setAttribute("collapsed", "true");
  document.getElementById("FeedURLNote").setAttribute("collapsed", "true");
  document.getElementById("FeedInfoBox").removeAttribute("collapsed");
  document.title = document.getElementById("FeedInfoTitle").getAttribute("title");
  gAcceptButton.removeAttribute("image");
  gAcceptButton.setAttribute("type", "add");
  gAcceptButton.label = gBundle.getString("addFeedWindowAddFeed");
  sizeToContent();
  gDataCollection = aDataCollection;
  gAcceptState = true;
}

function onTextboxChange()
{
  if (isValidURL(gEntryField.value))
    gAcceptButton.removeAttribute("disabled");
  else 
    gAcceptButton.setAttribute("disabled", "true");
}

function onHelp()
{
  var helpPages = gBundle.getString("helpPages-AddFeedWindow");
  var tabBrowser = gNavigatorWindow.getBrowser();
  tabBrowser.addOrGetTab(helpPages);
  onCancel();
  window.close();
}

function onCancel()
{
  gNavigatorWindow.mzFeedHandler._newFeedAdded = false;
}

function onAccept()
{
  gNavigatorWindow.mzFeedHandler._newFeedAdded = true;

  if (!gAcceptState) {
    var url = gEntryField.value;

    if (isValidURL(url))
      getFeedInfo(url);
  }
  else {
    gDataCollection[DC_INFO_ARRAY][DC_TITLE] = document.getElementById("Title").value;
    gDataCollection[DC_INFO_ARRAY][DC_DESCRIPTION] = document.getElementById("Description").value;

    gDataCollection[0][9] = new Date().getTime();
    var dummy = gNavigatorWindow.mzFeedHandler.addFeedFromDataCollection(gDataCollection, false, gCategory);
    gAcceptState = true;
  }
  return gAcceptState;
}

function onImageLoad(aElement)
{
  var element, imageURL = aElement.getAttribute("src");
  // dump("\nonImageLoad() " + aElement.id);

  if (aElement.id == "FeedImage-dummy") {
    element = document.getElementById("FeedImage");
    element.setAttribute("src", imageURL);

    var width = gDataCollection[DC_INFO_ARRAY][DC_IMAGE][DC_IMAGE_WIDTH];
    var height = gDataCollection[DC_INFO_ARRAY][DC_IMAGE][DC_IMAGE_HEIGHT];

    if (width)
      element.setAttribute("width", width);
    if (height)
      element.setAttribute("height", height);
  }
  if (aElement.id == "FeedImage-dummyFavicon")
    document.getElementById("FeedImageFavicon").setAttribute("src", imageURL);
}

function isValidURL(aURL)
{
  // aURL must be a string
  if (aURL && typeof(aURL) == "string") {
    // Check for "http[s]://" at the beginning of the URL
    if (aURL.match(/^https?:\/\//) == null)
      return -1;
    // Check for "/foo.bar" at the end of the URL
    if (aURL.match(/\/\S*\.\S*$/) == null)
      return -2;
    // URL is fine/matched our criteria
    return true;
  }
  return false;
}

