

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom;

//Java imports
import java.util.*;
import java.util.concurrent.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;
import org.mozilla.dom.events.*;
import org.mozilla.dom.ranges.*;
import org.mozilla.dom.traversal.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class ElementImpl extends NodeImpl implements org.w3c.dom.Element
{


    public nsIDOMElement getInstance()
    {
	return getInstanceAsnsIDOMElement();
    }

    /***************************************************************
     *
     * Element implementation code
     *
     ***************************************************************/

    public ElementImpl(nsIDOMElement mozInst)
    {
        super( mozInst );
    }

    public static ElementImpl getDOMInstance(nsIDOMElement mozInst)
    {
        
        ElementImpl node = (ElementImpl) instances.get(mozInst);
        return node == null ? new ElementImpl(mozInst) : node;
    }

    public nsIDOMElement getInstanceAsnsIDOMElement()
    {
        if (moz==null)
            return null;
        else
            return (nsIDOMElement) moz.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
    }

    public void removeAttributeNS(final String namespaceURI, final String localName)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMElement().removeAttributeNS(namespaceURI, localName);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public TypeInfo getSchemaTypeInfo()
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public boolean hasAttributeNS(final String namespaceURI, final String localName)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = getInstanceAsnsIDOMElement().hasAttributeNS(namespaceURI, localName);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void removeAttribute(final String name)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMElement().removeAttribute(name);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public String getAttribute(final String name)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMElement().getAttribute(name);
                                /* Case insensitivity patch */
                    if (result!=null && NodeFactory.getConvertNodeNamesToLowerCase())
                        return result.toLowerCase();
                    else
                        return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public NodeList getElementsByTagName(final String name)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<NodeList> c = new Callable<NodeList>() { public NodeList call() {
            nsIDOMNodeList result = getInstanceAsnsIDOMElement().getElementsByTagName(name);
            return new NodeListImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Attr setAttributeNodeNS(final Attr newAttr)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMAttr mozNewattr = newAttr!=null ? ((AttrImpl) newAttr).getInstance() : null;
        Callable<Attr> c = new Callable<Attr>() { public Attr call() {
            nsIDOMAttr result = getInstanceAsnsIDOMElement().setAttributeNodeNS(mozNewattr);
            return (Attr) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setAttribute(final String name, final String value)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMElement().setAttribute(name, value);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public NodeList getElementsByTagNameNS(final String namespaceURI, final String localName)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<NodeList> c = new Callable<NodeList>() { public NodeList call() {
            nsIDOMNodeList result = getInstanceAsnsIDOMElement().getElementsByTagNameNS(namespaceURI, localName);
            return new NodeListImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getTagName()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMElement().getTagName();
                                /* Case insensitivity patch */
                    if (result!=null && NodeFactory.getConvertNodeNamesToLowerCase())
                        return result.toLowerCase();
                    else
                        return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Attr getAttributeNode(final String name)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Attr> c = new Callable<Attr>() { public Attr call() {
            nsIDOMAttr result = getInstanceAsnsIDOMElement().getAttributeNode(name);
            return (Attr) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setIdAttributeNode(final Attr idAttr, final boolean isId)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMAttr mozIdattr = idAttr!=null ? ((AttrImpl) idAttr).getInstance() : null;
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public Attr getAttributeNodeNS(final String namespaceURI, final String localName)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Attr> c = new Callable<Attr>() { public Attr call() {
            nsIDOMAttr result = getInstanceAsnsIDOMElement().getAttributeNodeNS(namespaceURI, localName);
            return (Attr) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Attr setAttributeNode(final Attr newAttr)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMAttr mozNewattr = newAttr!=null ? ((AttrImpl) newAttr).getInstance() : null;
        Callable<Attr> c = new Callable<Attr>() { public Attr call() {
            nsIDOMAttr result = getInstanceAsnsIDOMElement().setAttributeNode(mozNewattr);
            return (Attr) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setAttributeNS(final String namespaceURI, final String qualifiedName, final String value)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMElement().setAttributeNS(namespaceURI, qualifiedName, value);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void setIdAttribute(final String name, final boolean isId)
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public boolean hasAttribute(final String name)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = getInstanceAsnsIDOMElement().hasAttribute(name);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getAttributeNS(final String namespaceURI, final String localName)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMElement().getAttributeNS(namespaceURI, localName);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setIdAttributeNS(final String namespaceURI, final String localName, final boolean isId)
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public Attr removeAttributeNode(final Attr oldAttr)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMAttr mozOldattr = oldAttr!=null ? ((AttrImpl) oldAttr).getInstance() : null;
        Callable<Attr> c = new Callable<Attr>() { public Attr call() {
            nsIDOMAttr result = getInstanceAsnsIDOMElement().removeAttributeNode(mozOldattr);
            return (Attr) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }



}
