/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Extension Updater.
 *
 * The Initial Developer of the Original Code is
 * IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2003-2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   doronr@us.ibm.com (Original Author)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
    Extension Updater v0.1
*/

/**
 * nsExtensionUpdater
 *
 * JavaScript Class Cunstructor for updating an extension.
 *
 * @param aUpdateXMLLocation   location of the XML file with update info
 *                             in the format of example.xml 
 * @param aCurrentVersion      the version of the currently installed 
 *                             extension
 * @param aJarFileName         name of the jar file to use in the local 
 *                             file system
 *
 * @return                     class
 *
 */ 
function nsExtensionUpdater(aUpdateXMLLocation, aCurrentVersion, aJarFileName){
  this.updateXMLLocation = aUpdateXMLLocation;
  this.currentInstalledVersion = aCurrentVersion;
  this.jarFileName = aJarFileName;

  this.latestVersion = null;
  this.latestVersionLocaton = null;
  
  this.status = "null";
  this.xmlRequest = new XMLHttpRequest();
  this.progressFunc = null;  
}

/**
 * nsExtensionUpdater :: getUpdate
 *
 * initiates the updating
 *
 * @param aProgressFunction   function reference to call for certain
 *                            progress states
 *
 * @return                 nothing.
 *
 */ 

nsExtensionUpdater.prototype.getUpdate = function EUGetUpdate(aProgressFunction){
  netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");

  this.progressFunc = aProgressFunction;

  try{
  
    // since we need a callback once the XMl data has finished arriving, we do a "lambda" and save scope
    var myThis = this;
    var lambda = function myScopeFunction(){myThis.handleArrivedXML();}
  
    this.xmlRequest.open("GET", this.updateXMLLocation);
    this.xmlRequest.onload = lambda;
    
    this.status = "Retrieving Update File";
    
    this.xmlRequest.send(null);
    
  } catch (e) {
    //alert(e);
    this.status = "Error: " + e;
    this.progressFunc(-1);
  }  

}
 
/* Private */

/* 
  handleArrivedXML is called when the update xml file is loaded
*/

nsExtensionUpdater.prototype.handleArrivedXML = function EUHandleArrivedXML(){
  netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
  
  // parse the XML
  var myDocElm = this.xmlRequest.responseXML.documentElement;

  for (var run=0; run < myDocElm.childNodes.length; run++){
    if (myDocElm.childNodes[run].nodeType != 3){
      if (myDocElm.childNodes[run].tagName == "latestVersion")
        this.latestVersion = myDocElm.childNodes[run].firstChild.nodeValue;
      else if (myDocElm.childNodes[run].tagName == "location")
        this.latestVersionLocaton = myDocElm.childNodes[run].firstChild.nodeValue;
    }
  }
  
  if (this.latestVersion > this.currentInstalledVersion){
    var rv = this.progressFunc(1);

    // if we are to proceed
    if (rv){
      //alert(this.latestVersion);
      var installRV = this.installUpdate();
      
      if (installRV)
        this.progressFunc(2);
      else
        this.progressFunc(-1);
    }
    
  } else {
    // no new updates available
    this.progressFunc(0);
  }
}

// borrowed from http://lxr.mozilla.org/seamonkey/source/extensions/irc/js/lib/utils.js#807
nsExtensionUpdater.prototype.getSpecialDirectory = function EUGetSpecialDir(name){
 
  const DS_CTR = "@mozilla.org/file/directory_service;1";
  const nsIProperties = Components.interfaces.nsIProperties;
 
  directoryService = Components.classes[DS_CTR].getService(nsIProperties);
  
  return directoryService.get(name, Components.interfaces.nsIFile);
}

/* 
  installs the update
*/
nsExtensionUpdater.prototype.installUpdate = function EUInstallUpdate(){

  netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
  
  var rv = false;
  
  // first check if there is a new update
  if (this.latestVersion > this.currentInstalledVersion){

    try{

      const IO_SERVICE_CTRID = "@mozilla.org/network/io-service;1";
      const nsIIOService = Components.interfaces.nsIIOService;      
      
      /* we want to figure out where the jar file lives - 
         mozillaDir/chrome or
         userProfile/chrome                  
      */ 
      
      var installLocation = "";

      var myLocalFile = Components.classes["@mozilla.org/file/local;1"].
                createInstance(Components.interfaces.nsILocalFile);
                
      // first text userProfile/chrome/
      myLocalFile.initWithPath(this.getSpecialDirectory("ProfD").path + "/chrome/" + this.jarFileName);

      if (myLocalFile.exists()) {
        installLocation = myLocalFile.path;
      }
      
      // so its not in userProfile/chrome/
      if (installLocation == ""){ 
        // try mozillaDir/chrome
        myLocalFile.initWithPath(this.getSpecialDirectory("XCurProcD").path + "/chrome/" + this.jarFileName);

        if (myLocalFile.exists()) {
          installLocation = myLocalFile.path;
        }        
      }  
      
      // couldn't find the jar file
      if (installLocation == "")
        return;      

      // create an nsIUri
      ioservice = Components.classes[IO_SERVICE_CTRID].getService(nsIIOService);                  
      myUri = ioservice.newURI(this.latestVersionLocaton,"",null) ; 
  
      // use nsIWebBrowserPersist to copy the file to the local filesystem
      var myWebPersist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(Components.interfaces.nsIWebBrowserPersist);
    
      myWebPersist.saveURI(myUri, null, null, null, null, myLocalFile);
      
      // success
      rv = true;
      
    } catch (e) {
      this.status = e;
      rv = false;
    }
  }
  
  return rv;
} 
