/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozCC
 *
 * The Initial Developer of the Original Code is
 * Nathan R. Yergler.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Nathan R. Yergler <nathan@yergler.net>
 *
 * ***** END LICENSE BLOCK ***** */

/* mozcc.js
 * $Id: mozcc.js,v 1.5 2004/10/11 20:38:55 nathan Exp $
 */

include(jslib_prefs);

var gBrowser = null;

// initialize the cache

var mozCCcache = {parsed  : new Array(),
                  remotes : new Array()
                 }

// ************************************************************
// * Event Handlers
// ************************************************************

// addLoadListener:
//   Retrieves a handle to the browser window and connects to 
//   the load events for catching location changes

function addLoadListener() {

  // listen for navigation events
  getBrowser().addEventListener("load", onLoadContent, true);

  // listen for tab switches
  getBrowser().addEventListener("select", onSelectTab, true);

} // addLoadListener

function onSelectTab(event) {

  docurl = _content.document.URL;

  updateRemotes(docurl);

  // reset everything to non-RDF
  clearStatusPanel(document.getElementById('cc-status'));

  if (window.mozCCcache.remotes[docurl].length > 0) {
     document.getElementById('cc_status_logo').setAttribute('src', 
                             'chrome://mozcc/skin/images/cc_working.gif');
     document.getElementById('cc_status_logo').setAttribute('alt', 
                             'downloading licenses...');
  } // if we're still retrieving remote RDF...

  // rebuild the status bar
  for (i=0; i < window.mozCCcache.parsed[docurl].length; i++) {
      updateStatusBar(window.mozCCcache.parsed[docurl][i]);
  } // for each parsed segment

} // onSelectTab

function onLoadContent(event) {

  docurl = _content.document.URL;

  // initialize cache area
  window.mozCCcache.parsed[docurl] = new Array();
  window.mozCCcache.remotes[docurl] = new Array();

  // extract any embedded RDF elements
  rdfBlocks = extractRdf(_content.document, 
                         window.mozCCcache.parsed[docurl]);

  // retrieve any linked RDF
  var rdfLinks = extractLinks(_content.document); 
  for (i=0; i < rdfLinks.length; i++) {

    // start the asynchronous retrieval
    retrieveRdf(window.mozCCcache.remotes[docurl], rdfLinks[i]);
  } // for each link 

  // call Select event handler to update UI
  onSelectTab(event);

  return true;

} // onLoadContent

// ************************************************************
// * UI Manipulation
// ************************************************************

function updateStatusBar(cc) {

   // get a handle to UI elements
   statuspanel = document.getElementById('cc-status');
   statuslogo = document.getElementById('cc_status_logo');
   works = cc.works();

   // the work reference for this page should only have one element
   if (works.length == 1) {
       licenses = works[0].licenses();
   } else if (works.length == 0) {
       licenses = cc.licenses();
   } else {
       licenses = new Array();
   }

   // change the status icon to indicate we have license info
   if (licenses.length > 0) {
      // update the status bar icon to non-crossed
      statuslogo.setAttribute('src', 
            'chrome://mozcc/skin/images/cc_status_bar.png');
   } 

   for (l = 0; l < licenses.length; l++) {
      makeLicenseImages(licenses[l], statuspanel);
   } // for each license

} //updateStatusBar

function clearStatusPanel(panel) {
   // remove all children from the parameter [panel]
   while (panel.hasChildNodes()) {
      panel.removeChild(panel.firstChild);
   }

   // add the basic CC icon
   ccIcon = createImage('chrome://mozcc/skin/images/cc_status_bar_nolic.png', 
                        'Creative Commons');
   ccIcon.setAttribute("id", "cc_status_logo");

   panel.appendChild(ccIcon);
   
   return true;
} // clearStatusPanel

// showLicense:
//   displays the license information dialog for RDF contained in [aDocument];
//   derived from "view page source" code in browser.js

function showLicense(aDocument) {

  // find out if we have any licenses
  if (window.mozCCcache.parsed[aDocument.URL].length == 0) {
     alert('No Creative Commons license available.');
  } else {
  // open a dialog displaying current license information
  openDialog("chrome://mozcc/content/license.xul", "Creative Commons License",
             "chrome,modal=no,dialog=no,resizable,titlebar,centerscreen", 
	     aDocument,window.mozCCcache.parsed[aDocument.URL]);

  }

  return true;

} // showLicense

function makeLicenseImages(license, container, showDesc) {

   statuslogo = document.getElementById('cc_status_logo');

         // check for public domain
         if (license.isPublicDomain()) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

	    // public domain; change the license class icon
      	    statuslogo.setAttribute('src', 
                'chrome://mozcc/skin/images/pd');
      	    statuslogo.setAttribute('alt', 'Public Domain');

            //imgContainer.appendChild(
            //   createImage('chrome://mozcc/skin/images/pd', 'Public Domain'));
            if (showDesc) imgContainer.appendChild(
                                       createDesc('Public Domain'));
      
            return;
         } // if public domain

         // check for sampling licenses
         if (license.isSampling()) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

	    // GPL; change the license class icon
      	    statuslogo.setAttribute('src', 
                'chrome://mozcc/skin/images/recombo.png');
      	    statuslogo.setAttribute('alt', 'Sampling');

            // imgContainer.appendChild(
            //   createImage('chrome://mozcc/skin/images/recombo.png', 
            //               'Recombo'));

            if (showDesc) imgContainer.appendChild(
                                       createDesc('Recombo: Allows Sampling'));
         } // if is sampling
         else
         if (license.isSamplingPlus()) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

	    // GPL; change the license class icon
      	    statuslogo.setAttribute('src', 
                'chrome://mozcc/skin/images/recomboplus.png');
      	    statuslogo.setAttribute('alt', 'Sampling+');

            // imgContainer.appendChild(
            //   createImage('chrome://mozcc/skin/images/recombo.png', 
            //               'Recombo+'));

            if (showDesc) imgContainer.appendChild(createDesc('Recombo+: Allows Sampling+'));
         } // if is sampling+
         else
         if (license.isDevNations()) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

	    // developing nations; change the license class icon
      	    statuslogo.setAttribute('src', 
                'chrome://mozcc/skin/images/devnations.png');
      	    statuslogo.setAttribute('alt', 'Developing Nations');

            if (showDesc) imgContainer.appendChild(createDesc('Developing Nations'));
         } // if is devnations
 	 else
	 if (license.isGPL()) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

	    // GPL; change the license class icon
      	    statuslogo.setAttribute('src', 
                'chrome://mozcc/skin/images/gpl.png');
      	    statuslogo.setAttribute('alt', 'GPL 2.0');

            // imgContainer.appendChild(
            //    createImage('chrome://mozcc/skin/images/gpl.png', 
            //                'GPL 2.0'));
            if (showDesc) imgContainer.appendChild(createDesc('GPL 2.0'));
	 } // if is GPL
	 else
	 if (license.isLGPL()) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

	    // LGPL; change the license class icon
      	    statuslogo.setAttribute('src', 
                'chrome://mozcc/skin/images/lgpl.png');
      	    statuslogo.setAttribute('alt', 'LGPL 2.1');

            // imgContainer.appendChild(
            //    createImage('chrome://mozcc/skin/images/lgpl.png', 
            //                'LGPL 2.1'));
            if (showDesc) imgContainer.appendChild(createDesc('LGPL 2.1'));
	 } // if is LGPL

         // initialize the flag for no derivatives 
         // (since it's flagged by the lack of a permission, 
         //  not a requirement/prohibition)
         no_derivs = true;
	 notice = false;
	 attribution = false;

         // extract the properties and add them to the status bar 
         requires = license.getAll('http://web.resource.org/cc/requires');
         permits  = license.getAll('http://web.resource.org/cc/permits');
         prohibits = license.getAll('http://web.resource.org/cc/prohibits');

         for (p = 0; p < requires.length; p++) {
             // get the short target name
             objt = requires[p].Value.split('/').reverse()[0];

             switch(objt.toLowerCase()) {
               case 'notice': 
                 if (!attribution) {
                   if (showDesc) {
                      imgContainer = createCont(container);
                   } else imgContainer = container;

                   imgContainer.appendChild(
                      createImage('chrome://mozcc/skin/images/attrib',
                                  'requires ' + objt));
                   if (showDesc) imgContainer.appendChild(
                      createDesc('requires ' + objt));

                   notice=true;
                 }
                 break;

               case 'attribution': 
                 if (!notice) {
                   if (showDesc) {
                      imgContainer = createCont(container);
                   } else imgContainer = container;

                   imgContainer.appendChild(
                      createImage('chrome://mozcc/skin/images/attrib',
                                  'requires ' + objt));
                   if (showDesc) imgContainer.appendChild(
                      createDesc('requires ' + objt));

                   attribution=true;
                 }
                 break;
               case 'sharealike': 
                 if (showDesc) {
                    imgContainer = createCont(container);
                 } else imgContainer = container;

                 imgContainer.appendChild(
                    createImage('chrome://mozcc/skin/images/share',
                                'requires ' + objt));
                   if (showDesc) imgContainer.appendChild(
                      createDesc('requires ' + objt));
                 break;
               case 'sourcecode': 
                 if (showDesc) {
                    imgContainer = createCont(container);
                 } else imgContainer = container;

                 imgContainer.appendChild(
                    createImage('chrome://mozcc/skin/images/source.png',
                                'requires ' + objt));
                   if (showDesc) imgContainer.appendChild(
                      createDesc('requires ' + objt));
                 break;
             } // switch on requirement

         } // for each requirement

         for (p = 0; p < permits.length; p++) {
             // get the short target name
             objt = permits[p].Value.split('/').reverse()[0];

             switch(objt.toLowerCase()) {
                                   case 'reproduction': break;
                                   case 'distribution': break;
                                   case 'derivativeworks': 
                                        no_derivs = false;
                                        break;
             } // switch target
         } // for each permission

         for (p = 0; p < prohibits.length; p++) {
             // get the short target name
             objt = prohibits[p].Value.split('/').reverse()[0];

             switch(objt.toLowerCase()) {
                                   case 'commercialuse': 
                                        if (showDesc) {
                                          imgContainer = createCont(container);
                                        } else imgContainer = container;

                                        imgContainer.appendChild(
                                           createImage(
                                          'chrome://mozcc/skin/images/noncomm',
                                           'prohibits ' + objt));
                                        if (showDesc) imgContainer.appendChild(
                                           createDesc('prohibits ' + objt));
                                        break;
             } // switch prohibition
         } // for each prohibition

         if (no_derivs) {
            if (showDesc) {
               imgContainer = createCont(container);
            } else imgContainer = container;

            imgContainer.appendChild(
               createImage('chrome://mozcc/skin/images/nomod', 
                            'prohibits DerivativeWorks'));
               if (showDesc) imgContainer.appendChild(
                            createDesc('prohibits DerivativeWorks'));
         } // if no derivatives

} // makeLicenseImages

// ************************************************************
// * RDF Handling
// ************************************************************

function retrieveRdf(queue, url) {

  var rf = new XMLHttpRequest();
  queue.push(rf);

  rf.open("GET", url, true);
  rf.onreadystatechange = changeState;

  // to prevent leaks see Mozilla bug #206947
  rf.overrideMimeType("text/xml");
  rf.send(null);

  // alert ('retrieving ' + url);

} // retrieveRdf

function delayedParse(rdf, uri, results) {

  uri = _content.document.URL;
  index = results.push(new ccRdf()) - 1;

  results[index].parse(rdf, uri);

  // onSelectTab(null);

} // delayedParse

function extractLinks(current_doc) {

  function makeAbsolute(current_doc, link_href) {

      // this is an RDF link; parse it
      if (link_href.indexOf('http://') == 0) {
         // absolute link with protocol; no massaging necessary
         return link_href;
      } else 
      if (link_href.charAt(0) == '/') {
         // absolute link; add the server
	abs_parts = current_doc.URL.split('/');

	// drop off everything after the server
	while (abs_parts.length > 3) {
	   abs_parts.pop();
	} // while more than the server
	abs_parts.push(link_href);

	return abs_parts.join('/');
      } else {
         // relative link
         abs_parts = current_doc.URL.split('/');

         // assemble the new link
         abs_parts.pop()
         abs_parts.push(link_href);

         return abs_parts.join('/');

      } // relative link

      // fall-through case (although we shouldn't be able to get here)
      return link_href;

  } // makeAbsolute

  var results = new Array();
  amp_re = /&amp\;/g;

  // ****
  // get <link rel="meta"> links from the head
 
  // get a reference to the head of the document to check for link tags
  head = current_doc.documentElement.getElementsByTagName('head');
  if (head.length > 0) {
     // has a head element
     links = head[0].getElementsByTagName('link');
  }
  
  for (i = 0; i < links.length; i++) {
    if (links[i].getAttribute('rel') == 'meta') {

      pushUnique(results, makeAbsolute(current_doc, 
                          links[i].getAttribute('href').replace(amp_re, '&')
                               ) );

    } // if the link is metadata

  }  // for each link

  // ****
  // get <a rel="license"> links from the body

  anchors = current_doc.documentElement.getElementsByTagName('a');

  for (i = 0; i < anchors.length; i++) {
     if (anchors[i].hasAttribute('rel')) {
        if (anchors[i].getAttribute('rel') == 'license') {
           pushUnique(results, makeAbsolute(current_doc, 
  		      		            anchors[i].getAttribute('href')));
        } // if rel=license
     } // if the anchor has a rel="" attr...
  } // for each anchor

  return results;

}

function extractRdf(curr_doc, results) {

  // check for embedded RDF
  rdf_regex = /<rdf:rdf[\w\W]*?<\/rdf:rdf>/i

  var inputstr = "";

  // serialize the document so we can scan for RDF
  var serializer = new XMLSerializer();
  inputstr = serializer.serializeToString(curr_doc.documentElement);

  match = "";

  // extract any embedded RDF
  while (match != null) {
     match = inputstr.match(rdf_regex);

     if (match != null) {

	// schedule the delayed parsing
	delayedParse(match[0], curr_doc.URL, results);
	// window.setTimeout(delayedParse, 0, match[0], curr_doc.URL, results);

        inputstr = inputstr.substr(inputstr.search(rdf_regex) + match[0].length, inputstr.length);
     } // if match is not null

  } // while match is not null

} // extractRdf

// ************************************************************
// * Convenience Functions
// ************************************************************

function pushUnique(anArray, toPush) {
   // push [toPush] onto [anArray] iif [toPush] not in [anArray]

   for (var j=0; j < anArray.length; j++) {
       if (anArray[j] == toPush) {
       	  // we found the element; bail out of push
	  return -1;
       }
   } // for j in...

   // didn't find the element, go ahead and push
   return anArray.push(toPush);

} // pushUnique

function getButtonVisibility() {

  var pref = new Prefs();
  return pref.getBool('mozcc.toolbar.hidden');

} // getButtonVisibility

function getBrowser()
{
  if (!gBrowser)
    gBrowser = document.getElementById("content");
  return gBrowser;
} // getBrowser

function createImage(src, tip) {
   var newimg = document.createElement("image");

   newimg.setAttribute("src", src);
   newimg.setAttribute("alt", tip);
   newimg.tooltipText = tip;

   return newimg;
}

function createDesc(value) {
   var newdesc = document.createElement("description");
   newdesc.setAttribute("value", value);

   return newdesc;
}

function createCont(parent) {
   // creates an HBox, appends it to the parent and returns a reference
   var newcont = document.createElement("hbox");
   parent.appendChild(newcont);
   return newcont;
} // createCont

function updateRemotes(docurl) {

  // parse any completed URLs
  for (i=0; i < window.mozCCcache.remotes[docurl].length; i++) {
    remote = window.mozCCcache.remotes[docurl][i];

    if (remote.readyState == 4) {
       delayedParse(remote.responseText, 
                    docurl, 
                    window.mozCCcache.parsed[docurl]);

       window.mozCCcache.remotes[docurl][i] = null;
    } // if complete
  } // for each remote

  // pop any completed remotes
  i = 0;
  while (i < window.mozCCcache.remotes[docurl].length) {
    if (window.mozCCcache.remotes[docurl][i] == null) {
       window.mozCCcache.remotes[docurl].splice(i,1);
    } else { 
       i++;
    }
  } // for each remote

} // updateRemotes

function changeState() {

   onSelectTab(null);

} //  changeState
