/*$Id: fkRequestExaminator.cpp,v 1.2 2008/05/18 10:29:01 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2008 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "plstr.h"
#include "nsMemory.h"
#include "fkIJudge.h"
#include "Firekeeper.h"
#include "fkResponseDetails.h"
#include "fkRequestExaminator.h"
#include "fkRule.h"
#include "fkSentence.h"

#include "Error.h"
#include "Common.h"

fkRequestExaminator::fkRequestExaminator()
	: connRules(rules), sentence(nsnull), 
	  url(nsnull), headers(nsnull), headers_len(0), 
	  body(nsnull), body_len(0), body_offset(0) {
	TRACE("constructor %08x", this);	
}

fkRequestExaminator::~fkRequestExaminator() {
	TRACE("destructor %08x", this);
	if (url)
		nsMemory::Free(url);
}

NS_IMETHODIMP fkRequestExaminator::Init() {
	sentence = new fkSentence();
	if (!sentence)
		return NS_ERROR_OUT_OF_MEMORY;
	sentence_external = do_QueryInterface(sentence);
	return NS_OK;
}

const fkSentence* fkRequestExaminator::GetSentence() {
	return sentence;
}

const fkSentence* fkRequestExaminator::CheckMatch(list<const Rule *> match) {
	if (sentence->action != sentence->AUDIT)
		return sentence;

	list<const Rule *>::iterator it;
	for(it = match.begin(); it != match.end(); ++it) {
		TRACE("calling judge");
		fkRule *rule_raw = new fkRule();
		if (!rule_raw) {
			// Out of memory. Blocking.
			return Block();
		}
		if (NS_FAILED(rule_raw->Init(*it))) {
			delete rule_raw;
			return Block();
		}
		nsCOMPtr<fkIRule>
			rule(do_QueryInterface(rule_raw));

		nsCOMPtr<fkIResponseDetails> details = nsnull;
		if (body || headers) {
			fkResponseDetails *details_raw;
			details_raw = new fkResponseDetails(headers, headers_len,
							    body, body_len, body_offset);
			if (!details_raw) {
				return Block();
			}
			details = do_QueryInterface(details_raw);
		}
		fkJudge->Judge(url, rule, sentence_external, details);
		TRACE("action = %d", sentence->action);
		
		if (sentence->action == sentence->BLOCK) {
			TRACE("blocking request");
			return Block();
		} else if (sentence->action == sentence->DONT_AUDIT) {
			TRACE("whitelisting request");
			return Whitelist();
		}
	}
	return NULL;
}

const fkSentence* fkRequestExaminator::CheckUrl(const char *url) {
	this->url = PL_strdup(url);
	return CheckMatch(connRules.checkURL(url, strlen(url)));
	
}

const fkSentence* fkRequestExaminator::CheckHeaders(const char *headers, PRUint32 headers_len) {
	this->headers = headers;
	this->headers_len = headers_len;
	return CheckMatch(connRules.checkHeaders(headers, headers_len));
}

const fkSentence* fkRequestExaminator::CheckBodyFragment(const char *body, PRUint32 body_len, 
							 PRUint32 body_offset) {
	this->body = body;
	this->body_len = body_len;
	this->body_offset = body_offset;
	
	return CheckMatch(connRules.checkBody(body, body_len));
}

