<?php
/* XUL File Manager - A XUL-based file management system for your web site
/* FILEMANAGER  --  A FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
*  Author: Duong Thanh An - technical@anisolution.com (core)
*  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
*	
*  Copyright (C) 2004 Anisolution.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Anisolution.com
*  http://www.anisolution.com
*  HCMC Vietnam
*  info@anisolution.com
*/
/*		
	 Copyright notice:
	 XUL File Manager is freeware with open source code. 
	 As long as you keep the copyright message, you can 
	 play with the code for your own purposes but you can
	 not distribute the altered version. You can not sell 
	 XUL File Manager or use it for commercial purposes.
	 Please contact us for commercial uses.

	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
*/
	function util_request($var, $defaultVar="")
	{
		return isset($_REQUEST[$var])?$_REQUEST[$var]:$defaultVar;
	}

	function unicodeXmlEncode($str)
	{
		$str = htmlspecialchars($str);
		return $str;
	}
	
	function getOrignialRealPathImpl($name, $prefix = true) {
		global $ROOT_PATH;
		
		$path = util_request($name, "");
		//$path = str_replace("/","\\", $path);
		
		if ($prefix) $path = $ROOT_PATH. $path;
		
		return $path;
	}
	
	function unMapPath($path) {
		global $ROOT_PATH;
		
		$path = substr($path, strlen($ROOT_PATH));
		//$path = str_replace("\\","/", $path);
		
		return $path;
	}
	
	function getOrignialRealPath1($prefix = true) {
		global $P_PATH1;
	
		return getOrignialRealPathImpl($P_PATH1,$prefix);		
	}
	
	function getOrignialRealPath2($prefix = true) {
		global $P_PATH2;		
		return getOrignialRealPathImpl($P_PATH2,$prefix);		
	}
	
	function getOrignialRealPath($prefix = true) {
		global $P_PATH;	
		return getOrignialRealPathImpl($P_PATH,$prefix);		
	}

	function getRequestPath() {
		global $P_PATH, $ROOT_PATH ;
		
		$path = trim(util_request($P_PATH, ""));
		return $ROOT_PATH . $path;
	}

	function dirsize($dir) 
	{
		$dh = opendir($dir);
		$size = 0;
		while (($file = readdir($dh)) !== false)
			if ($file != "." and $file != "..") {
				$path = $dir.DIRECTORY_SEPARATOR.$file;
				if (is_dir($path))
					$size += dirsize($path);
				elseif (is_file($path))
					$size += filesize($path);
			}
			closedir($dh);
			return $size;
	}
	  
	function getfiletype($file) 
	{
		$file=strtolower($file);
		$dotpos = strrpos($file, ".");
		if ($dotpos < 1) {
			$ft[0]="UnK";
			$ft[1]="application/octet-stream";
			return $ft;
		}
		else {
			$filetype = substr($file,$dotpos+1);
		}
		if ($filetype=="html") {
			$ft[0]="HTML";
			$ft[1]="";
			return $ft;
		}
		elseif ($filetype=="htm") {
			$ft[0]="HTML";
			$ft[1]="";
			return $ft;
		}
		elseif ($filetype=="jpg") {
			$ft[0]="JPG";
			$ft[1]="";
			return $ft;
		}
		elseif ($filetype=="bak") {
			$ft[0]="BAK";
			$ft[1]="application/octet-stream";
			return $ft;
		}
		elseif ($filetype=="db") {
			$ft[0]="DB";
			$ft[1]="application/octet-stream";
			return $ft;
		}
		elseif ($filetype=="bmp") {
			$ft[0]="BMP";
			$ft[1]="";
			return $ft;
		}
		elseif ($filetype=="txt") {
			$ft[0]="TXT";
			$ft[1]="text/plain";
			return $ft;
		}
		elseif ($filetype=="log") {
			$ft[0]="LOG";
			$ft[1]="text/plain";
			return $ft;
		}
		elseif ($filetype=="pdf") {
			$ft[0]="PDF";
			$ft[1]="application/pdf";
			return $ft;
		}
		elseif ($filetype=="rtf") {
			$ft[0]="RTF";
			$ft[1]="application/rtf";
			return $ft;
		}
		elseif ($filetype=="css") {
			$ft[0]="CSS";
			$ft[1]="text/css";
			return $ft;
		}
		elseif ($filetype=="doc") {
			$ft[0]="DOC";
			$ft[1]="application/msword";
			return $ft;
		}
		elseif ($filetype=="gif") {
			$ft[0]="GIF";
			$ft[1]="";
			return $ft;
		}
		elseif ($filetype=="png") {
			$ft[0]="PNG";
			$ft[1]="";
			return $ft;
		}
		elseif ($filetype=="zip") {
			$ft[0]="ZIP";
			$ft[1]="application/zip";
			return $ft;
		}
		elseif ($filetype=="php") {
			$ft[0]="PHP";
			$ft[1]="application/octet-stream";
			return $ft;
		}
		elseif ($filetype=="off") {
			$ft[0]="OFF";
			$ft[1]="application/octet-stream";
			return $ft;
		}
		else {
			$ft[0]="FILE";
			$ft[1]="application/octet-stream";
			return $ft;
		}
	}
	
	function perms($dec)
	{
		$perms=base_convert($dec, 10, 8);
		$perms1=substr($perms,0,1);
		if ($perms1=="1")
		{
			$permis=substr($perms,3);
		}
		else
		{
			$permis=substr($perms,2);
		}
		return ($permis);
	}
	
	function getSuccessMessage($successXML)
	{
		$str=  '<response status="OK">'.$successXML.'</response>';
		return $str;		
	}
	
	function getErrorMessage($errorCode, $errorDescription)
	{
		$str=  '<response status="FAILED">
				 <errorCode>'.$errorCode.'</errorCode>
				 <errorDescription>'.unicodeXmlEncode($errorDescription).'</errorDescription>
				</response>';
		return $str;		
	}
	
	function writeErrorMessage($errorCode, $errorDescription)
	{
		echo getErrorMessage($errorCode, $errorDescription);		
	}
	
	function deleteFolder($folder) 
	{
		if ($handle = opendir($folder)) 
		{
			while ($file = readdir($handle)) 
			{
				if ($file != "." && $file != "..") 
				{
				  if (is_dir($folder .DIRECTORY_SEPARATOR. $file)) // folder
					deleteFolder($folder .DIRECTORY_SEPARATOR. $file);
				  else if (file_exists($folder .DIRECTORY_SEPARATOR. $file)) 
				  {
					  chmod($folder ."/". $file,0777);
					  unlink($folder ."/". $file); // remove a file
				  } 
				}
			}
		}
		
		closedir($handle);
	
		// delete original dir this assumes its empty, should be empty
		// the above code takes care of this
		if (file_exists($folder)) 
		{
		  	chmod($folder,0777);
		  	rmdir($folder); //remove this directory
		}	
	}	
	
	function getCopyNText($name, $i) {
		if ($i == 0) {
			return $name;
		} 
		else if ($i == 1) {
			return "Copy of " .$name;
		}	
		else {
			return "Copy of (" .$i. ") " .$name;
		}		
	}
	
	function copyFolder($src, $dest, $newname) 
	{
		if(! is_dir($src)) {
			$name = basename($src);
			copy($src,$dest.DIRECTORY_SEPARATOR.$name); 
		}	
		else {
			$name = ($newname=="")?basename($src):$newname;
			$dir = $dest.DIRECTORY_SEPARATOR.$name;
			mkdir($dir,0777);
			
			$handle=opendir($src);
			while ($file = readdir($handle)) 
				if ($file != "." && $file != "..") {
					copyFolder($src.DIRECTORY_SEPARATOR.$file, $dir,"");
				}	

			closedir($handle);
		}	
		
		return true;
	}	
?>