/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.io.InputStream;
import java.util.Properties;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.util.ParameterCheck;
import org.mozilla.util.RangeException;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.Navigation;
import org.mozilla.webclient.Navigation2;
import org.mozilla.webclient.Prompt;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_native.ImplObjectNative;

public class NavigationImpl
extends ImplObjectNative
implements Navigation2 {
    public NavigationImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl);
    }

    public void loadURL(String string) {
        ParameterCheck.nonNull(string);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeLoadURL(this.nativeWebShell, string);
        }
    }

    public void loadFromStream(InputStream inputStream, String string, String string2, int n, Properties properties) {
        ParameterCheck.nonNull(inputStream);
        ParameterCheck.nonNull(string);
        ParameterCheck.nonNull(string2);
        if (n < -1 || n == 0) {
            throw new RangeException("contentLength value " + n + " is out of range.  It is should be either -1 or greater than 0.");
        }
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeLoadFromStream(this.nativeWebShell, inputStream, string, string2, n, properties);
        }
    }

    public void refresh(long l) {
        ParameterCheck.noLessThan(l, 0.0);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeRefresh(this.nativeWebShell, l);
        }
    }

    public void stop() {
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeStop(this.nativeWebShell);
        }
    }

    public void setPrompt(Prompt prompt) {
        ParameterCheck.nonNull(prompt);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativeSetPrompt(this.nativeWebShell, prompt);
        }
    }

    public void post(String string, String string2, String string3, String string4) {
        ParameterCheck.nonNull(string);
        this.myFactory.throwExceptionIfNotInitialized();
        Assert.assert_it(-1 != this.nativeWebShell);
        int n = 0;
        int n2 = 0;
        if (string3 != null) {
            n = string3.length();
        }
        if (string4 != null) {
            n2 = string4.length();
        }
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.nativePost(this.nativeWebShell, string, string2, n, string3, n2, string4);
        }
    }

    public native void nativeLoadURL(int var1, String var2);

    public native void nativeLoadFromStream(int var1, InputStream var2, String var3, String var4, int var5, Properties var6);

    public native void nativePost(int var1, String var2, String var3, int var4, String var5, int var6, String var7);

    public native void nativeRefresh(int var1, long var2);

    public native void nativeStop(int var1);

    public native void nativeSetPrompt(int var1, Prompt var2);

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("NavigationImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: NavigationImpl.java,v 1.6 2001/07/12 23:18:50 edburns%acm.org Exp $");
        try {
            BrowserControlFactory.setAppData(stringArray[0]);
            BrowserControl browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            Navigation navigation = (Navigation)browserControl.queryInterface("webclient.WindowControl");
            Assert.assert_it(navigation != null);
        }
        catch (Exception exception) {
            System.out.println("got exception: " + exception.getMessage());
        }
    }
}

