/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

namespace Hultmann.Zip
{

internal sealed class MyCrc
{

private readonly uint[] m_table;
private const    long   Mask32 = 0xffffffff;
private          long   m_crc = Mask32;


public MyCrc()
{
    m_table = InitTable();
}


public void Update(byte[] bin, int count)
{
    const long Mask8 = 0xff;
    for (int idxBin = 0; idxBin < count; idxBin++) {
        int idxTable = (int) (bin[idxBin] ^ (m_crc & Mask8));
        m_crc = m_table[idxTable] ^ (m_crc >> 8);
    }
}


public long Value
{
    get {
        return m_crc ^ Mask32;
    }
}


private static uint[] InitTable()
{
    unchecked {
        const int LenTable = 256;
        uint[] table = new uint[LenTable];
        for(int idx = 0; idx < LenTable; idx++) {
            table[idx] = (uint) InitTableRow(idx);
        }

        return table;
    }
}


private static long InitTableRow(int idxRow)
{
    const long PKZipPolynomial = 0xedb88320;
    long row = idxRow;

    for (int idx = 0; idx < 8; idx++) {
        if ((row & 1) == 1) {
            row = (row >> 1) ^ PKZipPolynomial;
        } else {
            row >>= 1;
        }
    }

    return row;
}


// ==================================================================================================================================
}//class
}//ns
