//
// C++ Implementation: outputgenerator
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "outputgenerator.h"

#include "outputbuffer.h"

using namespace std;

OutputGenerator::OutputGenerator(OutputBuffer &buff, ostream &os) :
  outputbuffer(buff), output(os)
{
}


OutputGenerator::~OutputGenerator()
{
}

void
OutputGenerator::output_string(const string &s)
{
    output << s;
}

void
OutputGenerator::generate_line(const string &s)
{
  output_string(s);
}

void
OutputGenerator::generate()
{
  reset();
  outputbuffer.flush();
  for (OutputBuffer::const_iterator it = outputbuffer.begin();
       it != outputbuffer.end(); ++it)
    generate_line(*it);
}
