/* 
   This file is public domain.

   The data is a matter of public record, and comes from
   http://www.fdb.cz/   
 */


SET search_path TO sqltutor;

DROP TABLE filmy    CASCADE;
DROP TABLE umelci   CASCADE;
DROP TABLE obsazeni CASCADE;
DROP TABLE rezie    CASCADE;

CREATE TABLE filmy   (id INT PRIMARY KEY, rok INT, titul VARCHAR(50));
CREATE TABLE umelci  (id INT PRIMARY KEY, jmeno VARCHAR(30));
CREATE TABLE obsazeni(film_id   INT REFERENCES filmy (id),
                      umelec_id INT REFERENCES umelci(id),
                      poradi    INT);
CREATE TABLE rezie   (film_id   INT REFERENCES filmy (id),
                      umelec_id INT REFERENCES umelci(id));

BEGIN;

INSERT INTO umelci (id, jmeno) VALUES ( 1, 'Robert Zemeckis' );
INSERT INTO umelci (id, jmeno) VALUES ( 2, 'Tom Hanks' );
INSERT INTO umelci (id, jmeno) VALUES ( 3, 'Robin Wright Penn' );
INSERT INTO umelci (id, jmeno) VALUES ( 4, 'Gary Sinise' );
INSERT INTO umelci (id, jmeno) VALUES ( 5, 'Mykelti Williamson' );
INSERT INTO umelci (id, jmeno) VALUES ( 6, 'Sally Field' );
INSERT INTO umelci (id, jmeno) VALUES ( 7, 'Michael Connor Humphreys' );
INSERT INTO umelci (id, jmeno) VALUES ( 8, 'Hanna Hall' );
INSERT INTO umelci (id, jmeno) VALUES ( 9, 'Haley Joel Osment' );
INSERT INTO filmy (id, rok, titul) VALUES ( 1, 1994, 'Forrest Gump' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 1, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 2, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 3, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 4, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 5, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 6, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 7, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 8, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 1, 9, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 10, 'Frank Darabont' );
INSERT INTO umelci (id, jmeno) VALUES ( 11, 'Tim Robbins' );
INSERT INTO umelci (id, jmeno) VALUES ( 12, 'Morgan Freeman' );
INSERT INTO umelci (id, jmeno) VALUES ( 13, 'William Sadler' );
INSERT INTO umelci (id, jmeno) VALUES ( 14, 'Clancy Brown' );
INSERT INTO umelci (id, jmeno) VALUES ( 15, 'Gil Bellows' );
INSERT INTO filmy (id, rok, titul) VALUES ( 2, 1994, 'Vykoupení z věznice Shawshank' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 2, 10 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 2, 11, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 2, 12, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 2, 13, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 2, 14, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 2, 15, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 16, 'Andy Wachowski' );
INSERT INTO umelci (id, jmeno) VALUES ( 17, 'Larry Wachowski' );
INSERT INTO umelci (id, jmeno) VALUES ( 18, 'Keanu Reeves' );
INSERT INTO umelci (id, jmeno) VALUES ( 19, 'Carrie-Anne Moss' );
INSERT INTO umelci (id, jmeno) VALUES ( 20, 'Hugo Weaving' );
INSERT INTO umelci (id, jmeno) VALUES ( 21, 'Gloria Foster' );
INSERT INTO umelci (id, jmeno) VALUES ( 22, 'Joe Pantoliano' );
INSERT INTO filmy (id, rok, titul) VALUES ( 3, 1999, 'Matrix' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 3, 16 );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 3, 17 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 3, 18, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 3, 19, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 3, 20, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 3, 21, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 3, 22, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 23, 'Quentin Tarantino' );
INSERT INTO umelci (id, jmeno) VALUES ( 24, 'John Travolta' );
INSERT INTO umelci (id, jmeno) VALUES ( 25, 'Samuel L. Jackson' );
INSERT INTO umelci (id, jmeno) VALUES ( 26, 'Uma Thurman' );
INSERT INTO umelci (id, jmeno) VALUES ( 27, 'Harvey Keitel' );
INSERT INTO umelci (id, jmeno) VALUES ( 28, 'Tim Roth' );
INSERT INTO filmy (id, rok, titul) VALUES ( 4, 1993, 'Pulp Fiction - Historky z podsvětí' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 4, 23 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 4, 24, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 4, 25, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 4, 26, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 4, 27, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 4, 28, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 29, 'Steven Spielberg' );
INSERT INTO umelci (id, jmeno) VALUES ( 30, 'Tom Sizemore' );
INSERT INTO umelci (id, jmeno) VALUES ( 31, 'Edward Burns' );
INSERT INTO umelci (id, jmeno) VALUES ( 32, 'Barry Pepper' );
INSERT INTO umelci (id, jmeno) VALUES ( 33, 'Adam Goldberg' );
INSERT INTO filmy (id, rok, titul) VALUES ( 5, 1998, 'Zachraňte vojína Ryana' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 5, 29 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 5, 2, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 5, 30, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 5, 31, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 5, 32, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 5, 33, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 34, 'Peter Jackson' );
INSERT INTO umelci (id, jmeno) VALUES ( 35, 'Elijah Wood' );
INSERT INTO umelci (id, jmeno) VALUES ( 36, 'Viggo Mortensen' );
INSERT INTO umelci (id, jmeno) VALUES ( 37, 'Ian McKellen' );
INSERT INTO umelci (id, jmeno) VALUES ( 38, 'Sean Astin' );
INSERT INTO umelci (id, jmeno) VALUES ( 39, 'Orlando Bloom' );
INSERT INTO filmy (id, rok, titul) VALUES ( 6, 2003, 'Pán prstenů: Návrat krále' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 6, 34 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 6, 35, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 6, 36, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 6, 37, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 6, 38, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 6, 39, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 40, 'Liam Neeson' );
INSERT INTO umelci (id, jmeno) VALUES ( 41, 'Ben Kingsley' );
INSERT INTO umelci (id, jmeno) VALUES ( 42, 'Ralph Fiennes' );
INSERT INTO umelci (id, jmeno) VALUES ( 43, 'Caroline Godall' );
INSERT INTO umelci (id, jmeno) VALUES ( 44, 'Jonathan Sagalle' );
INSERT INTO filmy (id, rok, titul) VALUES ( 7, 1993, 'Schindlerův seznam' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 7, 29 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 7, 40, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 7, 41, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 7, 42, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 7, 43, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 7, 44, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 45, 'Liv Tyler' );
INSERT INTO filmy (id, rok, titul) VALUES ( 8, 2000, 'Pán prstenů: Společenstvo prstenu' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 8, 34 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 8, 35, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 8, 37, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 8, 36, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 8, 38, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 8, 45, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 46, 'Francis Ford Coppola' );
INSERT INTO umelci (id, jmeno) VALUES ( 47, 'Marlon Brando' );
INSERT INTO umelci (id, jmeno) VALUES ( 48, 'Al Pacino' );
INSERT INTO umelci (id, jmeno) VALUES ( 49, 'James Caan' );
INSERT INTO umelci (id, jmeno) VALUES ( 50, 'Richard Castellano' );
INSERT INTO umelci (id, jmeno) VALUES ( 51, 'Robert Duvall' );
INSERT INTO filmy (id, rok, titul) VALUES ( 9, 1972, 'Kmotr' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 9, 46 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 9, 47, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 9, 48, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 9, 49, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 9, 50, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 9, 51, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 52, 'Sergio Leone' );
INSERT INTO umelci (id, jmeno) VALUES ( 53, 'Claudia Cardinale' );
INSERT INTO umelci (id, jmeno) VALUES ( 54, 'Henry Fonda' );
INSERT INTO umelci (id, jmeno) VALUES ( 55, 'Jason Robards' );
INSERT INTO umelci (id, jmeno) VALUES ( 56, 'Charles Bronson' );
INSERT INTO umelci (id, jmeno) VALUES ( 57, 'Gabriele Ferzetti' );
INSERT INTO filmy (id, rok, titul) VALUES ( 10, 1968, 'Tenkrát na Západě' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 10, 52 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 10, 53, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 10, 54, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 10, 55, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 10, 56, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 10, 57, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 58, 'Michael Polish' );
INSERT INTO umelci (id, jmeno) VALUES ( 59, 'Bruce Willis' );
INSERT INTO umelci (id, jmeno) VALUES ( 60, 'Billy Bob Thornton' );
INSERT INTO umelci (id, jmeno) VALUES ( 61, 'Virginia Madsen' );
INSERT INTO umelci (id, jmeno) VALUES ( 62, 'Max Thieriot' );
INSERT INTO umelci (id, jmeno) VALUES ( 63, 'Jasper Polish' );
INSERT INTO umelci (id, jmeno) VALUES ( 64, 'Logan Polish' );
INSERT INTO filmy (id, rok, titul) VALUES ( 11, 2007, 'Astronaut' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 11, 58 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 11, 59, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 11, 60, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 11, 61, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 11, 62, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 11, 63, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 11, 64, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 65, 'Tony Kaye' );
INSERT INTO filmy (id, rok, titul) VALUES ( 12, 2007, 'Black Water Transit' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 12, 65 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 12, 59, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 12, 25, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 66, 'Tom Schulman' );
INSERT INTO umelci (id, jmeno) VALUES ( 67, 'Julianne Moore' );
INSERT INTO filmy (id, rok, titul) VALUES ( 13, 2007, 'Morgan''s Summit' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 13, 66 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 13, 59, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 13, 67, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 68, 'James Foley' );
INSERT INTO umelci (id, jmeno) VALUES ( 69, 'Halle Berry' );
INSERT INTO umelci (id, jmeno) VALUES ( 70, 'Giovanni Ribisi' );
INSERT INTO umelci (id, jmeno) VALUES ( 71, 'Richard Portnow' );
INSERT INTO umelci (id, jmeno) VALUES ( 72, 'Gary Dourdan' );
INSERT INTO filmy (id, rok, titul) VALUES ( 14, 2007, 'Neznámý svůdce' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 14, 68 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 14, 59, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 14, 69, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 14, 70, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 14, 71, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 14, 72, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 73, 'Len Wiseman' );
INSERT INTO umelci (id, jmeno) VALUES ( 74, 'Timothy Olyphant' );
INSERT INTO umelci (id, jmeno) VALUES ( 75, 'Maggie Quigley' );
INSERT INTO umelci (id, jmeno) VALUES ( 76, 'Justin Long' );
INSERT INTO umelci (id, jmeno) VALUES ( 77, 'Jeffrey Wright' );
INSERT INTO filmy (id, rok, titul) VALUES ( 15, 2007, 'Smrtonosná past 4.0' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 15, 73 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 15, 59, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 15, 74, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 15, 75, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 15, 76, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 15, 77, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 78, 'Jonathan Lynn' );
INSERT INTO umelci (id, jmeno) VALUES ( 79, 'Matthew Perry' );
INSERT INTO umelci (id, jmeno) VALUES ( 80, 'Rosanna Arquette' );
INSERT INTO umelci (id, jmeno) VALUES ( 81, 'Michael Clarke Duncan' );
INSERT INTO umelci (id, jmeno) VALUES ( 82, 'Natasha Henstridge' );
INSERT INTO filmy (id, rok, titul) VALUES ( 16, 2000, 'Můj soused zabiják' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 16, 78 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 16, 59, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 16, 79, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 16, 80, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 16, 81, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 16, 82, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 83, 'Gore Verbinski' );
INSERT INTO umelci (id, jmeno) VALUES ( 84, 'Johnny Depp' );
INSERT INTO umelci (id, jmeno) VALUES ( 85, 'Keira Knightley' );
INSERT INTO umelci (id, jmeno) VALUES ( 86, 'Geoffrey Rush' );
INSERT INTO umelci (id, jmeno) VALUES ( 87, 'Jonathan Pryce' );
INSERT INTO filmy (id, rok, titul) VALUES ( 17, 2007, 'Piráti z Karibiku: Na konci světa' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 17, 83 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 17, 84, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 17, 39, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 17, 85, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 17, 86, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 17, 87, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 88, 'Jack Davenport' );
INSERT INTO umelci (id, jmeno) VALUES ( 89, 'Bill Nighy' );
INSERT INTO filmy (id, rok, titul) VALUES ( 18, 2006, 'Piráti z Karibiku - Truhla mrtvého muže' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 18, 83 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 18, 84, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 18, 39, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 18, 85, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 18, 88, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 18, 89, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 90, 'Tim Burton' );
INSERT INTO umelci (id, jmeno) VALUES ( 91, 'Freddie Highmore' );
INSERT INTO umelci (id, jmeno) VALUES ( 92, 'Helen Bonham Carter' );
INSERT INTO umelci (id, jmeno) VALUES ( 93, 'Christopher Lee' );
INSERT INTO umelci (id, jmeno) VALUES ( 94, 'David Kelly' );
INSERT INTO filmy (id, rok, titul) VALUES ( 19, 2005, 'Karlík a továrna na čokoládu' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 19, 90 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 19, 84, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 19, 91, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 19, 92, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 19, 93, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 19, 94, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 95, 'Laurence Dunmore' );
INSERT INTO umelci (id, jmeno) VALUES ( 96, 'Samantha Morton' );
INSERT INTO umelci (id, jmeno) VALUES ( 97, 'John Malkovich' );
INSERT INTO umelci (id, jmeno) VALUES ( 98, 'Paul Ritter' );
INSERT INTO umelci (id, jmeno) VALUES ( 99, 'Stanley Townsend' );
INSERT INTO filmy (id, rok, titul) VALUES ( 20, 2005, 'Libertin' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 20, 95 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 20, 84, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 20, 96, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 20, 97, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 20, 98, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 20, 99, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 100, 'Marshall Bell' );
INSERT INTO umelci (id, jmeno) VALUES ( 101, 'Elpidia Carrillo' );
INSERT INTO umelci (id, jmeno) VALUES ( 102, 'Frederic Forrest' );
INSERT INTO filmy (id, rok, titul) VALUES ( 21, 1997, 'Bojovník' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 21, 84 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 21, 84, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 21, 47, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 21, 100, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 21, 101, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 21, 102, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 103, 'Tom Everett Scott' );
INSERT INTO umelci (id, jmeno) VALUES ( 104, 'Johnathon Schaech' );
INSERT INTO umelci (id, jmeno) VALUES ( 105, 'Steve Zahn' );
INSERT INTO umelci (id, jmeno) VALUES ( 106, 'Ethan Embry' );
INSERT INTO filmy (id, rok, titul) VALUES ( 22, 1996, 'To je náš hit!' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 22, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 22, 103, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 22, 45, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 22, 104, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 22, 105, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 22, 106, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 107, 'Ron Howard' );
INSERT INTO umelci (id, jmeno) VALUES ( 108, 'Audrey Tautou' );
INSERT INTO umelci (id, jmeno) VALUES ( 109, 'Jean Reno' );
INSERT INTO umelci (id, jmeno) VALUES ( 110, 'Alfred Molina' );
INSERT INTO filmy (id, rok, titul) VALUES ( 23, 2006, 'Šifra mistra Leonarda' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 23, 107 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 23, 2, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 23, 108, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 23, 109, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 23, 37, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 23, 110, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 111, 'Joel Coen' );
INSERT INTO umelci (id, jmeno) VALUES ( 112, 'Ethan Coen' );
INSERT INTO umelci (id, jmeno) VALUES ( 113, 'Irma P. Hall' );
INSERT INTO umelci (id, jmeno) VALUES ( 114, 'Marlon Wayans' );
INSERT INTO umelci (id, jmeno) VALUES ( 115, 'J.K. Simmons' );
INSERT INTO umelci (id, jmeno) VALUES ( 116, 'Tzi Ma' );
INSERT INTO filmy (id, rok, titul) VALUES ( 24, 2004, 'Lupiči paní domácí' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 24, 111 );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 24, 112 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 24, 2, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 24, 113, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 24, 114, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 24, 115, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 24, 116, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 117, 'Michael Jeter' );
INSERT INTO umelci (id, jmeno) VALUES ( 118, 'Peter Scolari' );
INSERT INTO umelci (id, jmeno) VALUES ( 119, 'Nona Gaye' );
INSERT INTO umelci (id, jmeno) VALUES ( 120, 'Eddie Deezen' );
INSERT INTO filmy (id, rok, titul) VALUES ( 25, 2004, 'Polární expres' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 25, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 25, 2, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 25, 117, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 25, 118, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 25, 119, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 25, 120, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 121, 'Catherine Zeta-Jones' );
INSERT INTO umelci (id, jmeno) VALUES ( 122, 'Stanley Tucci' );
INSERT INTO umelci (id, jmeno) VALUES ( 123, 'Chi McBride' );
INSERT INTO umelci (id, jmeno) VALUES ( 124, 'Diego Luna' );
INSERT INTO filmy (id, rok, titul) VALUES ( 26, 2004, 'Terminál' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 26, 29 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 26, 2, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 26, 121, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 26, 122, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 26, 123, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 26, 124, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 125, 'Leonardo DiCaprio' );
INSERT INTO umelci (id, jmeno) VALUES ( 126, 'Christopher Walken' );
INSERT INTO umelci (id, jmeno) VALUES ( 127, 'Martin Sheen' );
INSERT INTO umelci (id, jmeno) VALUES ( 128, 'Nathalie Baye' );
INSERT INTO filmy (id, rok, titul) VALUES ( 27, 2002, 'Chyť mě, když to dokážeš' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 27, 29 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 27, 125, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 27, 2, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 27, 126, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 27, 127, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 27, 128, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 129, 'Shawn Levy' );
INSERT INTO umelci (id, jmeno) VALUES ( 130, 'Steve Martin' );
INSERT INTO umelci (id, jmeno) VALUES ( 131, 'Kevin Kline' );
INSERT INTO umelci (id, jmeno) VALUES ( 132, 'Beyoncé Knowles' );
INSERT INTO umelci (id, jmeno) VALUES ( 133, 'Emily Mortimer' );
INSERT INTO filmy (id, rok, titul) VALUES ( 28, 2006, 'Růžový panter' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 28, 129 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 28, 130, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 28, 131, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 28, 132, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 28, 109, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 28, 133, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 134, 'Tony Bill' );
INSERT INTO umelci (id, jmeno) VALUES ( 135, 'James Franco' );
INSERT INTO umelci (id, jmeno) VALUES ( 136, 'Martin Henderson' );
INSERT INTO umelci (id, jmeno) VALUES ( 137, 'Jennifer Decker' );
INSERT INTO umelci (id, jmeno) VALUES ( 138, 'Tyler Labine' );
INSERT INTO filmy (id, rok, titul) VALUES ( 29, 2006, 'Rytíři nebes' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 29, 134 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 29, 135, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 29, 109, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 29, 136, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 29, 137, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 29, 138, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 139, 'Chris Nahon' );
INSERT INTO umelci (id, jmeno) VALUES ( 140, 'Jocelyn Quivrin' );
INSERT INTO umelci (id, jmeno) VALUES ( 141, 'Arly Jover' );
INSERT INTO umelci (id, jmeno) VALUES ( 142, 'Laura Morante' );
INSERT INTO umelci (id, jmeno) VALUES ( 143, 'Philippe Bas' );
INSERT INTO filmy (id, rok, titul) VALUES ( 30, 2005, 'Říše vlků' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 30, 139 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 30, 109, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 30, 140, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 30, 141, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 30, 142, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 30, 143, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 144, 'Roberto Benigni' );
INSERT INTO umelci (id, jmeno) VALUES ( 145, 'Nicoletta Braschi' );
INSERT INTO umelci (id, jmeno) VALUES ( 146, 'Steven Beckingham' );
INSERT INTO umelci (id, jmeno) VALUES ( 147, 'Emilia Fox' );
INSERT INTO filmy (id, rok, titul) VALUES ( 31, 2005, 'Tygr a sníh' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 31, 144 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 31, 144, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 31, 109, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 31, 145, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 31, 146, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 31, 147, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 148, 'Jean-Marie Poiré' );
INSERT INTO umelci (id, jmeno) VALUES ( 149, 'Christian Clavier' );
INSERT INTO umelci (id, jmeno) VALUES ( 150, 'Valérie Lemercier' );
INSERT INTO umelci (id, jmeno) VALUES ( 151, 'Marie-Anne Chazal' );
INSERT INTO umelci (id, jmeno) VALUES ( 152, 'Christian Bujeau' );
INSERT INTO filmy (id, rok, titul) VALUES ( 32, 1992, 'Návštěvníci' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 32, 148 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 32, 149, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 32, 109, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 32, 150, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 32, 151, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 32, 152, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 153, 'Muriel Robin' );
INSERT INTO filmy (id, rok, titul) VALUES ( 33, 1998, 'Návštěvníci 2' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 33, 148 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 33, 109, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 33, 149, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 33, 153, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 154, 'Tom Shadyac' );
INSERT INTO umelci (id, jmeno) VALUES ( 155, 'Steve Carell' );
INSERT INTO umelci (id, jmeno) VALUES ( 156, 'Lauren Graham' );
INSERT INTO umelci (id, jmeno) VALUES ( 157, 'Jimmy Bennett' );
INSERT INTO umelci (id, jmeno) VALUES ( 158, 'Johnny Simmons' );
INSERT INTO filmy (id, rok, titul) VALUES ( 34, 2007, 'Božský Evan' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 34, 154 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 34, 155, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 34, 156, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 34, 157, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 34, 158, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 34, 12, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 159, 'Timur Bekmambetov' );
INSERT INTO umelci (id, jmeno) VALUES ( 160, 'James McAvoy' );
INSERT INTO umelci (id, jmeno) VALUES ( 161, 'Angelina Jolie' );
INSERT INTO filmy (id, rok, titul) VALUES ( 35, 2007, 'Wanted' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 35, 159 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 35, 160, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 35, 12, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 35, 161, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 162, 'Bruce Beresford' );
INSERT INTO umelci (id, jmeno) VALUES ( 163, 'Jamie Anderson' );
INSERT INTO umelci (id, jmeno) VALUES ( 164, 'Ned Bellamy' );
INSERT INTO umelci (id, jmeno) VALUES ( 165, 'Margarita Blush' );
INSERT INTO umelci (id, jmeno) VALUES ( 166, 'John Cusack' );
INSERT INTO umelci (id, jmeno) VALUES ( 167, 'Doug Dearth' );
INSERT INTO filmy (id, rok, titul) VALUES ( 36, 2006, 'Kontrakt' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 36, 162 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 36, 163, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 36, 164, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 36, 165, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 36, 166, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 36, 167, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 36, 12, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 168, 'David J. Burke' );
INSERT INTO umelci (id, jmeno) VALUES ( 169, 'Kevin Spacey' );
INSERT INTO umelci (id, jmeno) VALUES ( 170, 'Justin Timberlake' );
INSERT INTO umelci (id, jmeno) VALUES ( 171, 'J LL Cool' );
INSERT INTO umelci (id, jmeno) VALUES ( 172, 'Dylan McDermott' );
INSERT INTO filmy (id, rok, titul) VALUES ( 37, 2005, 'Mimo zákon' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 37, 168 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 37, 12, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 37, 169, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 37, 170, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 37, 171, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 37, 172, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 173, 'Matthew Vaughn' );
INSERT INTO umelci (id, jmeno) VALUES ( 174, 'Charlie Cox' );
INSERT INTO umelci (id, jmeno) VALUES ( 175, 'Michelle Pfeiffer' );
INSERT INTO umelci (id, jmeno) VALUES ( 176, 'Claire Danes' );
INSERT INTO umelci (id, jmeno) VALUES ( 177, 'Robert De Niro' );
INSERT INTO filmy (id, rok, titul) VALUES ( 38, 2007, 'Hvězdný prach' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 38, 173 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 38, 174, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 38, 175, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 38, 176, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 38, 177, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 178, 'Matt Damon' );
INSERT INTO umelci (id, jmeno) VALUES ( 179, 'Joe Pesci' );
INSERT INTO umelci (id, jmeno) VALUES ( 180, 'Alec Baldwin' );
INSERT INTO filmy (id, rok, titul) VALUES ( 39, 2006, 'Good Shepherd' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 39, 177 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 39, 178, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 39, 177, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 39, 161, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 39, 179, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 39, 180, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 181, 'John Polson' );
INSERT INTO umelci (id, jmeno) VALUES ( 182, 'Dakota Fanning' );
INSERT INTO umelci (id, jmeno) VALUES ( 183, 'Famke Janssen' );
INSERT INTO umelci (id, jmeno) VALUES ( 184, 'Elisabeth Shue' );
INSERT INTO filmy (id, rok, titul) VALUES ( 40, 2005, 'Hra na schovávanou' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 40, 181 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 40, 177, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 40, 182, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 40, 183, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 40, 184, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 185, 'Nick Hamm' );
INSERT INTO umelci (id, jmeno) VALUES ( 186, 'Rebecca Romijn-Stamos' );
INSERT INTO umelci (id, jmeno) VALUES ( 187, 'Greg Kinnear' );
INSERT INTO umelci (id, jmeno) VALUES ( 188, 'Cameron Bright' );
INSERT INTO umelci (id, jmeno) VALUES ( 189, 'Merwin Mondesir' );
INSERT INTO filmy (id, rok, titul) VALUES ( 41, 2004, 'Godsend' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 41, 185 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 41, 177, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 41, 186, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 41, 187, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 41, 188, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 41, 189, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 190, 'Jay Roach' );
INSERT INTO umelci (id, jmeno) VALUES ( 191, 'Ben Stiller' );
INSERT INTO umelci (id, jmeno) VALUES ( 192, 'Dustin Hoffman' );
INSERT INTO umelci (id, jmeno) VALUES ( 193, 'Barbra Streisand' );
INSERT INTO umelci (id, jmeno) VALUES ( 194, 'Blythe Danner' );
INSERT INTO filmy (id, rok, titul) VALUES ( 42, 2004, 'Jeho fotr, to je lotr!' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 42, 190 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 42, 191, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 42, 177, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 42, 192, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 42, 193, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 42, 194, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 195, 'Mark Steven Johnson' );
INSERT INTO umelci (id, jmeno) VALUES ( 196, 'Nicolas Cage' );
INSERT INTO umelci (id, jmeno) VALUES ( 197, 'Wes Bentley' );
INSERT INTO umelci (id, jmeno) VALUES ( 198, 'Peter Fonda' );
INSERT INTO umelci (id, jmeno) VALUES ( 199, 'Eva Mendes' );
INSERT INTO umelci (id, jmeno) VALUES ( 200, 'Donal Logue' );
INSERT INTO filmy (id, rok, titul) VALUES ( 43, 2007, 'Ghost Rider' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 43, 195 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 43, 196, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 43, 197, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 43, 198, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 43, 199, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 43, 200, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 201, 'Lee Tamahori' );
INSERT INTO umelci (id, jmeno) VALUES ( 202, 'Nicolas Pajon' );
INSERT INTO umelci (id, jmeno) VALUES ( 203, 'Paul Rae' );
INSERT INTO umelci (id, jmeno) VALUES ( 204, 'Alan Kemper Armani' );
INSERT INTO filmy (id, rok, titul) VALUES ( 44, 2007, 'Next' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 44, 201 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 44, 196, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 44, 67, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 44, 202, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 44, 203, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 44, 204, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 205, 'Neill LaBute' );
INSERT INTO umelci (id, jmeno) VALUES ( 206, 'Ellen Burstyn' );
INSERT INTO umelci (id, jmeno) VALUES ( 207, 'Kate Beahan' );
INSERT INTO umelci (id, jmeno) VALUES ( 208, 'Frances Conroy' );
INSERT INTO umelci (id, jmeno) VALUES ( 209, 'Molly Parker' );
INSERT INTO filmy (id, rok, titul) VALUES ( 45, 2006, 'Rituál' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 45, 205 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 45, 196, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 45, 206, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 45, 207, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 45, 208, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 45, 209, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 210, 'Oliver Stone' );
INSERT INTO umelci (id, jmeno) VALUES ( 211, 'Maria Bello' );
INSERT INTO umelci (id, jmeno) VALUES ( 212, 'Michael Peña' );
INSERT INTO umelci (id, jmeno) VALUES ( 213, 'Jay Hernandez' );
INSERT INTO umelci (id, jmeno) VALUES ( 214, 'Armando Riesco' );
INSERT INTO filmy (id, rok, titul) VALUES ( 46, 2006, 'World Trade Center' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 46, 210 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 46, 196, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 46, 211, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 46, 212, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 46, 213, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 46, 214, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 215, 'Jon Avnet' );
INSERT INTO umelci (id, jmeno) VALUES ( 216, 'Alicia Witt' );
INSERT INTO umelci (id, jmeno) VALUES ( 217, 'Amy Brenneman' );
INSERT INTO umelci (id, jmeno) VALUES ( 218, 'Leelee Sobieski' );
INSERT INTO umelci (id, jmeno) VALUES ( 219, 'Benjamin McKenzie' );
INSERT INTO filmy (id, rok, titul) VALUES ( 47, 2007, '88 minut' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 47, 215 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 47, 48, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 47, 216, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 47, 217, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 47, 218, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 47, 219, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 220, 'Steven Soderbergh' );
INSERT INTO umelci (id, jmeno) VALUES ( 221, 'George Clooney' );
INSERT INTO umelci (id, jmeno) VALUES ( 222, 'Brad Pitt' );
INSERT INTO umelci (id, jmeno) VALUES ( 223, 'Ellen Barkin' );
INSERT INTO filmy (id, rok, titul) VALUES ( 48, 2007, 'Dannyho parťáci 3' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 48, 220 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 48, 221, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 48, 222, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 48, 178, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 48, 223, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 48, 48, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 224, 'D.J. Caruso' );
INSERT INTO umelci (id, jmeno) VALUES ( 225, 'Matthew McConaughey' );
INSERT INTO umelci (id, jmeno) VALUES ( 226, 'René Russo' );
INSERT INTO umelci (id, jmeno) VALUES ( 227, 'Jeremy Piven' );
INSERT INTO umelci (id, jmeno) VALUES ( 228, 'Jaime King' );
INSERT INTO filmy (id, rok, titul) VALUES ( 49, 2005, 'Maximální limit' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 49, 224 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 49, 48, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 49, 225, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 49, 226, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 49, 227, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 49, 228, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 229, 'Michael Radford' );
INSERT INTO umelci (id, jmeno) VALUES ( 230, 'Jeremy Irons' );
INSERT INTO umelci (id, jmeno) VALUES ( 231, 'Joseph Fiennes' );
INSERT INTO umelci (id, jmeno) VALUES ( 232, 'Lynn Collins' );
INSERT INTO umelci (id, jmeno) VALUES ( 233, 'Zuleikha Robinson' );
INSERT INTO filmy (id, rok, titul) VALUES ( 50, 2004, 'Kupec benátský' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 50, 229 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 50, 48, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 50, 230, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 50, 231, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 50, 232, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 50, 233, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 234, 'Paul Abascal' );
INSERT INTO umelci (id, jmeno) VALUES ( 235, 'Cole Hauser' );
INSERT INTO umelci (id, jmeno) VALUES ( 236, 'Robin Tunney' );
INSERT INTO umelci (id, jmeno) VALUES ( 237, 'Dennis Farina' );
INSERT INTO umelci (id, jmeno) VALUES ( 238, 'Daniel Baldwin' );
INSERT INTO umelci (id, jmeno) VALUES ( 239, 'Mel Gibson' );
INSERT INTO filmy (id, rok, titul) VALUES ( 51, 2004, 'Paparazzi' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 51, 234 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 51, 235, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 51, 236, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 51, 237, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 51, 30, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 51, 238, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 51, 239, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 240, 'Randall Wallace' );
INSERT INTO umelci (id, jmeno) VALUES ( 241, 'Madeleine Stowe' );
INSERT INTO umelci (id, jmeno) VALUES ( 242, 'Sam Elliott' );
INSERT INTO umelci (id, jmeno) VALUES ( 243, 'Chris Klein' );
INSERT INTO filmy (id, rok, titul) VALUES ( 52, 2002, 'Údolí stínů' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 52, 240 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 52, 239, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 52, 241, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 52, 187, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 52, 242, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 52, 243, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 244, 'M. Night Shyamalan' );
INSERT INTO umelci (id, jmeno) VALUES ( 245, 'Joaquin Phoenix' );
INSERT INTO umelci (id, jmeno) VALUES ( 246, 'Rory Culkin' );
INSERT INTO umelci (id, jmeno) VALUES ( 247, 'Abigail Breslin' );
INSERT INTO umelci (id, jmeno) VALUES ( 248, 'Cherry Jones' );
INSERT INTO filmy (id, rok, titul) VALUES ( 53, 2002, 'Znamení' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 53, 244 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 53, 239, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 53, 245, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 53, 246, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 53, 247, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 53, 248, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 249, 'Keith Gordon' );
INSERT INTO umelci (id, jmeno) VALUES ( 250, 'Robert Downey' );
INSERT INTO umelci (id, jmeno) VALUES ( 251, 'Jeremy Northam' );
INSERT INTO umelci (id, jmeno) VALUES ( 252, 'Katie Holmes' );
INSERT INTO filmy (id, rok, titul) VALUES ( 54, 2002, 'Zpívající detektiv' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 54, 249 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 54, 239, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 54, 250, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 54, 3, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 54, 251, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 54, 252, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 253, 'Roland Emmerich' );
INSERT INTO umelci (id, jmeno) VALUES ( 254, 'Heath Ledger' );
INSERT INTO umelci (id, jmeno) VALUES ( 255, 'Joely Richardson' );
INSERT INTO umelci (id, jmeno) VALUES ( 256, 'Tchéky Karyo' );
INSERT INTO umelci (id, jmeno) VALUES ( 257, 'Tom Wilkinson' );
INSERT INTO filmy (id, rok, titul) VALUES ( 55, 2000, 'Patriot' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 55, 253 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 55, 239, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 55, 254, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 55, 255, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 55, 256, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 55, 257, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 258, 'Sophie Marceau' );
INSERT INTO umelci (id, jmeno) VALUES ( 259, 'Patrick McGoohan' );
INSERT INTO umelci (id, jmeno) VALUES ( 260, 'Catherine McCormack' );
INSERT INTO umelci (id, jmeno) VALUES ( 261, 'Brendan Gleeson' );
INSERT INTO filmy (id, rok, titul) VALUES ( 56, 1995, 'Statečné srdce' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 56, 239 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 56, 239, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 56, 258, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 56, 259, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 56, 260, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 56, 261, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 262, 'Sharisse Baker-Bernard' );
INSERT INTO umelci (id, jmeno) VALUES ( 263, 'Chris Coppola' );
INSERT INTO umelci (id, jmeno) VALUES ( 264, 'Crispin Glover' );
INSERT INTO umelci (id, jmeno) VALUES ( 265, 'Anthony Hopkins' );
INSERT INTO filmy (id, rok, titul) VALUES ( 57, 2007, 'Beowulf' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 57, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 57, 262, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 57, 263, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 57, 261, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 57, 264, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 57, 265, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 57, 161, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 266, 'Doug Liman' );
INSERT INTO umelci (id, jmeno) VALUES ( 267, 'Adam Brody' );
INSERT INTO umelci (id, jmeno) VALUES ( 268, 'William Fichtner' );
INSERT INTO umelci (id, jmeno) VALUES ( 269, 'Vince Vaughn' );
INSERT INTO filmy (id, rok, titul) VALUES ( 58, 2005, 'Mr. & Mrs. Smith' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 58, 266 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 58, 222, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 58, 161, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 58, 267, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 58, 268, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 58, 269, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 270, 'Colin Farrell' );
INSERT INTO umelci (id, jmeno) VALUES ( 271, 'Jared Leto' );
INSERT INTO umelci (id, jmeno) VALUES ( 272, 'Val Kilmer' );
INSERT INTO filmy (id, rok, titul) VALUES ( 59, 2004, 'Alexander Veliký' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 59, 210 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 59, 270, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 59, 161, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 59, 265, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 59, 271, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 59, 272, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 273, 'Tony Scott' );
INSERT INTO umelci (id, jmeno) VALUES ( 274, 'Jacqueline Bisset' );
INSERT INTO umelci (id, jmeno) VALUES ( 275, 'Mickey Rourke' );
INSERT INTO umelci (id, jmeno) VALUES ( 276, 'Mena Suvari' );
INSERT INTO filmy (id, rok, titul) VALUES ( 60, 2005, 'Domino' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 60, 273 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 60, 85, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 60, 274, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 60, 275, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 60, 276, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 60, 126, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 277, 'Antoine Fuqua' );
INSERT INTO umelci (id, jmeno) VALUES ( 278, 'Clive Owen' );
INSERT INTO umelci (id, jmeno) VALUES ( 279, 'Stephen Dillane' );
INSERT INTO umelci (id, jmeno) VALUES ( 280, 'Ioan Gruffudd' );
INSERT INTO umelci (id, jmeno) VALUES ( 281, 'Stellan Skarsgård' );
INSERT INTO filmy (id, rok, titul) VALUES ( 61, 2004, 'Král Artuš' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 61, 277 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 61, 278, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 61, 279, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 61, 85, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 61, 280, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 61, 281, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 282, 'Ivan Reitman' );
INSERT INTO umelci (id, jmeno) VALUES ( 283, 'Luke Wilson' );
INSERT INTO umelci (id, jmeno) VALUES ( 284, 'Anna Faris' );
INSERT INTO umelci (id, jmeno) VALUES ( 285, 'Ilona Alexandra' );
INSERT INTO umelci (id, jmeno) VALUES ( 286, 'Andrea Bertola' );
INSERT INTO filmy (id, rok, titul) VALUES ( 62, 2006, 'Moje Superbejvalka' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 62, 282 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 62, 26, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 62, 283, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 62, 284, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 62, 285, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 62, 286, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 287, 'Gary F. Gray' );
INSERT INTO umelci (id, jmeno) VALUES ( 288, 'Danny DeVito' );
INSERT INTO umelci (id, jmeno) VALUES ( 289, 'Dwayne "The Rock" Johnson' );
INSERT INTO filmy (id, rok, titul) VALUES ( 63, 2005, 'Buď v klidu' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 63, 287 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 63, 24, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 63, 26, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 63, 27, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 63, 288, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 63, 289, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 290, 'Ben Younger' );
INSERT INTO umelci (id, jmeno) VALUES ( 291, 'Meryl Streep' );
INSERT INTO umelci (id, jmeno) VALUES ( 292, 'Bryan Greenberg' );
INSERT INTO umelci (id, jmeno) VALUES ( 293, 'Annie Parisse' );
INSERT INTO umelci (id, jmeno) VALUES ( 294, 'Jon Abrahams' );
INSERT INTO filmy (id, rok, titul) VALUES ( 64, 2005, 'Ideál' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 64, 290 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 64, 26, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 64, 291, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 64, 292, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 64, 293, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 64, 294, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 295, 'Susan Stroman' );
INSERT INTO umelci (id, jmeno) VALUES ( 296, 'Nathan Lane' );
INSERT INTO umelci (id, jmeno) VALUES ( 297, 'Matthew Broderick' );
INSERT INTO umelci (id, jmeno) VALUES ( 298, 'Will Ferrell' );
INSERT INTO umelci (id, jmeno) VALUES ( 299, 'Roger Bart' );
INSERT INTO filmy (id, rok, titul) VALUES ( 65, 2005, 'Producenti' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 65, 295 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 65, 296, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 65, 297, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 65, 26, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 65, 298, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 65, 299, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 300, 'David Carradine' );
INSERT INTO umelci (id, jmeno) VALUES ( 301, 'Lucy Liu' );
INSERT INTO umelci (id, jmeno) VALUES ( 302, 'Michael Madsen' );
INSERT INTO filmy (id, rok, titul) VALUES ( 66, 2003, 'Kill Bill' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 66, 23 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 66, 26, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 66, 300, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 66, 301, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 66, 302, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 303, 'Oliver Hirschbiegel' );
INSERT INTO umelci (id, jmeno) VALUES ( 304, 'James McTeigue' );
INSERT INTO umelci (id, jmeno) VALUES ( 305, 'Nicole Kidman' );
INSERT INTO umelci (id, jmeno) VALUES ( 306, 'Daniel Craig' );
INSERT INTO umelci (id, jmeno) VALUES ( 307, 'Jackson Bond' );
INSERT INTO umelci (id, jmeno) VALUES ( 308, 'Jeffrey Wrigh' );
INSERT INTO filmy (id, rok, titul) VALUES ( 67, 2007, 'Invaze' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 67, 303 );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 67, 304 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 67, 305, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 67, 306, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 67, 251, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 67, 307, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 67, 308, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 309, 'Chris Weitz' );
INSERT INTO umelci (id, jmeno) VALUES ( 310, 'Dakota Blue Richards' );
INSERT INTO umelci (id, jmeno) VALUES ( 311, 'Eva Green' );
INSERT INTO umelci (id, jmeno) VALUES ( 312, 'Jim Carter' );
INSERT INTO filmy (id, rok, titul) VALUES ( 68, 2007, 'The Golden Compass' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 68, 309 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 68, 305, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 68, 306, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 68, 310, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 68, 311, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 68, 312, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 313, 'Nora Ephron' );
INSERT INTO umelci (id, jmeno) VALUES ( 314, 'Shirley MacLaine' );
INSERT INTO umelci (id, jmeno) VALUES ( 315, 'Michael Caine' );
INSERT INTO umelci (id, jmeno) VALUES ( 316, 'Jason Schwartzman' );
INSERT INTO filmy (id, rok, titul) VALUES ( 69, 2005, 'Moje krásná čarodějka' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 69, 313 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 69, 305, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 69, 314, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 69, 298, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 69, 315, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 69, 316, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 317, 'Bob Rafelson' );
INSERT INTO umelci (id, jmeno) VALUES ( 318, 'Milla Jovovich' );
INSERT INTO umelci (id, jmeno) VALUES ( 319, 'Doug Hutchison' );
INSERT INTO filmy (id, rok, titul) VALUES ( 70, 2002, 'Hra o čas' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 70, 317 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 70, 25, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 70, 318, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 70, 281, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 70, 319, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 320, 'Gary Lennon' );
INSERT INTO umelci (id, jmeno) VALUES ( 321, 'Angus Macfadyen' );
INSERT INTO umelci (id, jmeno) VALUES ( 322, 'Stephen Dorff' );
INSERT INTO umelci (id, jmeno) VALUES ( 323, 'Aisha Tyler' );
INSERT INTO umelci (id, jmeno) VALUES ( 324, 'Sarah Strange' );
INSERT INTO filmy (id, rok, titul) VALUES ( 71, 2006, 'Ráže 45' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 71, 320 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 71, 318, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 71, 321, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 71, 322, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 71, 323, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 71, 324, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 325, 'Shekhar Kapur' );
INSERT INTO umelci (id, jmeno) VALUES ( 326, 'Cate Blanchett' );
INSERT INTO filmy (id, rok, titul) VALUES ( 72, 2006, 'Elizabeth: The Golden Age' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 72, 325 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 72, 326, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 72, 278, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 327, 'Alejandro González Iñárritu' );
INSERT INTO umelci (id, jmeno) VALUES ( 328, 'Gael García Bernal' );
INSERT INTO umelci (id, jmeno) VALUES ( 329, 'Jamie McBride' );
INSERT INTO umelci (id, jmeno) VALUES ( 330, 'Kôji Yakusho' );
INSERT INTO filmy (id, rok, titul) VALUES ( 73, 2006, 'Babel' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 73, 327 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 73, 326, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 73, 222, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 73, 328, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 73, 329, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 73, 330, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 331, 'Julia Roberts' );
INSERT INTO umelci (id, jmeno) VALUES ( 332, 'Andy Garcia' );
INSERT INTO filmy (id, rok, titul) VALUES ( 74, 2004, 'Dannyho parťáci 2' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 74, 220 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 74, 221, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 74, 222, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 74, 178, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 74, 331, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 74, 332, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 333, 'Mike Newell' );
INSERT INTO umelci (id, jmeno) VALUES ( 334, 'Julia Stiles' );
INSERT INTO umelci (id, jmeno) VALUES ( 335, 'Kirsten Dunst' );
INSERT INTO umelci (id, jmeno) VALUES ( 336, 'Marcia Gay Harden' );
INSERT INTO filmy (id, rok, titul) VALUES ( 75, 2003, 'Úsměv Mony Lisy' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 75, 333 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 75, 331, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 75, 334, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 75, 335, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 75, 336, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 337, 'Miloš Forman' );
INSERT INTO umelci (id, jmeno) VALUES ( 338, 'Natalie Portman' );
INSERT INTO umelci (id, jmeno) VALUES ( 339, 'Javier Bardem' );
INSERT INTO umelci (id, jmeno) VALUES ( 340, 'Stellan Skarsgårds' );
INSERT INTO umelci (id, jmeno) VALUES ( 341, 'Randy Quaid' );
INSERT INTO umelci (id, jmeno) VALUES ( 342, 'Antonio Bellido' );
INSERT INTO filmy (id, rok, titul) VALUES ( 76, 2006, 'Goyovy přízraky' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 76, 337 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 76, 338, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 76, 339, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 76, 340, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 76, 341, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 76, 342, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 343, 'Alejandro Agresti' );
INSERT INTO umelci (id, jmeno) VALUES ( 344, 'Sandra Bullock' );
INSERT INTO umelci (id, jmeno) VALUES ( 345, 'Willeke van Ammelroy' );
INSERT INTO umelci (id, jmeno) VALUES ( 346, 'Mike Bacarella' );
INSERT INTO filmy (id, rok, titul) VALUES ( 77, 2006, 'Dům u jezera' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 77, 343 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 77, 18, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 77, 344, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 77, 345, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 77, 346, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 77, 232, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 347, 'Donald Petrie' );
INSERT INTO umelci (id, jmeno) VALUES ( 348, 'Benjamin Bratt' );
INSERT INTO umelci (id, jmeno) VALUES ( 349, 'William Shatner' );
INSERT INTO umelci (id, jmeno) VALUES ( 350, 'Ernie Hudson' );
INSERT INTO filmy (id, rok, titul) VALUES ( 78, 2000, 'Slečna Drsňák' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 78, 347 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 78, 344, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 78, 315, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 78, 348, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 78, 349, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 78, 350, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 351, 'John Pasquin' );
INSERT INTO umelci (id, jmeno) VALUES ( 352, 'Regina King' );
INSERT INTO umelci (id, jmeno) VALUES ( 353, 'Enrique Murciano' );
INSERT INTO umelci (id, jmeno) VALUES ( 354, 'Treat Williams' );
INSERT INTO filmy (id, rok, titul) VALUES ( 79, 2004, 'Slečna Drsňák 2: Ještě drsnější' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 79, 351 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 79, 344, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 79, 352, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 79, 353, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 79, 354, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 79, 349, 2 );
INSERT INTO umelci (id, jmeno) VALUES ( 355, 'Stefen Fangmeier' );
INSERT INTO umelci (id, jmeno) VALUES ( 356, 'Edward Speleers' );
INSERT INTO umelci (id, jmeno) VALUES ( 357, 'Sienna Guillory' );
INSERT INTO umelci (id, jmeno) VALUES ( 358, 'Garrett Hedlund' );
INSERT INTO umelci (id, jmeno) VALUES ( 359, 'Djimon Hounsou' );
INSERT INTO filmy (id, rok, titul) VALUES ( 80, 2006, 'Eragon' );
INSERT INTO rezie ( film_id, umelec_id ) VALUES ( 80, 355 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 80, 356, 1 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 80, 357, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 80, 358, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 80, 359, 2 );
INSERT INTO obsazeni ( film_id, umelec_id, poradi ) VALUES ( 80, 230, 2 );

COMMIT;
