/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#include <config.h>

#define CHUNK_SIZE 128

#include <stdlib.h>

#include "map.h"
#include "wrappers.h"
#include "fill.h"

typedef struct {
  Coord *start;
  int entries, bufmax;
} Startbuf;

static void push_start (Coord, Startbuf *);
static void track_starts (int *, Startbuf *, enum fill_op (Coord),
			  Coord);
static Coord pop_start (Startbuf *);

static void
push_start (loc, list)
     Coord loc;
     Startbuf *list;
{
  if (list->entries == list->bufmax)
    {
      list->bufmax++;
      if (list->entries % CHUNK_SIZE == CHUNK_SIZE-1)
	list->start = (Coord *) realloc (list->start, (list->bufmax +
						       CHUNK_SIZE) *
					 sizeof (Coord));
    }
  list->start[list->entries++] = loc;
}

static void
track_starts (tracking, list, check, loc)
     int *tracking;
     Startbuf *list;
     enum fill_op (check) (Coord);
     Coord loc;
{
  if (*tracking)
    {
      if (!check (loc))
	*tracking = 0;
    }
  else
    {
      if (check (loc))
	{
	  *tracking = 1;
	  push_start (loc, list);
	}
    }
}

/* Return the last entry on the list.  Decrease list size.  */
static Coord
pop_start (list)
     Startbuf *list;
{
  return list->start[--list->entries];
}

extern enum fill_op
fill (loc, check, mark)
     Coord loc;
     enum fill_op (check) (Coord);
     enum fill_op (mark) (Coord);
{
  Startbuf left, right;
  int ret_status = 0;

  /* If the starting location already matches the "check" pattern,
     nothing will be done.  */
  if (!check (loc))
    return 0;

  /* There's got to be at least one "left" entry.  */
  left.entries = left.bufmax = 1;
  right.entries = right.bufmax = 0;

  left.start = (Coord *) my_malloc (CHUNK_SIZE * sizeof (Coord));
  right.start = (Coord *) my_malloc (CHUNK_SIZE * sizeof (Coord));
  *left.start = loc;

  while (1)
    {
      Startbuf *now_dir, *opp_dir;
      int up_start, down_start;
      enum fill_op check_status;
      int last_dir = 0;
      Coord location;

      /* Array left_scan has the surrounding cells in order:	632
	 Array right_scan has the same order, mirrored.		8.1
								754 */
      const Coord left_scan[8] = {
	{1, 0}, {1, -1}, {0, -1}, {1, 1}, {0, 1}, {-1, -1}, {-1, 1}, {-1, 0}
      };
      const Coord right_scan[8] = {
	{-1, 0}, {-1, -1}, {0, -1}, {-1, 1}, {0, 1}, {1, -1}, {1, 1}, {1, 0}
      };
      const Coord *scan;

      up_start = down_start = 0;

      if (left.entries)
	{
	  scan = left_scan;
	  now_dir = &left;
	  opp_dir = &right;
	  location = pop_start (&left);
	}
      else if (right.entries)
	{
	  scan = right_scan;
	  now_dir = &right;
	  opp_dir = &left;
	  location = pop_start (&right);
	}
      else
	break;

      check_status = check (location);
      if (check_status == SUCCESSFUL)
	{
	  Coord opp_start;
	  opp_start = add_coord (location, *scan++);
	  if (check (opp_start))
	    push_start (opp_start, opp_dir);
	  
	  /* Do initial checks for vertical search.  */
	  track_starts (&up_start, now_dir, check, add_coord
			(location, *scan++));
	  track_starts (&up_start, now_dir, check, add_coord
			(location, *scan++));
	  track_starts (&down_start, now_dir, check, add_coord
			(location, *scan++));
	  track_starts (&down_start, now_dir, check, add_coord
			(location, *scan++));

	  do
	    {
	      if (mark (location) == SUCCESSFUL && ret_status == 0)
		ret_status = 1;
	      track_starts (&up_start, now_dir, check, add_coord
			    (location, scan[0]));
	      track_starts (&down_start, now_dir, check, add_coord
			    (location, scan[1]));
	      location = add_coord (location, scan[2]);
	      check_status = check (location);
	    }
	  while (check_status == SUCCESSFUL);
	}
      if (check_status == BREAK)
	{
	  ret_status = BREAK;
	  break;
	}
    }
  /* Free the memory used by the start tables.  */
  free (left.start);
  free (right.start);
  return ret_status;
}
