/* difsub.h

   written by Frederic Yves Bois
   13 August 1991
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.difsub.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:14:59
      Author:  @a
   -- SCCS  ---------

   Header difsubTypes : for procedure difsub and others
*/

#ifndef DIFSUB_INCLUDED

/* ----- Inclusions */

#include "global.h"


/* ----- Constants */

  /* Return values from difsub() */

#define DS_INTERNAL 0
#define DS_OK       1

#define DS_NOTREQDERROR  (-1)
#define DS_ORDERTOOLARGE (-2)
#define DS_NOCONVERGENCE (-3)
#define DS_ERRORTOOSMALL (-4)

  /* Step flag to difsub */

#define DSSTEP_INIT 0
#define DSSTEP_NEW  1
#define DSSTEP_LAST (-1)


/* ----- Enumerations */

/* ----- Typedefs */
typedef double matType1[dim1Max];
typedef double matType2[8];
typedef double matType3[7];
typedef double *matType11[dim1Max];
typedef double *matType31[7];
typedef matType3 matType543[2][3];

typedef struct oldsRec {
  matType31 derivold;
  matType1 errorold;
  double hold, hPreviousold;
  long currOrderold;
  double told;
  matType1 yold;
} oldsRec;

typedef struct coefsRec {
  matType2 a;
  double bnd, e, eup, edwn, enq1, enq2, enq3;
  matType543 pertst;
} coefsRec;

typedef struct utilsRec {
  long currOrder, flagpsaveEval;
  double hPrevious;
  long nbrStepBeforModif;
  matType11 psave;
  double scalFact;
} utilsRec;

typedef struct memRec {
  oldsRec olds;
  coefsRec coefs;
  utilsRec utils;
} memRec;


/* ----- Macros */

/* ----- Globals/Externals */

/* ----- Prototypes */

#define DIFSUB_INCLUDED
#endif
