/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpVisitor;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.text.SourceMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    public static final int TAILCALL = 2;
    public static final int INLINE_IF_CONSTANT = 4;
    public static final int MAY_CONTAIN_BACK_JUMP = 8;
    LambdaExp context;
    public ApplyExp nextCall;

    public final Expression getFunction() {
        return this.func;
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public void setFunction(Expression func) {
        this.func = func;
    }

    public void setFunction(Procedure proc) {
        this.func = new QuoteExp(proc);
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public Expression getArg(int i) {
        return this.args[i];
    }

    public void setArg(int i, Expression arg) {
        this.args[i] = arg;
    }

    public final boolean isTailCall() {
        return this.getFlag(2);
    }

    public final void setTailCall(boolean tailCall) {
        this.setFlag(tailCall, 2);
    }

    public ApplyExp setFuncArgs(Expression func, Expression[] args) {
        this.setFunction(func);
        this.setArgs(args);
        this.setFlag(false, 1);
        return this;
    }

    public ApplyExp setFuncArgs(Procedure proc, Expression[] args) {
        return this.setFuncArgs(new QuoteExp(proc), args);
    }

    public final Object getFunctionValue() {
        return this.func instanceof QuoteExp ? ((QuoteExp)this.func).getValue() : null;
    }

    public ApplyExp(Expression f, Expression ... a) {
        this.func = f;
        this.args = a;
    }

    public ApplyExp(Procedure p, Expression ... a) {
        this(new QuoteExp(p), a);
    }

    public ApplyExp(Method m, Expression ... a) {
        this(new QuoteExp(new PrimProcedure(m)), a);
    }

    @Override
    protected boolean mustCompile() {
        return false;
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        Object proc = this.func.eval(ctx);
        int n = this.args.length;
        Object[] vals = new Object[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this.args[i].eval(ctx);
        }
        ((Procedure)proc).checkN(vals, ctx);
    }

    private static void compileToArray(Expression[] args, int start, Compilation comp) {
        CodeAttr code = comp.getCode();
        int argslength = args.length;
        int nargs = argslength - start;
        if (nargs == 0) {
            code.emitGetStatic(Compilation.noArgsField);
            return;
        }
        code.emitPushInt(nargs);
        code.emitNewArray(Type.pointer_type);
        for (int i = start; i < argslength; ++i) {
            Expression arg = args[i];
            if (comp.usingCPStyle() && !(arg instanceof QuoteExp) && !(arg instanceof ReferenceExp)) {
                arg.compileWithPosition(comp, Target.pushObject);
                code.emitSwap();
                code.emitDup(1, 1);
                code.emitSwap();
                code.emitPushInt(i);
                code.emitSwap();
            } else {
                code.emitDup(Compilation.objArrayType);
                code.emitPushInt(i);
                arg.compileWithPosition(comp, Target.pushObject);
            }
            code.emitArrayStore(Type.pointer_type);
        }
    }

    @Override
    public void compile(Compilation comp, Target target) {
        ApplyExp.compile(this, comp, target, true);
    }

    public static void compile(ApplyExp exp, Compilation comp, Target target) {
        ApplyExp.compile(exp, comp, target, false);
    }

    static void compile(ApplyExp exp, Compilation comp, Target target, boolean checkInlineable) {
        Method method;
        boolean tail_recurse;
        int args_length = exp.args.length;
        Expression exp_func = exp.func;
        LambdaExp func_lambda = null;
        String func_name = null;
        Declaration owner = null;
        Object quotedValue = null;
        if (exp_func instanceof LambdaExp) {
            func_lambda = (LambdaExp)exp_func;
            func_name = func_lambda.getName();
            if (func_name == null) {
                func_name = "<lambda>";
            }
        } else if (exp_func instanceof ReferenceExp) {
            Expression dvalue;
            ReferenceExp func_ref = (ReferenceExp)exp_func;
            owner = func_ref.contextDecl();
            Declaration func_decl = func_ref.binding;
            while (func_decl != null && func_decl.isAlias() && (dvalue = func_decl.getValueRaw()) instanceof ReferenceExp) {
                func_ref = (ReferenceExp)dvalue;
                if (owner != null || func_decl.needsContext() || func_ref.binding == null) break;
                func_decl = func_ref.binding;
                owner = func_ref.contextDecl();
            }
            if (!func_decl.getFlag(65536L)) {
                Expression value = func_decl.getValue();
                func_name = func_decl.getName();
                if (value != null && value instanceof LambdaExp) {
                    func_lambda = (LambdaExp)value;
                }
                if (value != null && value instanceof QuoteExp) {
                    quotedValue = ((QuoteExp)value).getValue();
                }
            }
        } else if (exp_func instanceof QuoteExp) {
            quotedValue = ((QuoteExp)exp_func).getValue();
        }
        if (checkInlineable && quotedValue instanceof Procedure) {
            Procedure proc = (Procedure)quotedValue;
            if (target instanceof IgnoreTarget && proc.isSideEffectFree()) {
                for (int i = 0; i < args_length; ++i) {
                    exp.args[i].compile(comp, target);
                }
                return;
            }
            try {
                if (ApplyExp.inlineCompile(proc, exp, comp, target)) {
                    return;
                }
            }
            catch (Throwable ex) {
                comp.getMessages().error('e', "caught exception in inline-compiler for " + quotedValue + " - " + ex, ex);
                return;
            }
        }
        CodeAttr code = comp.getCode();
        boolean bl = tail_recurse = exp.isTailCall() && func_lambda != null && func_lambda == comp.curLambda && func_lambda.opt_args == 0 && func_lambda.keywords == null;
        if (func_lambda != null) {
            if (func_lambda.max_args >= 0 && args_length > func_lambda.max_args || args_length < func_lambda.min_args) {
                throw new Error("internal error - wrong number of parameters for " + func_lambda);
            }
            int conv = func_lambda.getCallConvention();
            if (func_lambda.primMethods == null && !func_lambda.isClassGenerated() && !func_lambda.getInlineOnly()) {
                func_lambda.allocMethod(func_lambda.outerLambda(), comp);
            }
            if (comp.inlineOk(func_lambda) && !tail_recurse && (conv <= 2 || conv == 3 && !exp.isTailCall()) && (method = func_lambda.getMethod(args_length)) != null) {
                PrimProcedure pproc = new PrimProcedure(method, func_lambda);
                boolean is_static = method.getStaticFlag();
                boolean extraArg = false;
                if (!is_static || func_lambda.declareClosureEnv() != null) {
                    if (is_static) {
                        extraArg = true;
                    }
                    if (comp.curLambda == func_lambda) {
                        code.emitLoad(func_lambda.closureEnv != null ? func_lambda.closureEnv : func_lambda.thisVariable);
                    } else if (owner != null) {
                        owner.load(null, 0, comp, Target.pushObject);
                    } else {
                        func_lambda.getOwningLambda().loadHeapFrame(comp);
                    }
                }
                pproc.compile(extraArg ? Type.voidType : null, exp, comp, target);
                return;
            }
        }
        if (func_lambda != null && func_lambda.getInlineOnly() && !tail_recurse && func_lambda.min_args == args_length) {
            ApplyExp.pushArgs(func_lambda, exp.args, exp.args.length, null, comp);
            if (func_lambda.getFlag(128)) {
                ApplyExp.popParams(code, func_lambda, null, false);
                code.emitTailCall(false, func_lambda.getVarScope());
                return;
            }
            func_lambda.flags |= 0x80;
            LambdaExp saveLambda = comp.curLambda;
            comp.curLambda = func_lambda;
            func_lambda.allocChildClasses(comp);
            func_lambda.allocParameters(comp);
            ApplyExp.popParams(code, func_lambda, null, false);
            func_lambda.enterFunction(comp);
            func_lambda.body.compileWithPosition(comp, target);
            func_lambda.compileEnd(comp);
            func_lambda.generateApplyMethods(comp);
            code.popScope();
            comp.curLambda = saveLambda;
            return;
        }
        if (comp.curLambda.isHandlingTailCalls() && (exp.isTailCall() || target instanceof ConsumerTarget) && !comp.curLambda.getInlineOnly()) {
            ClassType typeContext = Compilation.typeCallContext;
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
            if (args_length <= 4) {
                for (int i = 0; i < args_length; ++i) {
                    exp.args[i].compileWithPosition(comp, Target.pushObject);
                }
                comp.loadCallContext();
                code.emitInvoke(Compilation.typeProcedure.getDeclaredMethod("check" + args_length, args_length + 1));
            } else {
                ApplyExp.compileToArray(exp.args, 0, comp);
                comp.loadCallContext();
                code.emitInvoke(Compilation.typeProcedure.getDeclaredMethod("checkN", 2));
            }
            if (exp.isTailCall()) {
                code.emitReturn();
            } else if (((ConsumerTarget)target).isContextTarget()) {
                comp.loadCallContext();
                code.emitInvoke(typeContext.getDeclaredMethod("runUntilDone", 0));
            } else {
                comp.loadCallContext();
                code.emitLoad(((ConsumerTarget)target).getConsumerVariable());
                code.emitInvoke(typeContext.getDeclaredMethod("runUntilValue", 1));
            }
            return;
        }
        if (!tail_recurse) {
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
        }
        boolean toArray = tail_recurse ? func_lambda.max_args < 0 : args_length > 4;
        int[] incValues = null;
        if (tail_recurse) {
            int fixed = func_lambda.min_args;
            incValues = new int[fixed];
            ApplyExp.pushArgs(func_lambda, exp.args, fixed, incValues, comp);
            if (toArray) {
                ApplyExp.compileToArray(exp.args, fixed, comp);
            }
            method = null;
        } else if (toArray) {
            ApplyExp.compileToArray(exp.args, 0, comp);
            method = Compilation.applyNmethod;
        } else {
            for (int i = 0; i < args_length; ++i) {
                exp.args[i].compileWithPosition(comp, Target.pushObject);
                if (!code.reachableHere()) break;
            }
            method = Compilation.applymethods[args_length];
        }
        if (!code.reachableHere()) {
            if (comp.warnUnreachable()) {
                comp.error('w', "unreachable code");
            }
            return;
        }
        if (tail_recurse) {
            ApplyExp.popParams(code, func_lambda, incValues, toArray);
            code.emitTailCall(false, func_lambda.getVarScope());
            return;
        }
        code.emitInvokeVirtual(method);
        target.compileFromStack(comp, Type.pointer_type);
    }

    @Override
    public Expression deepCopy(IdentityHashTable mapper) {
        Expression f = ApplyExp.deepCopy(this.func, mapper);
        Expression[] a = ApplyExp.deepCopy(this.args, mapper);
        if (f == null && this.func != null || a == null && this.args != null) {
            return null;
        }
        ApplyExp copy = new ApplyExp(f, a);
        copy.flags = this.getFlags();
        return copy;
    }

    @Override
    protected <R, D> R visit(ExpVisitor<R, D> visitor, D d) {
        return visitor.visitApplyExp(this, d);
    }

    public void visitArgs(InlineCalls visitor) {
        this.args = visitor.visitExps(this.args, this.args.length, null);
    }

    @Override
    protected <R, D> void visitChildren(ExpVisitor<R, D> visitor, D d) {
        this.func = visitor.visitAndUpdate(this.func, d);
        if (visitor.exitValue == null) {
            this.args = visitor.visitExps(this.args, this.args.length, d);
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Apply", ")", 2);
        if (this.isTailCall()) {
            out.print(" [tailcall]");
        }
        if (this.type != null && this.type != Type.pointer_type) {
            out.print(" => ");
            out.print(this.type);
        }
        out.writeSpaceFill();
        this.printLineColumn(out);
        this.func.print(out);
        for (int i = 0; this.args != null && i < this.args.length; ++i) {
            out.writeSpaceLinear();
            this.args[i].print(out);
        }
        out.endLogicalBlock(")");
    }

    private static void pushArgs(LambdaExp lexp, Expression[] args, int args_length, int[] incValues, Compilation comp) {
        Declaration param = lexp.firstDecl();
        for (int i = 0; i < args_length; ++i) {
            Expression arg = args[i];
            if (param.ignorable()) {
                arg.compile(comp, Target.Ignore);
            } else if (incValues == null || (incValues[i] = SetExp.canUseInc(arg, param)) == 65536) {
                arg.compileWithPosition(comp, StackTarget.getInstance(param.getType()));
            }
            param = param.nextDecl();
        }
    }

    private static void popParams(CodeAttr code, LambdaExp lexp, int[] incValues, boolean toArray) {
        Variable vars = lexp.getVarScope().firstVar();
        Declaration decls = lexp.firstDecl();
        if (vars != null && vars.getName() == "this") {
            vars = vars.nextVar();
        }
        if (vars != null && vars.getName() == "$ctx") {
            vars = vars.nextVar();
        }
        ApplyExp.popParams(code, 0, lexp.min_args, toArray, incValues, decls, vars);
    }

    private static void popParams(CodeAttr code, int paramNo, int count, boolean toArray, int[] incValues, Declaration decl, Variable vars) {
        if (count > 0) {
            ApplyExp.popParams(code, paramNo + 1, --count, toArray, incValues, decl.nextDecl(), decl.getVariable() == null ? vars : vars.nextVar());
            if (!decl.ignorable()) {
                if (incValues != null && incValues[paramNo] != 65536) {
                    code.emitInc(vars, (short)incValues[paramNo]);
                } else {
                    code.emitStore(vars);
                }
            }
        } else if (toArray) {
            code.emitStore(vars);
        }
    }

    public final Type getTypeRaw() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    @Override
    public boolean side_effects() {
        Object value = ApplyExp.derefFunc(this.func).valueIfConstant();
        if (value instanceof Procedure && ((Procedure)value).isSideEffectFree()) {
            Expression[] a = this.args;
            int alen = a.length;
            for (int i = 0; i < alen; ++i) {
                if (!a[i].side_effects()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static Expression derefFunc(Expression afunc) {
        if (afunc instanceof ReferenceExp) {
            Declaration func_decl = ((ReferenceExp)afunc).binding;
            if ((func_decl = Declaration.followAliases(func_decl)) != null && !func_decl.getFlag(65536L)) {
                afunc = func_decl.getValue();
            }
        }
        return afunc;
    }

    @Override
    protected Type calculateType() {
        Expression afunc = ApplyExp.derefFunc(this.func);
        if (afunc instanceof QuoteExp) {
            Object value = ((QuoteExp)afunc).getValue();
            if (value instanceof Procedure) {
                this.type = ((Procedure)value).getReturnType(this.args);
            }
        } else if (afunc instanceof LambdaExp) {
            this.type = ((LambdaExp)afunc).getReturnType();
        }
        return this.type;
    }

    public static Inlineable asInlineable(Procedure proc) {
        if (proc instanceof Inlineable) {
            return (Inlineable)((Object)proc);
        }
        return (Inlineable)Procedure.compilerKey.get(proc);
    }

    static boolean inlineCompile(Procedure proc, ApplyExp exp, Compilation comp, Target target) throws Throwable {
        Inlineable compiler = ApplyExp.asInlineable(proc);
        if (compiler == null) {
            return false;
        }
        compiler.compile(exp, comp, target);
        return true;
    }

    public final Expression inlineIfConstant(Procedure proc, InlineCalls visitor) {
        return this.inlineIfConstant(proc, visitor.getMessages());
    }

    public final Expression inlineIfConstant(Procedure proc, SourceMessages messages) {
        int len = this.args.length;
        Object[] vals = new Object[len];
        int i = len;
        while (--i >= 0) {
            Declaration decl;
            Expression arg = this.args[i];
            if (arg instanceof ReferenceExp && (decl = ((ReferenceExp)arg).getBinding()) != null && (arg = decl.getValue()) == QuoteExp.undefined_exp) {
                return this;
            }
            if (!(arg instanceof QuoteExp)) {
                return this;
            }
            vals[i] = ((QuoteExp)arg).getValue();
        }
        try {
            return new QuoteExp(proc.applyN(vals), this.type).setLine(this);
        }
        catch (Throwable ex) {
            if (messages != null) {
                messages.error('w', "call to " + proc + " throws " + ex);
            }
            return this;
        }
    }

    @Override
    public String toString() {
        if (this == LambdaExp.unknownContinuation) {
            return "ApplyExp[unknownContinuation]";
        }
        return "ApplyExp/" + (this.args == null ? 0 : this.args.length) + '[' + this.func + ']';
    }
}

