/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.ThisExp;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.KeyPair;
import gnu.mapping.Symbol;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindCapturedVars
extends ExpWalker {
    Hashtable unknownDecls = null;
    ModuleExp currentModule = null;

    public static void findCapturedVars(Expression exp, Compilation comp) {
        FindCapturedVars walker = new FindCapturedVars();
        walker.setContext(comp);
        exp.walk(walker);
    }

    @Override
    protected Expression walkApplyExp(ApplyExp exp) {
        boolean skipFunc = false;
        if (exp.func instanceof ReferenceExp && Compilation.defaultCallConvention <= 1) {
            LambdaExp lexp;
            Expression value;
            Declaration decl = Declaration.followAliases(((ReferenceExp)exp.func).binding);
            if (decl != null && decl.context instanceof ModuleExp && !decl.isPublic() && !decl.getFlag(4096L) && (value = decl.getValue()) instanceof LambdaExp && !(lexp = (LambdaExp)value).getNeedsClosureEnv()) {
                skipFunc = true;
            }
        } else if (exp.func instanceof QuoteExp && exp.getArgCount() > 0) {
            Object val = ((QuoteExp)exp.func).getValue();
            Expression arg0 = exp.getArg(0);
            if (val instanceof PrimProcedure && arg0 instanceof ReferenceExp) {
                Expression value;
                PrimProcedure pproc = (PrimProcedure)val;
                Declaration decl = Declaration.followAliases(((ReferenceExp)arg0).binding);
                if (decl != null && decl.context instanceof ModuleExp && !decl.getFlag(4096L) && (value = decl.getValue()) instanceof ClassExp) {
                    Expression[] args = exp.getArgs();
                    LambdaExp lexp = (LambdaExp)value;
                    if (!lexp.getNeedsClosureEnv()) {
                        exp.nextCall = decl.firstCall;
                        decl.firstCall = exp;
                        for (int i = 1; i < args.length; ++i) {
                            args[i].walk(this);
                        }
                        return exp;
                    }
                }
            }
        }
        if (!skipFunc) {
            exp.func = exp.func.walk(this);
        }
        if (this.exitValue == null) {
            exp.args = this.walkExps(exp.args);
        }
        return exp;
    }

    @Override
    public void walkDefaultArgs(LambdaExp exp) {
        if (exp.defaultArgs == null) {
            return;
        }
        super.walkDefaultArgs(exp);
        for (Declaration param = exp.firstDecl(); param != null; param = param.nextDecl()) {
            if (param.isSimple()) continue;
            exp.setFlag(true, 512);
            break;
        }
    }

    @Override
    protected Expression walkClassExp(ClassExp exp) {
        Expression ret = super.walkClassExp(exp);
        if (!exp.explicitInit && !exp.instanceType.isInterface()) {
            Compilation.getConstructor(exp.instanceType, exp);
        } else if (exp.getNeedsClosureEnv()) {
            LambdaExp child = exp.firstChild;
            while (child != null) {
                if ("*init*".equals(child.getName())) {
                    child.setNeedsStaticLink(true);
                }
                child = child.nextSibling;
            }
        }
        if (exp.isSimple() && exp.getNeedsClosureEnv() && exp.nameDecl != null && exp.nameDecl.getType() == Compilation.typeClass) {
            exp.nameDecl.setType(Compilation.typeClassType);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkModuleExp(ModuleExp exp) {
        ModuleExp saveModule = this.currentModule;
        Hashtable saveDecls = this.unknownDecls;
        this.currentModule = exp;
        this.unknownDecls = null;
        try {
            Expression expression = this.walkLambdaExp(exp);
            return expression;
        }
        finally {
            this.currentModule = saveModule;
            this.unknownDecls = saveDecls;
        }
    }

    @Override
    protected Expression walkFluidLetExp(FluidLetExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.base != null) continue;
            Declaration bind = this.allocUnboundDecl(decl.getSymbol(), false);
            this.capture(bind);
            decl.base = bind;
        }
        return super.walkLetExp(exp);
    }

    @Override
    protected Expression walkLetExp(LetExp exp) {
        if (exp.body instanceof BeginExp) {
            Expression[] inits = exp.inits;
            int len = inits.length;
            Expression[] exps = ((BeginExp)exp.body).exps;
            int init_index = 0;
            Declaration decl = exp.firstDecl();
            for (int begin_index = 0; begin_index < exps.length && init_index < len; ++begin_index) {
                Expression st = exps[begin_index];
                if (!(st instanceof SetExp)) continue;
                SetExp set = (SetExp)st;
                if (set.binding != decl || inits[init_index] != QuoteExp.nullExp || !set.isDefining()) continue;
                Expression new_value = set.new_value;
                if ((new_value instanceof QuoteExp || new_value instanceof LambdaExp) && decl.getValue() == new_value) {
                    inits[init_index] = new_value;
                    exps[begin_index] = QuoteExp.voidExp;
                }
                ++init_index;
                decl = decl.nextDecl();
            }
        }
        return super.walkLetExp(exp);
    }

    static Expression checkInlineable(LambdaExp current, Set<LambdaExp> seen) {
        if (current.returnContinuation == LambdaExp.unknownContinuation) {
            return current.returnContinuation;
        }
        if (seen.contains(current)) {
            return current.returnContinuation;
        }
        if (current.getCanRead() || current.isClassMethod() || current.min_args != current.max_args) {
            current.returnContinuation = LambdaExp.unknownContinuation;
            return LambdaExp.unknownContinuation;
        }
        seen.add(current);
        Expression r = current.returnContinuation;
        if (current.tailCallers != null) {
            LambdaExp outer = current.outerLambda();
            for (LambdaExp p : current.tailCallers) {
                Expression t = FindCapturedVars.checkInlineable(p, seen);
                if (t == LambdaExp.unknownContinuation) {
                    if (r == null || r == p.body) {
                        r = p.body;
                        current.inlineHome = p;
                        continue;
                    }
                    current.returnContinuation = LambdaExp.unknownContinuation;
                    return t;
                }
                if (r == null) {
                    r = t;
                    if (current.inlineHome != null) continue;
                    current.inlineHome = current.nestedIn(p) ? p : p.inlineHome;
                    continue;
                }
                if ((t == null || r == t) && !current.getFlag(32)) continue;
                current.returnContinuation = LambdaExp.unknownContinuation;
                return LambdaExp.unknownContinuation;
            }
        }
        return r;
    }

    @Override
    protected Expression walkLambdaExp(LambdaExp exp) {
        LinkedHashSet<LambdaExp> seen = new LinkedHashSet<LambdaExp>();
        Expression caller = FindCapturedVars.checkInlineable(exp, seen);
        if (!(caller == LambdaExp.unknownContinuation || exp.outer instanceof ModuleExp && exp.nameDecl != null)) {
            exp.setInlineOnly(true);
        }
        return super.walkLambdaExp(exp);
    }

    public void capture(Declaration decl) {
        LambdaExp declValue;
        LambdaExp curLambda;
        if (!decl.getCanRead() && !decl.getCanCall()) {
            return;
        }
        if (decl.field != null && decl.field.getStaticFlag()) {
            return;
        }
        if (this.comp.immediate && decl.hasConstantValue()) {
            return;
        }
        LambdaExp declLambda = decl.getContext().currentLambda();
        LambdaExp oldParent = null;
        LambdaExp chain = null;
        for (curLambda = this.getCurrentLambda(); curLambda != declLambda && curLambda.getInlineOnly(); curLambda = curLambda.getCaller()) {
            LambdaExp curParent = curLambda.outerLambda();
            if (curParent != oldParent) {
                chain = curParent.firstChild;
                oldParent = curParent;
            }
            if (chain == null || curLambda.inlineHome == null) {
                curLambda.setCanCall(false);
                return;
            }
            chain = chain.nextSibling;
        }
        if (this.comp.usingCPStyle() ? curLambda instanceof ModuleExp : curLambda == declLambda) {
            return;
        }
        Expression value = decl.getValue();
        if (value == null || !(value instanceof LambdaExp)) {
            declValue = null;
        } else {
            declValue = (LambdaExp)value;
            if (declValue.getInlineOnly()) {
                return;
            }
            if (declValue.isHandlingTailCalls()) {
                declValue = null;
            } else if (declValue == curLambda && !decl.getCanRead()) {
                return;
            }
        }
        if (decl.getFlag(65536L)) {
            for (LambdaExp parent = curLambda; parent != declLambda; parent = parent.outerLambda()) {
                if (parent.nameDecl == null || !parent.nameDecl.getFlag(2048L)) continue;
                decl.setFlag(2048L);
                break;
            }
        }
        if (decl.base != null) {
            decl.base.setCanRead(true);
            this.capture(decl.base);
        } else if (decl.getCanRead() || decl.getCanCall() || declValue == null) {
            if (!decl.isStatic()) {
                LambdaExp parent;
                LambdaExp heapLambda = curLambda;
                heapLambda.setImportsLexVars();
                LambdaExp outer = parent = heapLambda.outerLambda();
                while (outer != declLambda && outer != null) {
                    heapLambda = outer;
                    if (!decl.getCanRead() && declValue == outer) break;
                    Declaration heapDecl = heapLambda.nameDecl;
                    if (heapDecl != null && heapDecl.getFlag(2048L)) {
                        this.comp.error('e', "static " + heapLambda.getName() + " references non-static " + decl.getName());
                    }
                    if (heapLambda instanceof ClassExp && heapLambda.getName() != null && ((ClassExp)heapLambda).isSimple()) {
                        this.comp.error('w', heapLambda.nameDecl, "simple class ", " requiring lexical link (because of reference to " + decl.getName() + ") - use define-class instead");
                    }
                    heapLambda.setNeedsStaticLink();
                    outer = heapLambda.outerLambda();
                }
            }
            declLambda.capture(decl);
        }
    }

    Declaration allocUnboundDecl(Object name, boolean function2) {
        Declaration decl;
        Object key = name;
        if (function2 && name instanceof Symbol) {
            if (!this.getCompilation().getLanguage().hasSeparateFunctionNamespace()) {
                function2 = false;
            } else {
                key = new KeyPair((Symbol)name, EnvironmentKey.FUNCTION);
            }
        }
        if (this.unknownDecls == null) {
            this.unknownDecls = new Hashtable(100);
            decl = null;
        } else {
            decl = (Declaration)this.unknownDecls.get(key);
        }
        if (decl == null) {
            decl = this.currentModule.addDeclaration(name);
            decl.setSimple(false);
            decl.setPrivate(true);
            if (function2) {
                decl.setProcedureDecl(true);
            }
            if (this.currentModule.isStatic()) {
                decl.setFlag(2048L);
            }
            decl.setCanRead(true);
            decl.setCanWrite(true);
            decl.setFlag(65536L);
            decl.setIndirectBinding(true);
            this.unknownDecls.put(key, decl);
        }
        return decl;
    }

    @Override
    protected Expression walkReferenceExp(ReferenceExp exp) {
        Object resolved;
        Declaration decl = exp.getBinding();
        if (decl == null) {
            decl = this.allocUnboundDecl(exp.getSymbol(), exp.isProcedureName());
            exp.setBinding(decl);
        }
        if (decl.getFlag(65536L) && this.comp.getBooleanOption("warn-undefined-variable", false) && (resolved = this.comp.resolve(exp.getSymbol(), exp.isProcedureName())) == null) {
            this.comp.error('w', "no declaration seen for " + exp.getName(), exp);
        }
        this.capture(exp.contextDecl(), decl);
        return exp;
    }

    void capture(Declaration containing, Declaration decl) {
        if (decl.isAlias() && decl.value instanceof ReferenceExp) {
            ReferenceExp rexp = (ReferenceExp)decl.value;
            Declaration orig = rexp.binding;
            if (!(orig == null || containing != null && orig.needsContext())) {
                this.capture(rexp.contextDecl(), orig);
                return;
            }
        }
        if (containing != null && decl.needsContext()) {
            this.capture(containing);
        } else {
            this.capture(decl);
        }
    }

    @Override
    protected Expression walkThisExp(ThisExp exp) {
        if (exp.isForContext()) {
            this.getCurrentLambda().setImportsLexVars();
            return exp;
        }
        return this.walkReferenceExp(exp);
    }

    @Override
    protected Expression walkSetExp(SetExp exp) {
        Declaration decl = exp.binding;
        if (decl == null) {
            exp.binding = decl = this.allocUnboundDecl(exp.getSymbol(), exp.isFuncDef());
        }
        if (!decl.ignorable()) {
            if (!exp.isDefining()) {
                decl = Declaration.followAliases(decl);
            }
            this.capture(exp.contextDecl(), decl);
        }
        return super.walkSetExp(exp);
    }
}

