
;;; d-shift-tab.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-shift-tab.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Shift tab keyboard binding
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

;;; fssadf                asdfasd                    asdfsad
;;; eddfs                 sdadfsc sadsd
;;; (setq str (save-excursion (forward-line -1) (d-current-line-as-string)))
;;; (setq cur (current-column))
(defun d-shift-tab ()
  (interactive)
  (let ((str (save-excursion
               (forward-line -1)
               (d-current-line-as-string)))
        (old (current-column))
        (cur (current-column))
        (n   -1)
        (done nil))
    (if (save-excursion
          (d-goto-column cur)
          (skip-chars-backward " \t")
          (bolp))
        (indent-for-tab-command)
      (while (not done)
        (if (> cur (length str))
            (setq str (save-excursion
                        (forward-line n)
                        (d-current-line-as-string)))
          (setq done t))
        (decf n))
      (while (and (< cur (length str)) (/= ? (aref str cur)))
        (incf cur))
      (while (and (< cur (length str)) (= ? (aref str cur)))
        (incf cur))
      (d-goto-column-force old cur)
      )))

;;; (setq col 20)
;;; (setq old 10)
(defun d-goto-column-force (old col)
  (d-goto-column old)
  (insert (make-string (- col old) ? ))
  (d-goto-column col))

(progn
  (global-set-key [(backtab)] 'd-shift-tab)
  (define-key lisp-mode-map [(shift tab)] 'd-shift-tab)
  (define-key java-mode-map [(shift tab)] 'd-shift-tab)
  (define-key text-mode-map [(shift tab)] 'd-shift-tab))

;;;
;;;
;;; das                 askdjasd           asdsd
;;; daskld              dasdasd            asds
;;; sddd                asdsf              sfdf
;;; dsaasd              asdasdasdasd       dfasdf
;;; asdd                dasdasd            adsasd
;;; adasd               asdads             sdas
;;; asdds               adasda             adasdf
;;; asdsd               dsasd              sddf
;;;
;;; dasds               asdaf              afsdaf
;;;
;;; asdds               sdaf               aafad

(provide 'd-shift-tab)
;;; d-shift-tab.el ends here
