
;;; d-outline.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-outline.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: outline minor mode code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(add-hook 'find-file-hook 'd-outline-mode-hook)
(defun d-outline-mode-hook ()
  (interactive)
  (if (and (buffer-file-name) (string-match "\\.log$" (buffer-file-name)))
      (progn
        ;;(d-foo)
        (goto-char (point-min))
        (while (re-search-forward "^\\*+\\([-+]\\)" nil t)
          (replace-match "" nil nil nil 1))
        (save-buffer)
        (goto-char (point-min))
    ))
  )

(setq auto-mode-alist
      (append '(("\\.log$"  . outline-mode))
              auto-mode-alist))

(setq auto-mode-alist
      (cons '("^log$" . outline-mode)
            auto-mode-alist))

(eval-after-load "outline"
  '(progn
     (progn
       (defvar d-outline-toggle nil)
       (make-local-variable 'd-outline-toggle)
       (define-key outline-mode-map [f5] 'd-outline-f5)
       (define-key outline-mode-map [(shift f5)] 'd-outline-shift-f5)

       (define-key outline-mode-map [(meta up)] 'outline-backward-same-level)
       (define-key outline-mode-map [(meta down)]
         (function
          (lambda () (interactive)
            ;;           (call-interactively 'outline-up-heading)
            (call-interactively 'outline-forward-same-level)
            )))

       )))


;;(defun d-outline-f5 ()
;;  (interactive)
;;  (if d-outline-toggle
;;      (progn
;;        (setq d-outline-toggle nil)
;;        (show-children))
;;    (progn
;;      (setq d-outline-toggle t)
;;      (hide-subtree))))

;;      (define-key outline-mode-map [(shift f5)]
;;        (function
;;         (lambda () (interactive)
;;           (if (save-excursion
;;                 (beginning-of-line)
;;                 (looking-at "\\+"))
;;;;               d-outline-toggle
;;               (progn
;;;;                 (setq d-outline-toggle nil)
;;                 (show-subtree))
;;             (progn
;;;;               (setq d-outline-toggle t)
;;               (hide-subtree))
;;             ))))

(defun d-outline-f5 ()
  (interactive)
  (if (save-excursion
        (beginning-of-line)
        (skip-chars-forward "*")
        (looking-at "\\+"))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (delete-char 1)
          (insert "-"))
        (show-children))
    (if (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (looking-at "\\-"))
        (progn
          (save-excursion
            (beginning-of-line)
            (skip-chars-forward "*")
            (delete-char 1)
            (insert "+"))
          (hide-subtree))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (insert "+")))))
  )

(defun d-outline-shift-f5 ()
  (interactive)
  (if (save-excursion
        (beginning-of-line)
        (skip-chars-forward "*")
        (looking-at "\\+"))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (delete-char 1)
          (insert "-"))
        (show-subtree))
    (if (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (looking-at "\\-"))
        (progn
          (save-excursion
            (beginning-of-line)
            (skip-chars-forward "*")
            (delete-char 1)
            (insert "+"))
          (hide-subtree))
      (progn
        (save-excursion
          (beginning-of-line)
          (skip-chars-forward "*")
          (insert "+")))))
  )

(provide 'd-outline)
