
;;; manaaki-file-copier.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: manaaki-file-copier.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Te Whare Manaaki copying functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:


;;; (file-earlier-than "c:/home/copier.el" "c:/home/copier2.el")
(defun manaaki-file< (file1 file2)
  (when (and (file-exists-p file1) (file-exists-p file2))
    (setq t0 (nth 5 (file-attributes file1)))
    (setq time0 (+ (* 65536.0 (car t0)) (cadr t0)))
    (setq t1 (nth 5 (file-attributes file2)))
    (setq time1 (+ (* 65536.0 (car t1)) (cadr t1)))
    (< time0 time1)))

(defvar manaaki-file-stump "~/manaaki")

;;;(apply 'message "%s" '(123))
;;; (manaaki-log "hello%s" 123)
(defun manaaki-log (string &rest rest)
  (apply 'message string rest)
  (save-excursion
    (find-file-noselect manaaki-file-name)
    (goto-char (point-max))
    (insert (apply 'format string rest) "\n")))

(defun manaaki-file-copy-from-c ()
  ;;(interactive)
  (let (list ptr file-c file-f size-c size-f file1 file2
             (case-fold-search t))
    (assert (file-exists-p drive-f))
    (save-some-buffers 'NO-QUESTIONS)
    (setq list (directory-files-deep "/media/www/C80GB/home/"))
    (message "Finished directory-files-deep /media/www/C80GB/home/")
    (setq list
          (delete-if (function (lambda (x) (file-directory-p (concat "/media/www/C80GB/home/" x)))) list))
    ;;(setq list (delete-if (function (lambda (x) (string-match "hairy-lemon" x))) list))
    (setq ptr list)
    (message "manaaki-file-copy-from-d")
    (d-quote
     (let ((case-fold-search t))
       (string-match "\\.html$" "FOO.HTML"))
     (let ((case-fold-search t))
       (string-match "\\.HTML$" "foo.html"))
     )
    (while ptr
      ;;(if (file-directory-p (car ptr)) (setcar ptr (concat (car ptr) "/")))
      (setq file-c (concat "/media/www/C80GB/home/" (car ptr)))
      (setq file-f (concat drive-f "home/" (car ptr)))
      (message "Comparing file %s with file %s" file-f file-c)
      (when (and (not (string-match "~$"                                   file-c))
                 (not (string-match "~$"                                   file-f))
                 (not (string-match "^/media/www/C80GB/home/\\.emacs.d"    file-c))
                 (not (string-match "^/media/www/C80GB/home/\\.places.sav" file-c))
                 (not (string-match "^/media/www/C80GB/home/\\.recentf"    file-c))
                 (not (string-match "^/media/www/C80GB/home/\\.eshell"     file-c))
                 (not (string-match "^/media/www/C80GB/home/bak/"          file-c))
                 (not (string-match "^/media/www/C80GB/home/tmp/"          file-c))
                 ;;(not (string-match "^/media/www/C80GB/home/bin/"        file-c))
                 ;;(not (string-match "hairy-lemon"                        file-c))
                 (not (string-match "\\.o$"                                file-c))
                 (not (string-match "/baz/"                                file-c))
                 (not (string-match "\\.class$"                            file-c))
                 (not (string-match "Thumbs\\.db$"                         file-c))
                 (not (string-match "\\.exe$"                              file-c))
                 )
        ;;(if (string-match "/webdesign/inner/" (car ptr)) (debug "Roger Ramjet"))
        (setq size-c (nth 7 (file-attributes file-c)))
        (setq size-f (nth 7 (file-attributes file-f)))
        (cond
         ((and (string-match "\\.html?$" file-c)
               (file-exists-p file-c)
               (file-exists-p file-f)
               size-c
               size-f
               (< size-c (* 200 1000))
               (> size-f (* 200 1000))
               (not (string-match "#.*#" file-c))
               (not (string-match "#.*#" file-f))
               )
          (assert (file-exists-p file-c))
          (make-directory (file-name-directory file-f) 'parents)
          (manaaki-log "Copying file %s -> %s" file-c file-f)
          (copy-file file-c file-f
                     'ok-if-already-exists
                     'keep-time)
          )
         ;; ---------------------------------------------------------
         ((and (not (string-match "#.*#$" file-c))
               (not (string-match "#.*#$" file-f))
               (or (not (file-exists-p file-f))
                   (manaaki-file< file-f file-c)))
          (assert (file-exists-p file-c));; file-f = 1000 file-c = 1200
          (make-directory (file-name-directory file-f) 'parents)
          (assert (file-exists-p file-c))
          (manaaki-log "Copying file %s -> %s" file-c file-f)
          (copy-file file-c file-f
                     'ok-if-already-exists
                     'keep-time)
          )))
      (setq ptr (cdr ptr)))
    (let ((ch (+ ?a (random 4))))
      (play-sound (list 'sound :file (format "/media/www/C80GB/sound-samples/emacs/game-over-%c.wav" ch) :volume 1.0)))
    )
  )

;;; copy to g:/home/dlisp/manaaki-file-copier.el
;;; g:/home/bak/web-20130110-200845.tar.gz
;; (setq ptr '("zzz"))
;; (manaaki-file-copy-from-f)
(defun manaaki-file-copy-from-f ()
  ;;(interactive)
  (let (list ptr file-f file-c size-f size-c file1 file2
             (case-fold-search t))
    (assert (file-exists-p drive-f))
    (save-some-buffers 'NO-QUESTIONS)
    (setq list (directory-files-deep (concat drive-f "home/")))
    (message "Finished directory-files-deep %s:/home/" drive-f)
    (setq list (delete-if (function (lambda (x) (file-directory-p (concat drive-f "home/" x)))) list))
    ;;(setq list (delete-if (function (lambda (x) (string-match "hairy-lemon" x))) list))
    (setq ptr list)
    (message "manaaki-file-copy-from-%s" drive-f)
    (while ptr
      (setq file-f (concat drive-f "home/" (car ptr)))
      (setq file-c (concat "/media/www/C80GB/home/" (car ptr)))
      (message "Comparing file %s with file %s" file-f file-c)
      (when (and (not (string-match "~$"                                   file-c))
                 (not (string-match "~$"                                   file-f))
                 (not (string-match "^/media/www/C80GB/home/\\.emacs.d"    file-c))
                 (not (string-match "^/media/www/C80GB/home/\\.places.sav" file-c))
                 (not (string-match "^/media/www/C80GB/home/\\.recentf"    file-c))
                 (not (string-match "^/media/www/C80GB/home/\\.eshell"     file-c))
                 (not (string-match "^/media/www/C80GB/home/tmp/"          file-c))
                 (not (string-match "^/media/www/C80GB/home/bak/"          file-c))
                 (not (string-match "Davin's Stuff/lisp[+][+]-[0-9]+"      file-c))
                 (not (string-match "Davin's Stuff/r4-[0-9]+"              file-c))
                 ;;(not (string-match "hairy-lemon"                        file-c))
                 (not (string-match "\\.o$"                                file-c))
                 (not (string-match "\\.class$"                            file-c))
                 (not (string-match "Thumbs\\.db$"                         file-c))
                 (not (string-match "\\.exe$"                              file-c))
             )
        ;;(setq size-f (nth 7 (file-attributes "faodfdf")))
        (setq size-f (nth 7 (file-attributes file-f)))
        (setq size-c (nth 7 (file-attributes file-c)))
        (cond
         ((and (string-match "\\.html?$" file-c)
               (file-exists-p file-c)
               (file-exists-p file-f)
               size-c
               size-f
               (> size-c (* 200 1000))
               (< size-f (* 200 1000)))
          ;;(debug 123)
          ;;(message "*** Copying file f:/home/%s -> /media/www/C80GB/home/%s" (car ptr) (car ptr))
          (assert (file-exists-p file-f))
          (make-directory (file-name-directory file-f) 'parents)
          (manaaki-log "Copying file %s -> %s" file-f file-c)
          (copy-file file-f file-c
                     'ok-if-already-exists
                     'keep-time)
          )
         ;; ---------------------------------------------------------
         ((and (or (string-match "\\.dll$" file-c) (string-match "\\.exe$" file-c))
               (or (and size-c size-f (> size-c size-f))
                   (and (not size-c) size-f)))
          (assert (file-exists-p file-f))
          (make-directory (file-name-directory file-c) 'parents)
          (manaaki-log "Copying file %s -> %s" file-f file-c)
          (copy-file file-f file-c
                     'ok-if-already-exists
                     'keep-time)
          )
         ((string-match "\\.html?$" file-c)
          t)
         ((and (or (string-match "\\.exe$" file-f) (string-match "\\.dll$" file-f))
               size-f
               size-c
               (< size-f size-c))
          (assert (file-exists-p file-f))
          (make-directory (file-name-directory file-c) 'parents)
          (manaaki-log "Copying file %s -> %s" file-f file-c)
          (copy-file file-f file-c
                     'ok-if-already-exists
                     'keep-time)
          )
         ((or (string-match "\\.exe$" file-c) (string-match "\\.dll$" file-c))
          t)
         ((or (not (file-exists-p file-c)) (manaaki-file< file-c file-f))
          (assert (file-exists-p file-f)) ;;; file-c = 1000 file-f = 1200
          (make-directory (file-name-directory file-c) 'parents)
          (manaaki-log "Copying file %s -> %s" file-f file-c)
          (copy-file file-f file-c
                     'ok-if-already-exists
                     'keep-time)
          )))
      ;; BUG: deleted f files if file-c doesn't exist
      ;;(when (and (string-match "/bak/" file-c) (not (file-exists-p file-c)))
      ;;  (delete-file file-f))
      (setq ptr (cdr ptr)))
    (play-sound (list 'sound :file "/media/www/C80GB/sound-samples/emacs/gong.wav" :volume 1.0))
    )
  )

;;; written to g:/home/dlisp/manaaki-file-copier.el

(defun manaaki-print-gt-200-000 ()
  (interactive)
  (let ((str "*gt-200-000*"))
    (if (get-buffer str)
        (kill-buffer str))
    (set-buffer (generate-new-buffer str))
    (let (ptr size-c size-f)
      (setq ptr (directory-files-deep "/media/www/C80GB/home/" nil "\\.html?$"))
      (while ptr
        (setq file-c (concat "/media/www/C80GB/home/" (car ptr)))
        (setq file-f (concat drive-f "home/" (car ptr)))
        (when (file-exists-p (concat "/media/www/C80GB/home/" (car ptr)))
          (setq size-c (nth 7 (file-attributes file-c)))
          (setq size-f (nth 7 (file-attributes file-f)))
          (if (and size-c
                   size-f
                   (> size-f (* 200 1000))
                   (< size-c (* 200 1000)))
              (insert (format "%s %d %d\n" (car ptr) size-c size-f))))
        (setq ptr (cdr ptr)))))
  )

;;;
;;; NOTE: drive-f is unset in UNIX mode
;;;
(defun manaaki-file-sync ()
  (interactive)
  (assert (file-exists-p drive-f))
  (setq manaaki-started-time (current-time))
  (setq manaaki-file-name (concat manaaki-file-stump "-" (d-time--get-stamp) ".comp"))
  (manaaki-file-copy-from-f)
  (save-buffer (find-file-noselect manaaki-file-name))
  (manaaki-file-copy-from-c)
  (save-buffer (find-file-noselect manaaki-file-name))
  ;;(bak)
  (let (stopped-time)
    (save-excursion
      (set-buffer (find-file-noselect manaaki-file-name))
      (goto-char (point-max))
      (setq stopped-time (current-time))
      (insert "manaaki-file-sync stopped at " (d-time--get-stamp stopped-time) "\n")
      (insert "Build took " (seconds-to-readable-string
                             (seconds-of-time-difference manaaki-started-time stopped-time)) "\n")
      (save-buffer (find-file-noselect manaaki-file-name))
      ;;(kill-buffer (find-file-noselect manaaki-file-name))
      (switch-to-buffer (find-file-noselect manaaki-file-name))
      )))

(setq drive-f "/media/www/G16GB/")

(require 'bak)
(provide 'manaaki-file-copier)
;;; manaaki-file-copier.el ends here
