/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.util.HashMap;

public class CompareNumericsCondition
extends Condition {
    private static final long serialVersionUID = 5631805710151645907L;
    protected String variablename;
    protected String value;
    protected String operator;

    public CompareNumericsCondition(String string, String string2, HashMap hashMap) {
        this.variablename = string;
        this.value = string2;
        this.operator = "eq";
    }

    public CompareNumericsCondition(String string, String string2) {
        this.variablename = string;
        this.value = string2;
        this.operator = "eq";
    }

    public CompareNumericsCondition() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getVariablename() {
        return this.variablename;
    }

    public void setVariablename(String string) {
        this.variablename = string;
    }

    public void readFromXML(IXMLElement iXMLElement) {
        try {
            this.variablename = iXMLElement.getFirstChildNamed("name").getContent();
            this.value = iXMLElement.getFirstChildNamed("value").getContent();
            this.operator = iXMLElement.getFirstChildNamed("operator").getContent();
        }
        catch (Exception exception) {
            Debug.log("missing element in <condition type=\"variable\"/>");
        }
    }

    public boolean isTrue() {
        String string;
        boolean bl = false;
        if (this.installdata != null && (string = this.installdata.getVariable(this.variablename)) != null) {
            if (this.operator == null) {
                this.operator = "eq";
            }
            try {
                int n = new Integer(string);
                int n2 = new Integer(this.value);
                if ("eq".equalsIgnoreCase(this.operator)) {
                    bl = n == n2;
                } else if ("gt".equalsIgnoreCase(this.operator)) {
                    bl = n > n2;
                } else if ("lt".equalsIgnoreCase(this.operator)) {
                    bl = n < n2;
                } else if ("leq".equalsIgnoreCase(this.operator)) {
                    bl = n <= n2;
                } else if ("geq".equalsIgnoreCase(this.operator)) {
                    bl = n >= n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Debug.log("The value of the associated variable is not a numeric value or the value which should be compared is not a number.");
            }
        }
        return bl;
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on a value of <b>");
        stringBuffer.append(this.value);
        stringBuffer.append("</b> on variable <b>");
        stringBuffer.append(this.variablename);
        stringBuffer.append(" (current value: ");
        stringBuffer.append(this.installdata.getVariable(this.variablename));
        stringBuffer.append(")");
        stringBuffer.append("This value has to be " + this.operator);
        stringBuffer.append("</b><br/>");
        return stringBuffer.toString();
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        XMLElementImpl xMLElementImpl = new XMLElementImpl("name", iXMLElement);
        xMLElementImpl.setContent(this.variablename);
        iXMLElement.addChild(xMLElementImpl);
        XMLElementImpl xMLElementImpl2 = new XMLElementImpl("value", iXMLElement);
        xMLElementImpl2.setContent(this.value);
        iXMLElement.addChild(xMLElementImpl2);
        XMLElementImpl xMLElementImpl3 = new XMLElementImpl("op", iXMLElement);
        xMLElementImpl3.setContent(this.operator);
        iXMLElement.addChild(xMLElementImpl3);
    }
}

