/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import com.google.common.base.Strings;
import org.gnunet.identity.Identity;
import org.gnunet.identity.IdentityCallback;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Configuration;
import org.gnunet.util.Program;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.getopt.Argument;
import org.gnunet.util.getopt.ArgumentAction;
import org.gnunet.voting.GroupCert;

public class CertifyGroupTool
extends Program {
    @Argument(shortname="e", longname="ego", action=ArgumentAction.STORE_STRING, argumentName="EGONAME", description="name of the identity ego to use for signing")
    public String egoName = null;
    @Argument(shortname="m", longname="member", action=ArgumentAction.STORE_STRING, argumentName="KEY", description="key to certify membership for")
    String memberPubKeyString;
    @Argument(shortname="g", longname="group", action=ArgumentAction.STORE_STRING, argumentName="NAME", description="group to certify membership of key for")
    String groupName;
    @Argument(shortname="x", longname="expire", action=ArgumentAction.STORE_STRING, argumentName="DATE", description="expiration date, in local time")
    String expirationDate;

    @Override
    protected String makeHelpText() {
        return "gnunet-ballot-group-certify [OPTIONS]...\nCreate a certificate attesting group membership for a given key.\nThe resulting certificate file written to standard output.";
    }

    public static void main(String[] args) {
        CertifyGroupTool tool = new CertifyGroupTool();
        int ret = tool.start(args);
        System.exit(ret);
    }

    private void certify(Identity.Ego ego, EcdsaPublicKey memberPubKey, AbsoluteTime expiration) {
        GroupCert groupCert = GroupCert.create(memberPubKey, this.groupName, ego.getPrivateKey(), ego.getPublicKey(), expiration);
        Configuration cfg = new Configuration();
        groupCert.writeGroupCertConfig(cfg);
        System.out.println(cfg.serialize());
    }

    @Override
    protected void run() {
        AbsoluteTime expiration;
        if (Strings.isNullOrEmpty((String)this.egoName)) {
            System.err.println("no ego name given");
            this.setReturnValue(1);
            return;
        }
        if (null == this.memberPubKeyString) {
            System.err.println("no member pubkey given");
            this.setReturnValue(1);
            return;
        }
        if (Strings.isNullOrEmpty((String)this.groupName)) {
            System.err.println("no group identifier given");
            this.setReturnValue(1);
            return;
        }
        final EcdsaPublicKey memberPubKey = EcdsaPublicKey.fromString(this.memberPubKeyString);
        if (null == memberPubKey) {
            System.err.println("not a valid pubkey: '" + this.memberPubKeyString + "'");
            this.setReturnValue(1);
            return;
        }
        if (null == this.expirationDate) {
            expiration = AbsoluteTime.FOREVER;
        } else {
            expiration = AbsoluteTime.fromString(this.expirationDate);
            if (null == expiration) {
                System.err.println("invalid expiration date");
                this.setReturnValue(1);
                return;
            }
        }
        Identity.lookup(this.getConfiguration(), this.egoName, new IdentityCallback(){

            @Override
            public void onEgo(Identity.Ego ego) {
                CertifyGroupTool.this.certify(ego, memberPubKey, expiration);
            }

            @Override
            public void onError(String errorMessage) {
                System.err.println("can't retrieve ego: " + errorMessage);
                CertifyGroupTool.this.setReturnValue(2);
            }
        });
    }
}

