/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedList;
import java.util.List;
import org.gnunet.construct.Construct;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Continuation;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MessageReceiver;
import org.gnunet.util.MessageStreamTokenizer;
import org.gnunet.util.MessageTransmitter;
import org.gnunet.util.MstCalllback;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.Resolver;
import org.gnunet.util.Scheduler;
import org.gnunet.util.UnknownMessageBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private SocketChannel connectionChannel = null;
    private List<AddressProbe> addressProbes = null;
    private Cancelable resolveHandle = null;
    private Cancelable connectHandle = null;
    private Scheduler.TaskIdentifier receiveTaskId;
    private MessageReceiver currentReceiver;
    private AbsoluteTime receiveDeadline;
    private TransmitHelper currentTransmitHelper = null;
    private TransmitHelper nextTransmitHelper = null;
    private boolean processedMessage;
    private ByteBuffer transmitBuffer = ByteBuffer.allocate(4);
    private boolean disconnected = false;
    private Scheduler.TaskIdentifier notifyConnectedTimeout;
    private Continuation notifyConnectedContinuation;
    private MessageStreamTokenizer mst = new MessageStreamTokenizer(new ConnectionMstCallback());

    public Connection(String hostname, int port) {
        this.addressProbes = new LinkedList<AddressProbe>();
        ConnectionResolveHandler addressHandler = new ConnectionResolveHandler(port);
        this.resolveHandle = Resolver.getInstance().resolveHostname(hostname, RelativeTime.FOREVER, addressHandler);
    }

    public Connection(SocketChannel sock) {
        assert (sock != null);
        this.connectionChannel = sock;
    }

    private void finishConnect(AddressProbe probe) {
        boolean connected;
        if (this.connectionChannel != null) {
            try {
                probe.channel.close();
            }
            catch (IOException e) {
                logger.error("could not close channel", (Throwable)e);
            }
            return;
        }
        SocketChannel channel = probe.channel;
        try {
            connected = channel.finishConnect();
        }
        catch (IOException e) {
            logger.debug("finishConnect() was not successful: {}", (Object)e);
            return;
        }
        if (!connected) {
            logger.error("socket reported OP_CONNECT but is not connected");
            return;
        }
        for (AddressProbe addressProbe : this.addressProbes) {
            if (addressProbe == probe || addressProbe.connectTask == null) continue;
            addressProbe.connectTask.cancel();
            try {
                addressProbe.channel.close();
            }
            catch (IOException e) {
                logger.error("could not close channel", (Throwable)e);
            }
        }
        this.addressProbes.clear();
        this.connectionChannel = channel;
        if (this.currentTransmitHelper != null) {
            this.currentTransmitHelper.start();
        }
        Continuation c = this.notifyConnectedContinuation;
        this.notifyConnectedContinuation = null;
        if (this.notifyConnectedTimeout != null) {
            this.notifyConnectedTimeout.cancel();
            this.notifyConnectedTimeout = null;
        }
        if (c != null) {
            c.cont(true);
        }
    }

    private SocketChannel createChannel() {
        try {
            SocketChannel channel = SelectorProvider.provider().openSocketChannel();
            channel.configureBlocking(false);
            return channel;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public boolean isConnected() {
        return this.connectionChannel != null && this.connectionChannel.isConnected();
    }

    public void receive(final RelativeTime timeout, MessageReceiver receiver) {
        if (this.receiveTaskId != null) {
            throw new AssertionError((Object)"already receiving");
        }
        if (!this.isConnected()) {
            throw new AssertionError((Object)"cannot receive if not connected");
        }
        this.currentReceiver = receiver;
        this.receiveDeadline = timeout.toAbsolute();
        Scheduler.add(new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
                Connection.this.processedMessage = false;
                if (Connection.this.mst.extractOne()) {
                    logger.debug("full message was in buffer, not reading from socket");
                    if (!Connection.this.processedMessage) {
                        throw new AssertionError();
                    }
                    return;
                }
                if (Connection.this.connectionChannel == null) {
                    return;
                }
                ReceiveTask task = new ReceiveTask();
                Connection.this.receiveTaskId = Scheduler.addRead(timeout, Connection.this.connectionChannel, task);
            }
        });
    }

    public TransmitHandle notifyTransmitReady(int size, RelativeTime timeout, MessageTransmitter transmitter) {
        if (this.disconnected) {
            throw new AssertionError((Object)"notifyTransmitReady called on a closed connection");
        }
        if (this.nextTransmitHelper != null) {
            throw new AssertionError((Object)"previous transmit getRequestIdentifier must have completed before calling notifyTransmitReady again");
        }
        if (timeout.getMicroseconds() <= 0L) {
            throw new AssertionError((Object)"notifyTransmitReady timeout must be positive");
        }
        if (!this.isConnected()) {
            throw new AssertionError((Object)"notifyTransmitHandle can only be called once connected");
        }
        final TransmitHelper transmit = new TransmitHelper(transmitter, timeout);
        if (this.currentTransmitHelper == null) {
            this.currentTransmitHelper = transmit;
            this.currentTransmitHelper.start();
            return null;
        }
        this.nextTransmitHelper = transmit;
        return new TransmitHandle(){

            @Override
            public void cancel() {
                transmit.cancel();
            }
        };
    }

    Cancelable notifyConnected(RelativeTime timeout, Continuation cont) {
        if (this.notifyConnectedTimeout != null) {
            throw new AssertionError();
        }
        this.notifyConnectedContinuation = cont;
        this.notifyConnectedTimeout = Scheduler.addDelayed(timeout, new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
                Continuation c = Connection.this.notifyConnectedContinuation;
                Connection.this.notifyConnectedContinuation = null;
                Connection.this.notifyConnectedTimeout = null;
                if (c != null) {
                    c.cont(false);
                }
            }
        });
        return this.notifyConnectedTimeout;
    }

    public void disconnect() {
        if (this.disconnected) {
            logger.error("disconnect called twice");
        }
        this.disconnected = true;
        if (this.notifyConnectedTimeout != null) {
            this.notifyConnectedTimeout.cancel();
            this.notifyConnectedTimeout = null;
        }
        if (this.receiveTaskId != null) {
            this.receiveTaskId.cancel();
            this.receiveTaskId = null;
        }
        if (this.currentTransmitHelper != null) {
            this.currentTransmitHelper.cancel();
            this.currentTransmitHelper = null;
        }
        if (this.nextTransmitHelper != null) {
            this.nextTransmitHelper.cancel();
            this.nextTransmitHelper = null;
        }
        if (this.resolveHandle != null) {
            this.resolveHandle.cancel();
            this.resolveHandle = null;
        }
        if (this.connectHandle != null) {
            this.connectHandle.cancel();
            this.connectHandle = null;
        }
        if (this.connectionChannel != null) {
            try {
                this.connectionChannel.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            this.connectionChannel = null;
        }
        if (this.addressProbes != null) {
            for (AddressProbe ap : this.addressProbes) {
                ap.cancel();
            }
        }
    }

    class ConnectionResolveHandler
    implements Resolver.AddressCallback {
        private final int port;

        public ConnectionResolveHandler(int port) {
            this.port = port;
        }

        @Override
        public void onAddress(InetAddress addr) {
            SocketChannel channel = Connection.this.createChannel();
            try {
                channel.connect(new InetSocketAddress(addr, this.port));
            }
            catch (IOException e) {
                logger.error("could not connect to host");
                return;
            }
            final AddressProbe addressProbe = new AddressProbe();
            addressProbe.channel = channel;
            Scheduler.TaskConfiguration tc = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, new Scheduler.Task(){

                @Override
                public void run(Scheduler.RunContext ctx) {
                    addressProbe.connectTask = null;
                    if (ctx.reasons.contains((Object)Scheduler.Reason.SHUTDOWN)) {
                        return;
                    }
                    Connection.this.finishConnect(addressProbe);
                }
            });
            if (!channel.isOpen()) {
                return;
            }
            tc.addSelectEvent(channel, 8);
            addressProbe.connectTask = tc.schedule();
        }

        @Override
        public void onFinished() {
            Connection.this.resolveHandle = null;
        }

        @Override
        public void onTimeout() {
        }
    }

    private class ConnectionMstCallback
    implements MstCalllback {
        private ConnectionMstCallback() {
        }

        private void dispatch(GnunetMessage.Body mb) {
            if (Connection.this.processedMessage) {
                throw new AssertionError();
            }
            if (null == Connection.this.currentReceiver) {
                throw new AssertionError();
            }
            Connection.this.currentReceiver.process(mb);
            Connection.this.processedMessage = true;
        }

        @Override
        public void onUnknownMessage(UnknownMessageBody b) {
            this.dispatch(b);
        }

        @Override
        public void onKnownMessage(GnunetMessage msg) {
            this.dispatch(msg.body);
        }
    }

    private class TransmitHelper
    implements Scheduler.Task,
    MessageSink {
        private final MessageTransmitter transmitter;
        private Cancelable notifyTimeoutTask;
        private Cancelable transmitTask = null;

        public TransmitHelper(final MessageTransmitter transmitter, RelativeTime notifyTimeout) {
            this.transmitter = transmitter;
            Scheduler.TaskConfiguration tc = new Scheduler.TaskConfiguration(notifyTimeout, new Scheduler.Task(){

                @Override
                public void run(Scheduler.RunContext ctx) {
                    transmitter.handleError();
                }
            });
            this.notifyTimeoutTask = tc.schedule();
        }

        public void cancel() {
            if (this.transmitTask != null) {
                this.transmitTask.cancel();
                this.transmitTask = null;
            }
            if (this.notifyTimeoutTask != null) {
                this.notifyTimeoutTask.cancel();
                this.notifyTimeoutTask = null;
            }
        }

        @Override
        public void run(Scheduler.RunContext ctx) {
            this.transmitTask = null;
            if (Connection.this.connectionChannel == null) {
                logger.error("could not write to channel (null)");
                return;
            }
            try {
                int n = Connection.this.connectionChannel.write(Connection.this.transmitBuffer);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            if (Connection.this.transmitBuffer.remaining() == 0) {
                logger.debug("transmit buffer fully sent");
                if (Connection.this.nextTransmitHelper == null) {
                    Connection.this.currentTransmitHelper = null;
                } else {
                    Connection.this.currentTransmitHelper = Connection.this.nextTransmitHelper;
                    TransmitHelper tmpTransmitHelper = Connection.this.nextTransmitHelper;
                    Connection.this.nextTransmitHelper = null;
                    tmpTransmitHelper.start();
                }
            } else {
                this.schedule();
            }
        }

        public void start() {
            this.notifyTimeoutTask.cancel();
            this.notifyTimeoutTask = null;
            Connection.this.transmitBuffer.clear();
            this.transmitter.transmit(this);
            Connection.this.transmitBuffer.flip();
            this.schedule();
        }

        private void schedule() {
            if (Connection.this.disconnected) {
                return;
            }
            Scheduler.TaskConfiguration tc = new Scheduler.TaskConfiguration(RelativeTime.FOREVER, this);
            tc.addSelectEvent(Connection.this.connectionChannel, 4);
            this.transmitTask = tc.schedule();
        }

        @Override
        public void send(GnunetMessage.Body m) {
            GnunetMessage gm = new GnunetMessage();
            gm.header = new GnunetMessage.Header();
            gm.body = m;
            Construct.patch(gm);
            gm.header.messageSize = Construct.getSize(gm);
            byte[] b = Construct.toBinary(gm);
            if (b.length != gm.header.messageSize) {
                throw new AssertionError((Object)String.format("tried to send message with binary size %s but size in header %s", b.length, gm.header.messageSize));
            }
            logger.debug("sending message (size={},type={}) over {}", (Object[])new String[]{String.valueOf(b.length), String.valueOf(gm.header.messageType), Connection.this.connectionChannel.socket().toString()});
            if (Connection.this.transmitBuffer.remaining() < b.length) {
                ByteBuffer buf = ByteBuffer.allocate(b.length + Connection.this.transmitBuffer.capacity());
                Connection.this.transmitBuffer.flip();
                buf.put(Connection.this.transmitBuffer);
                Connection.this.transmitBuffer = buf;
            }
            Connection.this.transmitBuffer.put(b);
        }
    }

    private class ReceiveTask
    implements Scheduler.Task {
        public boolean done;

        private ReceiveTask() {
        }

        private void error() {
            Connection.this.currentReceiver.handleError();
            this.done = true;
        }

        @Override
        public void run(Scheduler.RunContext ctx) {
            if (Connection.this.currentReceiver == null) {
                throw new AssertionError();
            }
            Connection.this.receiveTaskId = null;
            if (ctx.reasons.contains((Object)Scheduler.Reason.TIMEOUT)) {
                this.error();
            } else if (ctx.reasons.contains((Object)Scheduler.Reason.READ_READY)) {
                logger.debug("ready to receive");
                try {
                    Connection.this.processedMessage = false;
                    logger.debug("reading into mst ...");
                    int n = Connection.this.mst.readFrom(Connection.this.connectionChannel, true);
                    logger.debug("read {} bytes into mst", (Object)n);
                    if (Connection.this.processedMessage) {
                        this.done = true;
                        return;
                    }
                    if (-1 == n) {
                        this.error();
                        return;
                    }
                }
                catch (IOException e) {
                    logger.debug("got IOException ({}, {})", (Object)e.getClass().getName(), (Object)e.getMessage());
                    this.error();
                    return;
                }
                if (Connection.this.receiveDeadline.isDue()) {
                    this.error();
                    return;
                }
                Connection.this.receiveTaskId = Scheduler.addRead(Connection.this.receiveDeadline.getRemaining(), Connection.this.connectionChannel, this);
            } else if (ctx.reasons.contains((Object)Scheduler.Reason.SHUTDOWN)) {
                this.done = true;
            } else {
                throw new RuntimeException("receive failed");
            }
        }
    }

    public static interface MessageSink {
        public void send(GnunetMessage.Body var1);
    }

    public static interface TransmitHandle
    extends Cancelable {
        @Override
        public void cancel();
    }

    private static class AddressProbe {
        Cancelable connectTask;
        SocketChannel channel;

        private AddressProbe() {
        }

        public void cancel() {
            if (this.connectTask != null) {
                this.connectTask.cancel();
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

