/**
 * Copyright (C) 1999, 2000, 2001  Free Software Foundation, Inc.
 *
 * This file is part of GNU gengetopt 
 *
 * GNU gengetopt is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2, or (at your option) 
 * any later version. 
 *
 * GNU gengetopt is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License along 
 * with gengetopt; see the file COPYING. If not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */


%{
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "argsdef.h"

#include "gengetopt.h"

extern int gengetopt_count_line;
extern char * gengetopt_input_filename;

static int gengetopt_package_given = 0;
static int gengetopt_version_given = 0;
static int gengetopt_purpose_given = 0;

extern void yyerror ( const char *error ) ;
extern void yyerror2 ( const char *error ) ;
extern int yylex () ;

//#define YYERROR_VERBOSE 1

#define check_result					\
    if (o) {						\
	switch (o) {					\
	    case 1: yyerror2 ("not enough memory");	\
		break;					\
	    case 2: yyerror2 ("long option redefined");	\
		break;					\
	    case 3: yyerror2 ("short option redefined");	\
		break;					\
	    case 4: yyerror2 ("bug found!!");		\
		break;					\
	    case 5: yyerror2 ("group undefined");	\
		break;					\
	    case 6: yyerror2 ("invalid default value");	\
		break;					\
	} YYERROR;					\
    }
%}

%union {
    char   *str;
    char    chr;
    int	    argtype;
    int	    boolean;
}

%token		    TOK_PACKAGE		"package"
%token              TOK_VERSION		"version"
%token              TOK_OPTION		"option"
%token              TOK_DEFGROUP	"defgroup"
%token              TOK_GROUPOPTION	"groupoption"
%token              TOK_YES		"yes"
%token              TOK_NO		"no"
%token              TOK_ON		"on"
%token              TOK_OFF		"off"
%token              TOK_FLAG		"flag"
%token              TOK_PURPOSE		"purpose"
%token              TOK_DEFAULT		"default"
%token              TOK_GROUP		"group"
%token              TOK_GROUPDESC	"groupdesc"
%token              TOK_MULTIPLE	"multiple"
%token              TOK_ARGOPTIONAL	"argoptional"
%token              TOK_TYPESTR		"typestr"
%token              TOK_SECTION		"section"
%token              TOK_SECTIONDESC	"sectiondesc"
%token <str>        TOK_STRING
%token <str>        TOK_MLSTRING
%token <chr>        TOK_CHAR
%token <argtype>    TOK_ARGTYPE

%type  <boolean>    req_onoff
%type  <boolean>    opt_yesno
%type  <boolean>    opt_multiple
%type  <boolean>    opt_argoptional
%type  <argtype>    opt_argtype
%type  <str>        quoted_string
%type  <str>        opt_group
%type  <str>        opt_default
%type  <str>        opt_typestr
%type  <str>        opt_groupdesc
%type  <str>        opt_sectiondesc


%% /* ====================================================================== */


input
	: /* empty */
	| statement input
	;


statement
	: package
	| version
	| purpose
        | sectiondef
	| option
	| groupoption
	| groupdef
	;


package
	: TOK_PACKAGE TOK_STRING
	    {
	      if (gengetopt_package_given)
		{
		  yyerror ("package redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_package_given = 1;
		  if (gengetopt_define_package ($2))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
	;

version
	: TOK_VERSION TOK_STRING
	    {
	      if (gengetopt_version_given)
		{
		  yyerror ("version redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_version_given = 1;
		  if (gengetopt_define_version ($2))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
	;

purpose
	: TOK_PURPOSE quoted_string
	    {
	      if (gengetopt_purpose_given)
		{
		  yyerror ("purpose redefined");
		  YYERROR;
		}
	      else
		{
		  gengetopt_purpose_given = 1;
		  if (gengetopt_define_purpose ($2))
		    {
		      yyerror ("not enough memory");
		      YYERROR;
		    }
		}
	    }
	;

sectiondef
          : TOK_SECTION TOK_STRING opt_sectiondesc
              {
                gengetopt_set_section ($2, $3);
              }
          ;

groupdef
	: TOK_DEFGROUP TOK_STRING opt_groupdesc opt_yesno
	    {
	      if (gengetopt_add_group ($2, $3, $4))
		{
		  yyerror ("group redefined");
		  YYERROR;
		}
	    }
	;

option
	: TOK_OPTION TOK_STRING TOK_CHAR quoted_string TOK_FLAG req_onoff
	    {
	      int o = gengetopt_add_option ($2, $3, $4, ARG_FLAG, $6, 0, 0, 0, 0, 0);
	      check_result;
	    }
	| TOK_OPTION TOK_STRING TOK_CHAR quoted_string
		opt_argtype opt_typestr opt_default opt_yesno opt_argoptional opt_multiple
	    {
	      int o = gengetopt_add_option ($2, $3, $4, $5, 0, $8, $7, 0, $6, $10, $9);
	      check_result;
	    }
	;

groupoption
	: TOK_GROUPOPTION TOK_STRING TOK_CHAR quoted_string
		opt_argtype opt_typestr opt_default opt_group
	    {
	      int o = gengetopt_add_option ($2, $3, $4, $5, 0, 0, $7, $8, $6, 0);
	      check_result;
	    }
	;


/* ---------------------------------------------------------------------- */

quoted_string
	: TOK_MLSTRING
	| TOK_STRING
	;

req_onoff
	: TOK_ON	{ $$ = 1; }
	| TOK_OFF	{ $$ = 0; }
	;

opt_yesno
	: /* empty */	{ $$ = 0; }
	| TOK_YES	{ $$ = 1; }
	| TOK_NO	{ $$ = 0; }
	;

opt_multiple
	: /* empty */	{ $$ = 0; }
	| TOK_MULTIPLE	{ $$ = 1; }
	;

opt_argoptional
	: /* empty */	{ $$ = 0; }
	| TOK_ARGOPTIONAL	{ $$ = 1; }
	;

opt_argtype
	: /* empty */	{ $$ = ARG_NO; }
	| TOK_ARGTYPE	{ $$ = $1; }
	;

opt_default
	: /* empty */			{ $$ = 0; }
        | TOK_DEFAULT '=' TOK_STRING	{ $$ = $3; }
	;

opt_group
	: /* empty */			{ $$ = 0; }
        | TOK_GROUP '=' TOK_STRING	{ $$ = $3; }
	;

opt_groupdesc
	: /* empty */			{ $$ = 0; }
        | TOK_GROUPDESC '=' TOK_STRING	{ $$ = $3; }
	;

opt_sectiondesc
        : /* empty */			{ $$ = 0; }
        | TOK_SECTIONDESC '=' TOK_STRING	{ $$ = $3; }
        ;

opt_typestr
	: /* empty */			{ $$ = 0; }
        | TOK_TYPESTR '=' TOK_STRING	{ $$ = $3; }
	;

%%
