/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.metrics.boundingbox;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.util.concurrent.patterns.PReduceJob;
import com.sun.electric.tool.util.concurrent.utils.BlockedRange1D;
import java.awt.geom.Point2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBMetricTask
extends PReduceJob.PReduceTask<Double, BlockedRange1D> {
    List<PlacementFrame.PlacementNode> nodesToPlace;
    List<PlacementFrame.PlacementNetwork> allNetworks;
    private Double sum = 0.0;

    public BBMetricTask(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
    }

    private double compute(PlacementFrame.PlacementNetwork net) {
        List<PlacementFrame.PlacementPort> portsOnNet = net.getPortsOnNet();
        double leftmost = Double.MAX_VALUE;
        double rightmost = -1.7976931348623157E308;
        double uppermost = -1.7976931348623157E308;
        double undermost = Double.MAX_VALUE;
        for (PlacementFrame.PlacementPort port : portsOnNet) {
            Point2D.Double position = this.getPortPosition(port);
            if (position.getX() < leftmost) {
                leftmost = position.getX();
            }
            if (position.getX() > rightmost) {
                rightmost = position.getX();
            }
            if (position.getY() > uppermost) {
                uppermost = position.getY();
            }
            if (!(position.getY() < undermost)) continue;
            undermost = position.getY();
        }
        return rightmost - leftmost + (uppermost - undermost);
    }

    private Point2D.Double getPortPosition(PlacementFrame.PlacementPort port) {
        double x = port.getRotatedOffX() + port.getPlacementNode().getPlacementX();
        double y = port.getRotatedOffY() + port.getPlacementNode().getPlacementY();
        return new Point2D.Double(x, y);
    }

    @Override
    public synchronized Double reduce(PReduceJob.PReduceTask<Double, BlockedRange1D> other) {
        BBMetricTask bbOther = (BBMetricTask)other;
        if (!this.equals(other)) {
            BBMetricTask bBMetricTask = this;
            bBMetricTask.sum = bBMetricTask.sum + bbOther.sum;
        }
        return this.sum;
    }

    @Override
    public void execute() {
        for (int i = ((BlockedRange1D)this.range).start(); i < ((BlockedRange1D)this.range).end(); ++i) {
            this.sum = this.sum + this.compute(this.allNetworks.get(i));
        }
    }
}

