/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.GenePlacement;
import com.sun.electric.tool.placement.genetic1.g1.PlacementNodeProxy;
import java.util.ArrayList;
import java.util.Arrays;

public class GenePlacementLeftRightAlignedDrop
implements GenePlacement {
    private static int placementWidth = -1;
    int[] genePosition2Index;
    Direction direction;
    int[][] currentLine;
    int[][] previousLine;
    int[][] swapLine;
    PlacementNodeProxy[] nodeProxies;

    public GenePlacementLeftRightAlignedDrop(int placementWidth, int chromosomeSize, PlacementNodeProxy[] nodeProxies) {
        this.nodeProxies = nodeProxies;
        GenePlacementLeftRightAlignedDrop.placementWidth = placementWidth;
        assert (placementWidth != -1);
        this.setChromosomeSize(chromosomeSize);
    }

    private void setChromosomeSize(int chromosomeSize) {
        int assumedLineLength = (int)(Math.sqrt(chromosomeSize) * 1.1);
        this.currentLine = new int[assumedLineLength][];
        this.previousLine = new int[assumedLineLength][];
        for (int i = 0; i < assumedLineLength; ++i) {
            this.currentLine[i] = new int[2];
            this.previousLine[i] = new int[2];
        }
        assert (this.isLineZero(this.currentLine));
        assert (this.isLineZero(this.previousLine));
        this.genePosition2Index = new int[chromosomeSize];
    }

    public void placeChromosome(Chromosome chToPlace) {
        int i;
        assert (chToPlace != null);
        assert (this.currentLine != null && this.previousLine != null) : "set chromsome size before first usage";
        assert (placementWidth != -1) : "set placement width before first usage";
        assert (chToPlace.isIndex2GenePosValid());
        assert (this.isLineZero(this.previousLine));
        this.direction = Direction.LEFT2RIGHT;
        int tempGenXPosition = 0;
        int tempGenYPosition = 0;
        int offX = 0;
        int positionInCurrentLine = 0;
        int startPosition2SearchInPreviousLine = 0;
        GenePlacementLeftRightAlignedDrop.generateGenePos2IndexMapping(chToPlace.Index2GenePositionInChromosome, this.genePosition2Index);
        for (i = 0; i < this.genePosition2Index.length; ++i) {
            int nodeIndex = this.genePosition2Index[i];
            int tWidth = this.nodeProxies[nodeIndex].width + chToPlace.GeneXPadding[nodeIndex];
            int tHeight = this.nodeProxies[nodeIndex].height + chToPlace.GeneYPadding[nodeIndex];
            if (chToPlace.GeneRotation[nodeIndex] == 900 || chToPlace.GeneRotation[nodeIndex] == 2700) {
                int swap = tHeight;
                tHeight = tWidth;
                tWidth = swap;
            }
            tHeight >>= 1;
            tempGenXPosition = this.direction == Direction.LEFT2RIGHT ? offX + tWidth : offX - (tWidth >>= 1);
            if (this.direction == Direction.LEFT2RIGHT && tempGenXPosition + tWidth > placementWidth) {
                this.swapLine = this.currentLine;
                this.currentLine = this.previousLine;
                this.previousLine = this.swapLine;
                assert (this.isLineInXOrder(this.previousLine, positionInCurrentLine - 1, this.direction));
                startPosition2SearchInPreviousLine = positionInCurrentLine;
                positionInCurrentLine = 0;
                this.direction = Direction.RIGHT2LEFT;
                offX = placementWidth;
                tempGenXPosition = placementWidth - tWidth;
            } else if (this.direction == Direction.RIGHT2LEFT && tempGenXPosition - tWidth < 0) {
                this.swapLine = this.currentLine;
                this.currentLine = this.previousLine;
                this.previousLine = this.swapLine;
                assert (this.isLineInXOrder(this.previousLine, positionInCurrentLine - 1, this.direction));
                startPosition2SearchInPreviousLine = positionInCurrentLine;
                positionInCurrentLine = 0;
                this.direction = Direction.LEFT2RIGHT;
                offX = 0;
                tempGenXPosition = tWidth;
            }
            int[] yCalculationResult = this.direction == Direction.LEFT2RIGHT ? this.calculateY(offX, offX + tWidth, tHeight, startPosition2SearchInPreviousLine, this.direction) : this.calculateY(offX, offX - (tWidth <<= 1), tHeight, startPosition2SearchInPreviousLine, this.direction);
            tempGenYPosition = yCalculationResult[1];
            startPosition2SearchInPreviousLine = yCalculationResult[0];
            if (this.direction == Direction.LEFT2RIGHT) {
                this.storeYValue(positionInCurrentLine, tempGenYPosition + tHeight, offX, offX + tWidth);
            } else {
                this.storeYValue(positionInCurrentLine, tempGenYPosition + tHeight, offX, offX - tWidth);
            }
            chToPlace.GeneXPos[nodeIndex] = tempGenXPosition;
            chToPlace.GeneYPos[nodeIndex] = tempGenYPosition;
            offX = this.direction == Direction.LEFT2RIGHT ? (offX += tWidth) : (offX -= tWidth);
            ++positionInCurrentLine;
        }
        for (i = 0; i < this.previousLine.length; ++i) {
            this.previousLine[i][0] = 0;
            this.previousLine[i][1] = 0;
        }
    }

    public static void generateGenePos2IndexMapping(int[] index2GenePositionInChromosome, int[] returnValueGenerateGenePos2IndexMapping) {
        assert (index2GenePositionInChromosome.length == returnValueGenerateGenePos2IndexMapping.length);
        for (int index2 = 0; index2 < index2GenePositionInChromosome.length; ++index2) {
            returnValueGenerateGenePos2IndexMapping[index2GenePositionInChromosome[index2]] = index2;
        }
    }

    private boolean isLineInXOrder(int[][] previousLine, int linePosition, Direction direction) {
        if (direction == Direction.LEFT2RIGHT) {
            for (int i = 0; i < linePosition; ++i) {
                assert (previousLine[i][0] <= placementWidth && previousLine[i][0] >= 0);
                if (previousLine[i][0] < previousLine[i + 1][0]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < linePosition; ++i) {
                assert (previousLine[i][0] <= placementWidth && previousLine[i][0] >= 0);
                if (previousLine[i][0] > previousLine[i + 1][0]) continue;
                return false;
            }
        }
        return true;
    }

    private int[] calculateY(int startX, int endX, int halfCellHeigth, int startPosition2SearchInPreviousLine, Direction direction) {
        int yValue = 0;
        int newSearchStartPosition = -1;
        int valueBeforeInterval = this.previousLine[startPosition2SearchInPreviousLine][1];
        int valueAfterInterval = this.previousLine[0][1];
        boolean valueInRange = false;
        for (int pos = startPosition2SearchInPreviousLine; pos >= 0; --pos) {
            int curY = this.previousLine[pos][1];
            int curX = this.previousLine[pos][0];
            if (!valueInRange) {
                valueAfterInterval = valueBeforeInterval = curY;
                newSearchStartPosition = pos;
            }
            if (direction == Direction.LEFT2RIGHT && curX > endX || direction == Direction.RIGHT2LEFT && curX < endX) {
                valueAfterInterval = curY;
                break;
            }
            if (direction == Direction.LEFT2RIGHT) {
                if (curX <= startX) continue;
                valueInRange = true;
                newSearchStartPosition = pos;
                if (curY <= yValue) continue;
                yValue = curY;
                continue;
            }
            if (curX >= startX) continue;
            valueInRange = true;
            newSearchStartPosition = pos;
            if (curY <= yValue) continue;
            yValue = curY;
        }
        assert (valueAfterInterval >= 0);
        if (!valueInRange) {
            yValue = Math.min(valueBeforeInterval, valueAfterInterval);
        }
        return new int[]{newSearchStartPosition, yValue += halfCellHeigth};
    }

    private boolean isLineZero(int[][] line) {
        for (int[] p : line) {
            if (p[0] == 0 && p[1] == 0) continue;
            return false;
        }
        return true;
    }

    private void storeYValue(int positionInLine, int topyValue, int startX, int endX) {
        if (this.currentLine.length <= positionInLine + 1) {
            ArrayList<Object> expansionHelper = new ArrayList<Object>(this.currentLine.length + 5);
            expansionHelper.addAll(Arrays.asList(this.currentLine));
            for (int i = 0; i < 5; ++i) {
                expansionHelper.add(new int[2]);
            }
            this.currentLine = (int[][])expansionHelper.toArray((T[])new int[expansionHelper.size()][]);
        }
        if (positionInLine == 0) {
            this.currentLine[positionInLine][0] = startX;
            this.currentLine[positionInLine][1] = topyValue;
        } else if (this.currentLine[positionInLine][1] < topyValue) {
            this.currentLine[positionInLine][1] = topyValue;
        }
        assert (this.currentLine[positionInLine][0] == startX);
        this.currentLine[positionInLine + 1][0] = endX;
        this.currentLine[positionInLine + 1][1] = topyValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Direction {
        LEFT2RIGHT,
        RIGHT2LEFT;

    }
}

