/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.OverlapDirection;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.history.OverlapHistorySync;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;

public class OverlapWorker
extends StageWorker {
    private double threshold;
    private int index;

    public OverlapWorker(double threshold, int index) {
        this.threshold = threshold;
        this.index = index;
    }

    private void exchangeAndPlace(CheckboardingField field1, CheckboardingField field2, CheckboardingField[][] fields) {
        OverlapHistorySync history = OverlapHistorySync.getInstance();
        PlacementFrame.PlacementNode node1 = field1.getNode();
        PlacementFrame.PlacementNode node2 = field2.getNode();
        if (field1 != field2 && history.isMovementInHistory(node1, node2)) {
            this.exchangeAndPlace(field1, field1, fields);
            this.exchangeAndPlace(field2, field2, fields);
        } else {
            field2.placeCentralized(node1);
            field1.placeCentralized(node2);
            history.saveHistory(node1, node2);
            PlacementForceDirectedStaged.incMovementCounter();
        }
    }

    private void handleOverlappingInX(CheckboardingField[][] fieldPart, int i, int j) {
        double ovX = fieldPart[i][j].getOverlappingFractionInX();
        double ovY = fieldPart[i][j].getOverlappingFractionInY();
        OverlapDirection dir = fieldPart[i][j].getOverlapDirection();
        if (ovX > this.threshold) {
            int newX;
            CheckboardingField newField = null;
            if (OverlapDirection.isEast(dir)) {
                int newX2 = j + 1;
                if (newX2 < fieldPart[i].length) {
                    newField = fieldPart[i][newX2];
                }
            } else if (OverlapDirection.isWest(dir) && (newX = j - 1) >= 0) {
                newField = fieldPart[i][newX];
            }
            if (newField == null) {
                newField = fieldPart[i][j];
            }
            this.exchangeAndPlace(fieldPart[i][j], newField, fieldPart);
        } else if (ovY > this.threshold) {
            this.handleOverlappingInY(fieldPart, i, j);
        }
    }

    private void handleOverlappingInY(CheckboardingField[][] fieldPart, int i, int j) {
        double ovX = fieldPart[i][j].getOverlappingFractionInX();
        double ovY = fieldPart[i][j].getOverlappingFractionInY();
        OverlapDirection dir = fieldPart[i][j].getOverlapDirection();
        if (ovY > this.threshold) {
            int newY;
            CheckboardingField newField = null;
            if (OverlapDirection.isNorth(dir)) {
                int newY2 = i + 1;
                if (newY2 < fieldPart.length) {
                    newField = fieldPart[newY2][j];
                }
            } else if (OverlapDirection.isSouth(dir) && (newY = j - 1) >= 0) {
                newField = fieldPart[newY][j];
            }
            if (newField == null) {
                newField = fieldPart[i][j];
            }
            this.exchangeAndPlace(fieldPart[i][j], newField, fieldPart);
        } else if (ovX > this.threshold) {
            this.handleOverlappingInX(fieldPart, i, j);
        }
    }

    public void run() {
        while (!this.abort.booleanValue()) {
            try {
                PlacementDTO data = this.stage.getInput(this).get();
                CheckboardingField[][] fieldPart = data.getFieldPart();
                for (int i = 0; i < fieldPart.length; ++i) {
                    for (int j = 0; j < fieldPart[i].length; ++j) {
                        if (fieldPart[i][j] == null || !fieldPart[i][j].isOverlappingBiggerThreshold(this.threshold)) continue;
                        int proc = fieldPart[i][j].getCoordX() + fieldPart[i][j].getCoordY();
                        if (proc % 2 == 0) {
                            this.handleOverlappingInX(fieldPart, i, j);
                            continue;
                        }
                        this.handleOverlappingInY(fieldPart, i, j);
                    }
                }
                this.stage.sendToNextStage(data);
            }
            catch (EmptyException e) {
                Thread.yield();
            }
        }
    }
}

