/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import java.util.Iterator;

public class FlagSet {
    private int mask;
    private int unmask;
    private int shift;
    private Generator generator;

    private FlagSet() {
    }

    public static FlagSet getFlagSet(Generator generator, int numBits) {
        int shift;
        int mask = 0;
        for (int i = 0; i < numBits; ++i) {
            mask |= 1 << i;
        }
        for (shift = 0; shift <= 32 - numBits && (generator.flagBitsUsed & mask << shift) != 0; ++shift) {
        }
        if (shift > 32 - numBits) {
            System.out.println("Error: ran out of flag bits in " + generator.getObjectName());
            return null;
        }
        FlagSet fs = new FlagSet();
        fs.shift = shift;
        fs.mask = mask << shift;
        fs.unmask = ~fs.mask;
        generator.flagBitsUsed |= fs.mask;
        fs.generator = generator;
        return fs;
    }

    public void clearOnAllCells() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                cell.clearBit(this);
            }
        }
    }

    public int getMask() {
        return this.mask;
    }

    public int getUnmask() {
        return this.unmask;
    }

    public int getShift() {
        return this.shift;
    }

    public void freeFlagSet() {
        this.generator.flagBitsUsed &= this.unmask;
    }

    public static class Generator {
        private String objectName;
        private int flagBitsUsed = 0;

        public Generator(String objectName) {
            this.objectName = objectName;
        }

        public String getObjectName() {
            return this.objectName;
        }
    }
}

