/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class StratDebug
extends Strategy {
    private StratDebug(NccGlobals globals) {
        super(globals);
        NccOptions options = globals.getOptions();
        boolean savedVerbose = options.verbose;
        options.verbose = true;
        globals.println("begin StratDebug");
        globals.println("dumping mismatched EquivRecords");
        this.doFor(globals.getRoot());
        globals.println("end StratDebug");
        options.verbose = savedVerbose;
    }

    public LeafList doFor(EquivRecord er) {
        if (er.isLeaf()) {
            if (er.isMismatched() && er.getNetObjType() != NetObject.Type.PORT) {
                this.globals.println(er.nameString());
                List reasons = er.getPartitionReasonsFromRootToMe();
                Iterator it = reasons.iterator();
                while (it.hasNext()) {
                    this.globals.println("   " + it.next());
                }
                super.doFor(er);
            }
        } else {
            super.doFor(er);
        }
        return new LeafList();
    }

    public HashMap doFor(Circuit c) {
        this.globals.println(" " + c.nameString());
        return super.doFor(c);
    }

    public Integer doFor(NetObject n) {
        this.globals.println("  " + n.toString());
        return CODE_NO_CHANGE;
    }

    public static void doYourJob(NccGlobals globals) {
        new StratDebug(globals);
    }
}

