/* path-concat.h -- concatenate two arbitrary pathnames
   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by Jim Meyering.  */
/* Modified by Akim Demaille:
   1. hard coded `/' is now macro DIR_SEP
   2. dir may be NULL
   3. use xmalloc (hence exit (1) when memory exhausted)
   */

#ifndef _PATHCONCAT_H
#define _PATHCONCAT_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

/* Support of prototyping when possible */
#ifndef PARAMS
#  if PROTOTYPES
#    define PARAMS(protos) protos
#  else /* no PROTOTYPES */
#    define PARAMS(protos) ()
#  endif /* no PROTOTYPES */
#endif

char *
path_concat PARAMS ((const char *dir, const char *base,
		     char **base_in_result));

#endif
