/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.text.IDocument;
import org.xmind.core.ITitled;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.FloatingTextEditorHelper;
import org.xmind.ui.tools.MindMapEditToolBase;
import org.xmind.ui.util.MindMapUtils;

public class TitleEditTool
extends MindMapEditToolBase {
    private FloatingTextEditorHelper helper = null;

    protected boolean canEdit(IGraphicalEditPart target) {
        return super.canEdit(target) && !(target instanceof ITopicPart);
    }

    @Override
    protected String getInitialText(IPart source) {
        Object m = MindMapUtils.getRealModel(source);
        if (m instanceof ITitled) {
            return ((ITitled)m).getTitleText();
        }
        return null;
    }

    @Override
    protected Request createTextRequest(IPart source, IDocument document) {
        Request request = this.createTargetedRequest("modify", (IViewer)this.getTargetViewer(), false);
        request.setParameter("text", (Object)document.get());
        return request;
    }

    protected boolean isMultilineAllowed() {
        return true;
    }

    protected boolean isWrapAllowed() {
        return true;
    }

    protected void hookEditor(FloatingTextEditor editor) {
        super.hookEditor(editor);
        if (this.helper == null) {
            this.helper = this.createHelper();
        }
        this.helper.setEditor(editor);
        this.helper.setViewer(this.getTargetViewer());
        this.helper.setFigure(this.getTitleFigure());
        this.helper.activate();
    }

    protected FloatingTextEditorHelper createHelper() {
        return new FloatingTextEditorHelper(true);
    }

    protected FloatingTextEditorHelper getHelper() {
        return this.helper;
    }

    protected void unhookEditor(FloatingTextEditor editor) {
        if (this.helper != null) {
            this.helper.deactivate();
        }
        super.unhookEditor(editor);
    }

    protected IFigure getTitleFigure() {
        ITextFigure t;
        IFigure figure = this.getSource().getFigure();
        if (figure instanceof ITitledFigure && (t = ((ITitledFigure)figure).getTitle()) != null) {
            return t;
        }
        return figure;
    }
}

