/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.XMLUtils;
import org.xml.sax.SAXException;

public class ThemeUICore {
    private static final String GROUP_ID = "id";
    private static final String GROUP_NAME = "name";
    private static final String THEME_ID = "id";
    private static final String THEME_GROUP = "theme-group";
    private static final String THEME_ELEMENT = "theme";
    private static final String DEFAULT_GROUP_ID = "default";
    private static final String USER_GROUP_ID = "user";
    private static final String PATH_STYLES = "styles/";
    private static final String THEME_GROUP_XML = "themeGroups.xml";
    private static final String THEME_PROPERTIES = "themeGroups.properties";
    private static ThemeUICore instance = null;
    private List<ThemeUIGroup> systemGroups = null;
    private Properties properties = null;

    private ThemeUICore() {
    }

    public List<ThemeUIGroup> getThemeGroups() {
        ArrayList<ThemeUIGroup> list = new ArrayList<ThemeUIGroup>();
        ThemeUIGroup defaultGroup = this.getDefaultGroup();
        if (defaultGroup != null && defaultGroup.getItems().length != 0) {
            list.add(defaultGroup);
        }
        list.addAll(this.getSystemGroups());
        ThemeUIGroup userGroup = this.getUserGroup();
        if (userGroup != null && userGroup.getItems().length != 0) {
            list.add(userGroup);
        }
        return list;
    }

    private ThemeUIGroup getUserGroup() {
        IResourceManager rm = MindMapUI.getResourceManager();
        Set userThemeSets = rm.getUserThemeSheet().getStyles("master-styles");
        ThemeUIGroup userGroup = new ThemeUIGroup(USER_GROUP_ID, MindMapMessages.ThemeUICore_group_user_name, userThemeSets.toArray(new IStyle[userThemeSets.size()]));
        return userGroup;
    }

    private List<ThemeUIGroup> getSystemGroups() {
        if (this.systemGroups == null) {
            this.systemGroups = this.createSystemGroups();
        }
        return this.systemGroups;
    }

    private List<ThemeUIGroup> createSystemGroups() {
        IResourceManager rm = MindMapUI.getResourceManager();
        IStyleSheet sts = rm.getSystemThemeSheet();
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
        String path = "styles/themeGroups.xml";
        DocumentBuilder documentBuilder = null;
        ArrayList<ThemeUIGroup> systemGroups = new ArrayList<ThemeUIGroup>();
        try {
            documentBuilder = XMLUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            Document doc = documentBuilder.parse(url.openStream());
            NodeList nodeList = doc.getElementsByTagName(THEME_GROUP);
            int i = 0;
            while (i < nodeList.getLength()) {
                Element ele = (Element)nodeList.item(i);
                String groupId = ele.getAttribute("id");
                String groupName = ele.getAttribute(GROUP_NAME).substring(1);
                groupName = this.getProperties().getProperty(groupName);
                NodeList themeList = ele.getElementsByTagName(THEME_ELEMENT);
                ArrayList<IStyle> themes = new ArrayList<IStyle>();
                int j = 0;
                while (j < themeList.getLength()) {
                    Element themeElement = (Element)themeList.item(j);
                    String themeId = themeElement.getAttribute("id");
                    IStyle theme = sts.findStyle(themeId);
                    themes.add(theme);
                    ++j;
                }
                ThemeUIGroup themeGroup = new ThemeUIGroup(groupId, groupName, themes.toArray(new IStyle[themes.size()]));
                if (themeGroup.getItems().length != 0) {
                    systemGroups.add(themeGroup);
                }
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return systemGroups;
    }

    private ThemeUIGroup getDefaultGroup() {
        IResourceManager rm = MindMapUI.getResourceManager();
        IStyle[] defaultGroup = new IStyle[]{rm.getDefaultTheme()};
        return new ThemeUIGroup(DEFAULT_GROUP_ID, MindMapMessages.ThemeUICore_group_default_name, defaultGroup);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    private Properties loadProperties() {
        Properties properties;
        block12: {
            Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
            URL propertiesUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("styles/themeGroups.properties"), null);
            properties = new Properties();
            InputStream stream = null;
            try {
                try {
                    stream = propertiesUrl.openStream();
                    properties.load(stream);
                }
                catch (IOException e) {
                    Logger.log(e, "Failed to load default properties file from: themeGroups.properties");
                    if (stream == null) break block12;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    public static ThemeUICore getInstance() {
        if (instance == null) {
            instance = new ThemeUICore();
        }
        return instance;
    }

    protected class ThemeUIGroup {
        private String name;
        private String id;
        private IStyle[] items;

        public ThemeUIGroup(String id, String name, IStyle[] items) {
            this.id = id;
            this.name = name;
            this.items = items;
        }

        public String getName() {
            return this.name;
        }

        public IStyle[] getItems() {
            return this.items;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof ThemeUIGroup)) {
                return false;
            }
            return ((ThemeUIGroup)obj).id.equals(this.id);
        }
    }
}

