/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.draw2d.Graphics;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.SVGShape;

final class SVGUseElement
extends SVGShape {
    private float x;
    private float y;
    private SVGShape link;

    SVGUseElement() {
    }

    public SVGUseElement(SVGShape link) {
        this.link = link;
    }

    @Override
    void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseUse(implemention, parent);
    }

    private void parseUse(Element implemention, SVGShape parent) {
        if (implemention.hasAttribute("xlink:href")) {
            String hrefId = implemention.getAttribute("xlink:href");
            String[] strs = hrefId.split("#");
            if (strs.length >= 2) {
                this.link = ((SVGShape)idRefs.get(strs[1])).clone();
            }
            if (this.link != null) {
                this.link.getInfo().add(this.getInfo());
            }
        }
        this.x = this.getFloatAttribute(implemention, "x");
        this.y = this.getFloatAttribute(implemention, "y");
    }

    @Override
    void paintImage(Graphics graphics, Display device) {
        if (this.link != null) {
            boolean statePushed = super.prePaint(graphics);
            graphics.translate(this.x, this.y);
            this.link.paintImage(graphics, device);
            super.postPaint(graphics, statePushed);
        }
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        super.setResourceManager(resourceManager);
        this.link.setResourceManager(resourceManager);
    }

    @Override
    Path generatePath(Display device) {
        return null;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return null;
    }

    @Override
    protected SVGShape clone() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVGUseElement) {
            SVGUseElement use = (SVGUseElement)obj;
            if (this.getInfo().equals(use.getInfo()) && this.x == use.x && this.y == use.y && this.link.equals(use.link)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        result = result * 31 + Float.floatToIntBits(this.x);
        result = result * 31 + Float.floatToIntBits(this.y);
        result = result * 31 + this.link.hashCode();
        return result;
    }

    public String toString() {
        return "SVGUse(" + this.getInfo().toString() + this.link.toString() + ")";
    }
}

