/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.PathElement;
import org.xmind.ui.internal.svgsupport.PathParser;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGPath
extends SVGShape {
    private List<PathElement> elements;

    SVGPath() {
        this.elements = Collections.emptyList();
    }

    public SVGPath(List<PathElement> elements) {
        this.elements = elements;
    }

    @Override
    void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parsePath(implemention, parent);
    }

    private void parsePath(Element implemention, SVGShape parent) {
        if (implemention.hasAttribute("d")) {
            String pathDefinitionString = implemention.getAttribute("d");
            PathParser parser = PathParser.getInstance();
            this.elements = parser.parseSVGPath(pathDefinitionString);
        }
    }

    @Override
    Path generatePath(Display device) {
        Path path = new Path((Device)device);
        for (PathElement ele : this.elements) {
            ele.addToPath(path);
        }
        return path;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return INVALID_RECT;
    }

    @Override
    protected SVGShape clone() {
        SVGPath path = new SVGPath();
        path.elements = this.elements;
        path.setInfo(this.getInfo().clone());
        return path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVGPath) {
            SVGPath path = (SVGPath)obj;
            if (this.elements.size() == path.elements.size()) {
                int i = 0;
                while (i < this.elements.size()) {
                    if (!this.elements.get(i).equals(path.elements.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        for (PathElement element : this.elements) {
            result = result * 31 + element.hashCode();
        }
        return result;
    }

    public String toString() {
        return "SVGPath( elements:" + this.elements.size() + " " + this.getInfo().toString() + " )";
    }
}

