/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGLineShape
extends SVGShape {
    private PrecisionPoint p1;
    private PrecisionPoint p2;

    SVGLineShape() {
    }

    public SVGLineShape(double x1, double y1, double x2, double y2) {
        this.p1 = new PrecisionPoint(x1, y1);
        this.p2 = new PrecisionPoint(x2, y2);
    }

    @Override
    void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseLine(implemention, parent);
    }

    private void parseLine(Element implemention, SVGShape parent) {
        float x1 = this.getFloatAttribute(implemention, "x1");
        float x2 = this.getFloatAttribute(implemention, "x2");
        float y1 = this.getFloatAttribute(implemention, "y1");
        float y2 = this.getFloatAttribute(implemention, "y2");
        this.p1 = new PrecisionPoint((double)x1, (double)y1);
        this.p2 = new PrecisionPoint((double)x2, (double)y2);
    }

    @Override
    Path generatePath(Display device) {
        Path path = new Path((Device)device);
        path.moveTo(this.p1);
        path.lineTo(this.p2);
        return path;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return new PrecisionRectangle(this.p1, this.p2);
    }

    @Override
    protected SVGShape clone() {
        SVGLineShape line = new SVGLineShape();
        line.setInfo(this.getInfo().clone());
        line.p1 = this.p1;
        line.p2 = this.p2;
        return line;
    }

    public boolean equals(Object obj) {
        SVGLineShape line;
        if (this == obj) {
            return true;
        }
        return obj instanceof SVGLineShape && (line = (SVGLineShape)obj).getInfo().equals(this.getInfo()) && this.p1.equals((Object)line.p1) && this.p2.equals((Object)line.p2);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        result = result * 31 + (int)Double.doubleToLongBits(this.p1.x);
        result = result * 31 + (int)Double.doubleToLongBits(this.p1.y);
        result = result * 31 + (int)Double.doubleToLongBits(this.p2.x);
        result = result * 31 + (int)Double.doubleToLongBits(this.p2.y);
        return result;
    }

    public String toString() {
        return "SVGLine( p1:" + this.p1.toString() + "; p2:" + this.p2.toString() + this.getInfo().toString() + " )";
    }
}

