/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.mindmap.IHyperlinked;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class TopicProtocol
implements IProtocol {
    @Override
    public IAction createOpenHyperlinkAction(Object context, String uri) {
        IWorkbook workbook = MindMapUtils.findWorkbook(context);
        if (workbook == null) {
            return null;
        }
        Object element = HyperlinkUtils.findElement((String)uri, (IWorkbook)workbook);
        ImageDescriptor icon = this.getIcon(element);
        if (icon == null) {
            icon = MindMapUI.getImages().get("unknownfile.gif", true);
        }
        String title = this.getTitle(element);
        String sheetTitle = this.getSheetTitle(element);
        String name = sheetTitle != null ? String.format("%s (%s)", title, sheetTitle) : title;
        GoTopicAction action = new GoTopicAction(MindMapMessages.TopicProtocol_GoToTopic_text, icon, uri, workbook, context);
        action.setToolTipText(name);
        return action;
    }

    private ImageDescriptor getIcon(Object element) {
        if (element instanceof ITopic) {
            ITopic topic = (ITopic)element;
            return MindMapUI.getImages().getTopicIcon(topic, true);
        }
        return null;
    }

    private String getSheetTitle(Object element) {
        ISheet sheet = this.getSheet(element);
        return sheet == null ? null : sheet.getTitleText();
    }

    private ISheet getSheet(Object element) {
        return MindMapUtils.findSheet(element);
    }

    private String getTitle(Object element) {
        return MindMapUtils.getText(element);
    }

    private static void navigateTo(Object context, Object element, IWorkbook workbook) {
        ISelectionProvider selectionProvider;
        if (context instanceof IAdaptable && (selectionProvider = (ISelectionProvider)((IAdaptable)context).getAdapter(ISelectionProvider.class)) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection(element));
            return;
        }
    }

    private Shell findShell(Object context) {
        if (context instanceof IAdaptable) {
            return (Shell)((IAdaptable)context).getAdapter(Shell.class);
        }
        return null;
    }

    @Override
    public boolean isHyperlinkModifiable(Object source, String uri) {
        return true;
    }

    private boolean confirmDelete(Object context, String uri) {
        return MessageDialog.openQuestion((Shell)this.findShell(context), (String)DialogMessages.TopicProtocol_ConfirmDeleteInvalidTopicHyperlink_windowTitle, (String)DialogMessages.TopicProtocol_ConfirmDeleteInvalidTopicHyperlink_message);
    }

    private void deleteHyperlink(ITopic topic, Object context, String uri) {
        ModifyTopicHyperlinkCommand command = new ModifyTopicHyperlinkCommand(topic, null);
        command.setLabel(CommandMessages.Command_ModifyTopicHyperlink);
        ICommandStack commandStack = this.findCommandStack(context);
        if (commandStack != null) {
            commandStack.execute((Command)command);
        } else {
            command.execute();
        }
    }

    private ITopic findSourceTopic(Object context) {
        if (context instanceof ITopic) {
            return (ITopic)context;
        }
        if (context instanceof IAdaptable) {
            return (ITopic)((IAdaptable)context).getAdapter(ITopic.class);
        }
        if (context instanceof org.xmind.core.IAdaptable) {
            return (ITopic)((org.xmind.core.IAdaptable)context).getAdapter(ITopic.class);
        }
        return null;
    }

    private ICommandStack findCommandStack(Object context) {
        if (context instanceof IAdaptable) {
            return (ICommandStack)((IAdaptable)context).getAdapter(ICommandStack.class);
        }
        return null;
    }

    private class GoTopicAction
    extends Action
    implements IHyperlinked {
        private String uri;
        private IWorkbook workbook;
        private Object context;

        public GoTopicAction(String text, ImageDescriptor image, String uri, IWorkbook workbook, Object context) {
            super(text);
            this.uri = uri;
            this.workbook = workbook;
            this.context = context;
            this.setImageDescriptor(image);
        }

        public void run() {
            Object element = HyperlinkUtils.findElement((String)this.uri, (IWorkbook)this.workbook);
            if (element != null) {
                TopicProtocol.navigateTo(this.context, element, this.workbook);
            } else {
                ITopic topic = TopicProtocol.this.findSourceTopic(this.context);
                if (topic == null) {
                    return;
                }
                if (TopicProtocol.this.confirmDelete(this.context, this.uri)) {
                    TopicProtocol.this.deleteHyperlink(topic, this.context, this.uri);
                }
            }
        }

        @Override
        public String getHyperlink() {
            return this.uri;
        }
    }
}

