/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IDecorator;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.ui.internal.decorators.LabelDecorator;
import org.xmind.ui.internal.mindmap.BranchPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.util.MindMapUtils;

public class LabelPart
extends MindMapPartBase
implements ILabelPart,
PropertyChangeListener {
    private String labelText = null;

    public LabelPart() {
        this.setDecorator((IDecorator)LabelDecorator.getInstance());
    }

    protected IFigure createFigure() {
        boolean useAdvancedRenderer = this.getSite().getViewer().getProperties().getBoolean("renderTextAsPath", false);
        return new RotatableWrapLabel(useAdvancedRenderer ? 1 : 0);
    }

    @Override
    public String getLabelText() {
        if (this.labelText == null) {
            this.labelText = this.buildLabelText();
        }
        return this.labelText;
    }

    private String buildLabelText() {
        return MindMapUtils.getLabelText(this.getLabels());
    }

    @Override
    public Set<String> getLabels() {
        return this.getTopic().getLabels();
    }

    @Override
    public IBranchPart getOwnedBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    @Override
    public ITopic getTopic() {
        return (ITopic)super.getRealModel();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        return super.getAdapter(adapter);
    }

    public void setParent(IPart parent) {
        BranchPart branch;
        if (this.getParent() instanceof BranchPart && (branch = (BranchPart)this.getParent()).getLabel() == this) {
            branch.setLabel(null);
        }
        super.setParent(parent);
        if (this.getParent() instanceof BranchPart) {
            branch = (BranchPart)this.getParent();
            branch.setLabel(this);
        }
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("editable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("navigable role", "org.xmind.ui.editPolicy.topicNavigable");
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("labels");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("labels".equals(type)) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    LabelPart.this.labelText = null;
                    LabelPart.this.update();
                }
            });
        } else {
            super.handleCoreEvent(event);
        }
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        this.getSite().getViewer().getProperties().addPropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
    }

    @Override
    protected void onDeactivated() {
        this.getSite().getViewer().getProperties().removePropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
        super.onDeactivated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean useAdvancedRenderer = this.getSite().getViewer().getProperties().getBoolean("renderTextAsPath", false);
        ((RotatableWrapLabel)this.getFigure()).setRenderStyle(useAdvancedRenderer ? 1 : 0);
    }
}

