/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IDecoratedFigureListener;
import org.xmind.gef.draw2d.decoration.IConnectionDecorationEx;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.service.AbstractFeedback;

public abstract class DecoratedFeedback
extends AbstractFeedback {
    private IDecoration decoration;
    private DecoratedFigure figure = null;

    protected void updateDecoration() {
        String oldDecorationId;
        if (this.figure == null) {
            return;
        }
        String newDecorationId = this.getNewDecorationId();
        String string = oldDecorationId = this.decoration == null ? null : this.decoration.getId();
        if (!DecoratedFeedback.equals(oldDecorationId, newDecorationId)) {
            if (this.decoration != null) {
                this.disposeOldDecoration((IFigure)this.figure, this.decoration);
            }
            this.decoration = this.createNewDecoration((IFigure)this.figure, newDecorationId);
        }
        if (this.decoration != null) {
            this.updateDecoration((IFigure)this.figure, this.decoration);
        }
    }

    protected abstract String getNewDecorationId();

    protected abstract IDecoration createNewDecoration(IFigure var1, String var2);

    protected abstract void updateDecoration(IFigure var1, IDecoration var2);

    protected abstract void disposeOldDecoration(IFigure var1, IDecoration var2);

    public DecoratedFigure getFigure() {
        return this.figure;
    }

    public IDecoration getDecoration() {
        return this.decoration;
    }

    protected DecoratedFigure createDecoratedFigure() {
        return new DecoratedFigure();
    }

    public void addToLayer(IFigure layer) {
        if (this.figure == null) {
            this.figure = this.createDecoratedFigure();
            this.updateDecoration();
        }
        layer.add((IFigure)this.figure);
    }

    public boolean containsPoint(Point point) {
        if (this.figure != null && this.decoration != null) {
            if (this.decoration instanceof IShapeDecorationEx) {
                return ((IShapeDecorationEx)this.decoration).containsPoint((IFigure)this.figure, point.x, point.y);
            }
            if (this.decoration instanceof IConnectionDecorationEx) {
                return ((IConnectionDecorationEx)this.decoration).containsPoint((IFigure)this.figure, point.x, point.y);
            }
        }
        return false;
    }

    public void removeFromLayer(IFigure layer) {
        if (this.figure != null && this.figure.getParent() == layer) {
            if (this.decoration != null) {
                this.disposeOldDecoration((IFigure)this.figure, this.decoration);
            }
            layer.remove((IFigure)this.figure);
        }
        this.decoration = null;
        this.figure = null;
    }

    public void update() {
        this.updateDecoration();
        if (this.figure != null) {
            this.updateBounds((IFigure)this.figure);
        }
    }

    protected void paintDecoration(Graphics graphics, IFigure figure, IDecoration decoration) {
        decoration.paint(figure, graphics);
    }

    protected abstract void updateBounds(IFigure var1);

    private static boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    protected class DecoratedFigure
    extends Figure
    implements IDecoratedFigure {
        protected DecoratedFigure() {
        }

        public IDecoration getDecoration() {
            return DecoratedFeedback.this.decoration;
        }

        public void paint(Graphics graphics) {
            GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
            super.paint(graphics);
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            if (DecoratedFeedback.this.decoration != null) {
                graphics.setAntialias(1);
                DecoratedFeedback.this.paintDecoration(graphics, (IFigure)this, DecoratedFeedback.this.decoration);
            }
        }

        public void invalidate() {
            super.invalidate();
            if (DecoratedFeedback.this.decoration != null) {
                DecoratedFeedback.this.decoration.invalidate();
            }
        }

        public void addDecoratedFigureListener(IDecoratedFigureListener listener) {
        }

        public void removeDecoratedFigureListener(IDecoratedFigureListener listener) {
        }
    }
}

