/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.DecoratedConnectionFigure;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IShadowedFigure;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.decorations.IRelationshipDecoration;

public class RelationshipFigure
extends DecoratedConnectionFigure
implements ITitledFigure,
IShadowedFigure {
    private ITextFigure title = null;
    private boolean titleVisible = false;

    public ITextFigure getTitle() {
        return this.title;
    }

    public void setTitle(ITextFigure title) {
        if (title == this.title) {
            return;
        }
        this.title = title;
        this.revalidate();
        this.repaint();
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setTitleVisible(boolean titleVisible) {
        if (titleVisible == this.titleVisible) {
            return;
        }
        this.titleVisible = titleVisible;
        this.revalidate();
        this.repaint();
    }

    protected void layout() {
        super.layout();
        if (this.title != null) {
            Rectangle r2;
            PrecisionPoint pos = this.getDecoration().getTitlePosition((IFigure)this);
            if (this.title instanceof IReferencedFigure) {
                r2 = ((IReferencedFigure)this.title).getPreferredBounds(pos.toDraw2DPoint());
            } else {
                Dimension size = this.title.getPreferredSize();
                r2 = Rectangle.SINGLETON;
                r2.setSize(size);
                r2.setLocation((int)(pos.x - (double)size.width / 2.0), (int)(pos.y - (double)size.height / 2.0));
            }
            this.title.setBounds(r2);
        }
    }

    public Rectangle getPreferredBounds() {
        Rectangle r = super.getPreferredBounds();
        if (this.title != null) {
            Rectangle r2;
            PrecisionPoint pos = this.getDecoration().getTitlePosition((IFigure)this);
            if (this.title instanceof IReferencedFigure) {
                r2 = ((IReferencedFigure)this.title).getPreferredBounds(pos.toDraw2DPoint());
            } else {
                Dimension size = this.title.getPreferredSize();
                r2 = Rectangle.SINGLETON;
                r2.setSize(size);
                r2.setLocation((int)(pos.x - (double)size.width / 2.0), (int)(pos.y - (double)size.height / 2.0));
            }
            r.union(r2);
        }
        return r;
    }

    public IRelationshipDecoration getDecoration() {
        return (IRelationshipDecoration)super.getDecoration();
    }

    public boolean isShadowShowing() {
        return this.isShowing();
    }

    public void paintShadow(Graphics graphics) {
        if (this.getDecoration() != null && this.getDecoration() instanceof IShadowedDecoration) {
            ((IShadowedDecoration)this.getDecoration()).paintShadow((IFigure)this, graphics);
        }
    }

    public String toString() {
        if (this.title != null) {
            return this.title.getText();
        }
        return super.toString();
    }
}

