/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.ui.internal.figures.BoundaryFigure;

public class BoundaryTitleFigure
extends RotatableWrapLabel {
    private static final float PADDING = 1.5f;
    private static final float H_MARGIN = 8.0f;
    private static final float V_MARGIN = 3.0f;
    private static final String NULLSTR = "";
    private static final String ONESPACE = " ";
    private BoundaryFigure boundary;
    private PrecisionRectangle textArea;

    public BoundaryTitleFigure() {
    }

    public BoundaryTitleFigure(String text) {
        super(text);
    }

    public BoundaryTitleFigure(int renderStyle) {
        super(renderStyle);
    }

    public BoundaryTitleFigure(String text, int renderStyle) {
        super(text, renderStyle);
    }

    protected void flushCaches() {
        super.flushCaches();
        this.textArea = null;
    }

    private int getPreferenceWHint(int wHint) {
        if (this.getBoundary() != null) {
            return wHint > this.getBoundary().getBounds().width ? this.getBoundary().getBounds().width : wHint;
        }
        return wHint;
    }

    protected PrecisionRectangle getTextArea(int wHint) {
        wHint = this.getPreferenceWHint(wHint);
        this.receiveWidthCaches(wHint);
        if (this.textArea == null) {
            PrecisionDimension size = this.calculateTextSize(wHint);
            this.textArea = new PrecisionRectangle();
            float h_margin = 8.0f;
            float v_margin = 3.0f;
            int height = this.getFont().getFontData()[0].getHeight();
            if (height > 30) {
                h_margin += 5.0f;
            }
            this.textArea.width = size.width + 3.0 + (double)h_margin;
            this.textArea.height = size.height + 3.0 + (double)v_margin;
            this.textArea.x = -(this.textArea.width / 2.0);
            this.textArea.y = -(this.textArea.height / 2.0);
        }
        return this.textArea;
    }

    protected String calculateAppliedText(double wHint) {
        String theText = this.getText();
        if (wHint <= 5.0 || theText.length() == 0) {
            return theText;
        }
        Font f = this.getFont();
        String[] lines = this.forceSplitText(theText, f, wHint);
        return this.getForceSplitText(lines);
    }

    private String[] forceSplitText(String theText, Font f, double wHint) {
        wHint -= 5.0;
        ArrayList<String> buffer = new ArrayList<String>();
        theText = theText.trim();
        if ((double)this.getShowLooseTextSize((String)theText, (Font)f).width < wHint) {
            buffer.add(theText);
            return buffer.toArray(new String[buffer.size()]);
        }
        String cachedString = NULLSTR;
        String appendString = NULLSTR;
        String[] lines = theText.split(ONESPACE);
        int i = 0;
        do {
            if (lines[i].equals(NULLSTR)) {
                lines[i] = ONESPACE;
            }
            if ((double)this.getShowLooseTextSize((String)lines[i], (Font)f).width >= wHint) {
                if (cachedString.trim() != NULLSTR) {
                    buffer.add(cachedString.trim());
                    cachedString = NULLSTR;
                }
                cachedString = this.truncate(lines[i], buffer, wHint, f);
                ++i;
                continue;
            }
            appendString = String.valueOf(cachedString) + lines[i];
            if ((double)this.getShowLooseTextSize((String)appendString, (Font)f).width >= wHint) {
                if (cachedString.trim() != NULLSTR) {
                    buffer.add(cachedString.trim());
                }
                cachedString = lines[i];
            } else {
                cachedString = String.valueOf(cachedString) + lines[i];
            }
            cachedString = String.valueOf(cachedString) + ONESPACE;
            ++i;
        } while (i < lines.length);
        if (cachedString.trim() != NULLSTR) {
            buffer.add(cachedString.trim());
        }
        return buffer.toArray(new String[buffer.size()]);
    }

    private String truncate(String s, List<String> buffer, double wHint, Font f) {
        String token = s;
        while (wHint > 0.0 && !token.equals(NULLSTR)) {
            boolean isLastSnip = true;
            String current = token;
            while ((double)this.getShowLooseTextSize((String)current, (Font)f).width >= wHint) {
                isLastSnip = false;
                current = current.substring(0, current.length() - 1);
            }
            if ((double)this.getShowLooseTextSize((String)current, (Font)f).width < wHint && !isLastSnip) {
                buffer.add(token.substring(0, current.length()).trim());
                token = token.substring(current.length());
                continue;
            }
            return token;
        }
        return token;
    }

    private String getForceSplitText(String[] lines) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            sb.append(String.valueOf(line) + '\n');
            ++n2;
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Dimension getShowLooseTextSize(String s, Font f) {
        int textCase = this.getTextCase();
        s = this.getShowText(s, textCase);
        return this.getLooseTextSize(s, f);
    }

    private BoundaryFigure getBoundary() {
        return this.boundary;
    }

    public void setBoundary(IFigure boundary) {
        this.boundary = (BoundaryFigure)boundary;
    }
}

