/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.util.BundleUtility;
import org.xmind.core.ISheet;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.IMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.MindMapPreviewOptions;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;

public class DefaultMindMapPreviewGenerator
implements IMindMapPreviewGenerator {
    private static final int DEFAULT_EXPORT_MARGIN = 5;
    private static final int MINIMUM_PREVIEW_WIDTH = 420;
    private static final int MAXIMUM_PREVIEW_WIDTH = 1680;
    private final Display display;

    public DefaultMindMapPreviewGenerator(Display display) {
        this.display = display;
    }

    @Override
    public Properties generateMindMapPreview(IWorkbookRef workbookRef, final ISheet sheet, final OutputStream output, MindMapPreviewOptions options) throws IOException {
        Assert.isLegal((output != null ? 1 : 0) != 0);
        Properties properties = new Properties();
        if (sheet == null || MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("previewSkipped")) {
            URL url = BundleUtility.find((String)"org.xmind.ui", (String)"icons/misc/default_thumbnail.jpg");
            if (url != null) {
                InputStream input = url.openStream();
                try {
                    FileUtils.transfer((InputStream)input, (OutputStream)output, (boolean)false);
                }
                finally {
                    input.close();
                }
            }
            return properties;
        }
        final Exception[] error = new Exception[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultMindMapPreviewGenerator.this.generate(sheet, output);
                }
                catch (SWTException e) {
                    error[0] = e;
                }
            }
        });
        if (error[0] != null) {
            throw new IOException(error[0]);
        }
        return properties;
    }

    private void generate(ISheet sheet, OutputStream output) {
        GhostShellProvider ghostShellProvider = new GhostShellProvider(this.display);
        MindMapExportViewer viewer = new MindMapExportViewer(ghostShellProvider, (Object)new MindMap(sheet), null);
        MindMapViewerExportSourceProvider sourceProvider = new MindMapViewerExportSourceProvider((IGraphicalViewer)viewer, 5);
        Rectangle sourceArea = sourceProvider.getSourceArea();
        int resizeWidth = Math.max(sourceArea.width % 21 == 0 ? sourceArea.width : sourceArea.width + 21 - sourceArea.width % 21, sourceArea.height % 13 == 0 ? sourceArea.height * 21 / 13 : (sourceArea.height + 13 - sourceArea.height % 13) * 21 / 13);
        if (resizeWidth < 420) {
            resizeWidth = 420;
        } else if (resizeWidth > 1680) {
            resizeWidth = 1680;
        }
        int resizeHeight = resizeWidth * 13 / 21;
        MindMapImageExporter exporter = new MindMapImageExporter(this.display);
        exporter.setSourceProvider(sourceProvider);
        exporter.setResize(1, resizeWidth, resizeHeight);
        exporter.setTargetStream(output);
        exporter.export();
    }
}

