/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.dnd.MindMapDNDClientBase;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;

public class URLDndClient
extends MindMapDNDClientBase {
    private URLTransfer transfer = URLTransfer.getInstance();

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        return null;
    }

    @Override
    protected Object[] toViewerElements(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent) {
        String url = (String)transferData;
        if (workbook != null) {
            try {
                URI uri = new URI(url);
                if (targetParent != null && dropInParent) {
                    if (this.isImageURL(uri)) {
                        return new Object[]{this.createModifyImageCommand(targetParent, uri.toString(), -1, -1, null)};
                    }
                    return new Object[]{uri};
                }
                ITopic topic = workbook.createTopic();
                if (this.isImageURL(uri)) {
                    topic.getImage().setSource(uri.toString());
                } else {
                    topic.setTitleText(url);
                    topic.setHyperlink(url);
                }
                return new Object[]{topic};
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.log("[URLDndClient] Failed to parse invalid URL: " + url);
            }
        }
        return null;
    }

    private boolean isImageURL(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            return false;
        }
        return ImageFormat.findByExtension((String)FileUtils.getExtension((String)path), null) != null;
    }

    @Override
    public boolean canLink(TransferData data, IViewer viewer, Point location, IPart target) {
        return true;
    }
}

