/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;

@Deprecated
public class OpenWorkbookDialog {
    private static final String OPEN_DIALOG_SETTINGS_ID = "org.xmind.ui.openDialog";
    private static final String OLD_FILE_EXT = ".xmap";
    private static final String FILTER_INDEX = "filterIndex";
    private static final String FILTER_PATH = "filterPath";
    private IWorkbenchWindow window;
    private IDialogSettings ds;

    public OpenWorkbookDialog(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
    }

    public IEditorPart[] open() {
        if (this.window == null) {
            return null;
        }
        FileDialog fd = new FileDialog(this.window.getShell(), 4098);
        String xmindExt = "*.xmind";
        String xmtExt = "*.xmt";
        String oldExt = "*.xmap";
        String allSupportedFileExt = String.format("%s;%s;%s", xmindExt, xmtExt, oldExt);
        String allExt = "*.*";
        fd.setFilterExtensions(new String[]{xmindExt, oldExt, allSupportedFileExt, allExt});
        fd.setFilterNames(new String[]{NLS.bind((String)"{0} ({1})", (Object)DialogMessages.WorkbookFilterName, (Object)xmindExt), NLS.bind((String)"{0} ({1})", (Object)DialogMessages.OldWorkbookFilterName, (Object)oldExt), NLS.bind((String)"{0} ({1}, {2}, {3})", (Object[])new Object[]{DialogMessages.AllSupportedFilesFilterName, xmindExt, xmtExt, oldExt}), NLS.bind((String)"{0} ({1})", (Object)DialogMessages.AllFilesFilterName, (Object)allExt)});
        fd.setFilterIndex(this.getFilterIndex());
        String path = this.getFilterPath();
        if (path != null && !"".equals(path)) {
            fd.setFilterPath(path);
        }
        if (fd.open() == null) {
            return null;
        }
        path = fd.getFilterPath();
        String[] fileNames = fd.getFileNames();
        this.setFilterIndex(fd.getFilterIndex());
        this.setFilterPath(path);
        ArrayList<IEditorPart> editors = new ArrayList<IEditorPart>(fileNames.length);
        int i = 0;
        while (i < fileNames.length) {
            IEditorPart editor;
            File file = new File(path, fileNames[i]);
            if (file.exists() && (editor = this.open(file)) != null) {
                editors.add(editor);
            }
            ++i;
        }
        if (editors.isEmpty()) {
            return null;
        }
        return editors.toArray(new IEditorPart[editors.size()]);
    }

    private void setFilterIndex(int index) {
        this.getDialogSettings().put(FILTER_INDEX, index);
    }

    private int getFilterIndex() {
        try {
            int filterIndex = this.getDialogSettings().getInt(FILTER_INDEX);
            if (filterIndex >= 0 && filterIndex <= 2) {
                return filterIndex;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    private void setFilterPath(String path) {
        this.getDialogSettings().put(FILTER_PATH, path);
    }

    private String getFilterPath() {
        return this.getDialogSettings().get(FILTER_PATH);
    }

    private IDialogSettings getDialogSettings() {
        if (this.ds == null) {
            IDialogSettings global = MindMapUIPlugin.getDefault().getDialogSettings();
            this.ds = global.getSection(OPEN_DIALOG_SETTINGS_ID);
            if (this.ds == null) {
                this.ds = global.addNewSection(OPEN_DIALOG_SETTINGS_ID);
            }
        }
        return this.ds;
    }

    protected IEditorPart open(final File file) {
        final IEditorPart[] editor = new IEditorPart[1];
        String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)file.getAbsolutePath());
        SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

            public void run() throws Exception {
                IEditorInput input = MME.createFileEditorInput(file);
                editor[0] = OpenWorkbookDialog.this.window.getActivePage().openEditor(input, "org.xmind.ui.MindMapEditor");
            }
        });
        return editor[0];
    }

    public void dispose() {
        this.window = null;
    }
}

