/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBranchConnection;

public class StraightBranchConnection
extends AbstractBranchConnection {
    private PrecisionPoint s1 = new PrecisionPoint();
    private PrecisionPoint s2 = new PrecisionPoint();
    private PrecisionPoint t1 = new PrecisionPoint();
    private PrecisionPoint t2 = new PrecisionPoint();
    private PrecisionPoint c1 = new PrecisionPoint();
    private PrecisionPoint c2 = new PrecisionPoint();
    private boolean cachedTapered;

    public StraightBranchConnection() {
    }

    public StraightBranchConnection(String id) {
        super(id);
    }

    protected void route(IFigure figure, Path shape) {
        PrecisionPoint p1 = this.getSourcePosition(figure);
        PrecisionPoint p2 = this.getTargetPosition(figure);
        if (this.isTapered()) {
            shape.moveTo(this.s1);
            shape.lineTo(this.c1);
            shape.lineTo(this.c2);
            shape.lineTo(this.s2);
            shape.lineTo(this.t2);
            shape.lineTo(this.t1);
            shape.close();
        } else {
            shape.moveTo(p1);
            shape.lineTo(p2);
        }
    }

    public void invalidate() {
        super.invalidate();
        this.cachedTapered = false;
    }

    @Override
    protected boolean isPositionValid() {
        return super.isPositionValid() && this.cachedTapered == this.isTapered();
    }

    @Override
    protected void calculateControlPoints(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos) {
        super.calculateControlPoints(figure, sourcePos, targetPos);
        this.cachedTapered = this.isTapered();
        if (this.isTapered()) {
            this.calcTaperedPositions(sourcePos, targetPos, 0.0, this.s1, this.s2);
            this.calcTaperedPositions(sourcePos, targetPos, 1.0, this.t1, this.t2);
            this.calculateSourceControlPoints(this.t1, this.s1, this.s2, this.c1);
            this.calculateSourceControlPoints(this.t2, this.s2, this.s1, this.c2);
        }
    }
}

