/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.decoration.IShapeDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBranchConnection;

public abstract class AbstractCalloutBranchConnection
extends AbstractBranchConnection
implements IShapeDecoration {
    private boolean gradient = false;
    private Color fillColor = null;
    private int fillAlpha = 255;
    private int lineAlpha = 255;

    public AbstractCalloutBranchConnection() {
    }

    public AbstractCalloutBranchConnection(String id) {
        super(id);
    }

    protected Rectangle getOutlineBox(Rectangle box) {
        Rectangle ret = box.getCopy();
        int w = Math.min(ret.width - 1, Math.min(ret.height - 1, this.getLineWidth()));
        int half = w - w / 2;
        return ret.shrink(half, half).resize(-1, -1);
    }

    protected void drawLine(IFigure figure, Graphics graphics) {
        Path shape = new Path((Device)Display.getCurrent());
        this.route(figure, shape);
        if (this.getFillColor() != null) {
            Color bg = graphics.getBackgroundColor();
            graphics.setBackgroundColor(this.getFillColor());
            this.paintPath(figure, graphics, shape, true);
            graphics.setBackgroundColor(bg);
        }
        if (graphics.getForegroundColor() != null) {
            this.paintPath(figure, graphics, shape, false);
        }
        shape.dispose();
    }

    @Override
    protected boolean usesFill() {
        return true;
    }

    public int getFillAlpha() {
        return this.fillAlpha;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getLineAlpha() {
        return this.lineAlpha;
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public void setFillAlpha(IFigure figure, int alpha) {
        if (alpha == this.fillAlpha) {
            return;
        }
        this.fillAlpha = alpha;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setFillColor(IFigure figure, Color c) {
        if (c == this.fillColor || c != null && c.equals((Object)this.fillColor)) {
            return;
        }
        this.fillColor = c;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setGradient(IFigure figure, boolean gradient) {
        if (gradient == this.gradient) {
            return;
        }
        this.gradient = gradient;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineAlpha(IFigure figure, int alpha) {
        if (alpha == this.lineAlpha) {
            return;
        }
        this.lineAlpha = alpha;
        if (figure != null) {
            this.repaint(figure);
        }
    }
}

