/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.draw2d.geometry.VerticalFlipper;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class UpDownStructure
extends AbstractBranchStructure {
    private boolean upwards;
    private ITransformer t = new VerticalFlipper();

    public UpDownStructure(boolean upwards) {
        this.upwards = upwards;
        this.t.setEnabled(upwards);
    }

    public boolean isUpwards() {
        return this.upwards;
    }

    @Override
    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        int x = ref.x;
        Rectangle topicBounds = info.getCheckedClientArea();
        topicBounds = this.t.tr(topicBounds);
        int y = topicBounds.bottom();
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        Rectangle r = new Rectangle(x - size.width / 2, y, size.width, size.height);
        info.put(pmFigure, this.t.rr(r));
    }

    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Dimension insSize;
        Rectangle r;
        int majorSpacing = this.getMajorSpacing(branch);
        int minorSpacing = this.getMinorSpacing(branch);
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        Rectangle refBounds = info.getCheckedClientArea();
        refBounds = this.t.tr(refBounds);
        int y = refBounds.bottom() + majorSpacing;
        int num = subBranches.size();
        int totalWidth = this.calcTotalChildrenWidth(branch, minorSpacing, true);
        int left = totalWidth / 2;
        int x = ref.x - left;
        IInsertion insertion = this.getCurrentInsertion(branch);
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        int i = 0;
        while (i < num) {
            if (insertion != null && i == insertion.getIndex()) {
                r = insertion.createRectangle(x, y);
                info.add(this.t.rr(r));
                x += r.width + minorSpacing;
            }
            IBranchPart subBranchPart = subBranches.get(i);
            IFigure subBranchFigure = subBranchPart.getFigure();
            Insets ins = helper.getInsets(subBranchPart);
            Dimension size = subBranchFigure.getPreferredSize();
            Rectangle r2 = new Rectangle(x + ins.left, y + ins.top, size.width, size.height);
            info.put(subBranchFigure, this.t.rr(r2));
            x += size.width + ins.getWidth() + minorSpacing;
            ++i;
        }
        if (insertion != null && num == insertion.getIndex() && (insSize = insertion.getSize()) != null) {
            r = new Rectangle(x, y, insSize.width, insSize.height);
            info.add(this.t.rr(r));
        }
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_left".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate_right".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential && (this.isUpwards() ? "navigate_down".equals(navReqType) : "navigate_up".equals(navReqType))) {
            return branch.getTopicPart();
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (!branch.getSubBranches().isEmpty() && (this.isUpwards() ? "navigate_up".equals(navReqType) : "navigate_down".equals(navReqType))) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        if (this.isUpwards()) {
            return 1;
        }
        return 4;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return this.calcChildTargetOrientation();
    }

    private int calcChildTargetOrientation() {
        if (this.isUpwards()) {
            return 4;
        }
        return 1;
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        IFigure branchFigure = branch.getFigure();
        IReferencedFigure topicFigure = (IReferencedFigure)branch.getTopicPart().getFigure();
        Point ref = topicFigure.getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Rectangle branchBounds = this.t.tr(branchFigure.getBounds());
        Rectangle topicBounds = this.t.tr(topicFigure.getBounds());
        int dy = childRef.y - topicBounds.bottom();
        if (dy > 0) {
            if (childRef.x >= branchBounds.x && childRef.x < branchBounds.right() && dy < 200) {
                return dy;
            }
            int dx = childRef.x - ref.x;
            int d = dx * dx + dy * dy;
            return d;
        }
        return super.calcChildDistance(branch, key);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        IFigure topicFigure = topic.getFigure();
        Point ref = ((IReferencedFigure)topicFigure).getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Dimension insSize = this.calcInsSize(branch, key);
        int insWidth = insSize.width;
        int minorSpacing = this.getMinorSpacing(branch);
        int totalChildrenWidth = this.calcTotalChildrenWidth(branch, minorSpacing, false);
        int totalWidth = totalChildrenWidth + insWidth + minorSpacing;
        int x = ref.x - totalWidth / 2;
        return this.calcInsIndex(branch, x, childRef, minorSpacing, insWidth, withDisabled);
    }

    private int calcInsIndex(IBranchPart branch, int x, Point childRef, int spacing, int childWidth, boolean withDisabled) {
        int ret = 0;
        int sum = 0;
        List<IBranchPart> subBranches = branch.getSubBranches();
        int num = subBranches.size();
        for (IBranchPart subBranch : subBranches) {
            IFigure subFigure = subBranch.getFigure();
            int w = subFigure.getPreferredSize().width;
            int hint = x + sum + (childWidth + w + spacing) / 2;
            if (childRef.x < hint) {
                return ret;
            }
            sum += w + spacing;
            if (!withDisabled && !subFigure.isEnabled()) continue;
            ++ret;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IBranchPart branch, ParentSearchKey key) {
        return key.getFigure().getSize().scale(0.8);
    }

    private int calcTotalChildrenWidth(IBranchPart branch, int minorSpacing, boolean withInsertion) {
        Dimension insSize;
        IInsertion ins;
        int totalWidth = 0;
        Iterator<IBranchPart> it = branch.getSubBranches().iterator();
        while (it.hasNext()) {
            IBranchPart subBranch = it.next();
            totalWidth += subBranch.getFigure().getPreferredSize().width;
            if (!it.hasNext()) continue;
            totalWidth += minorSpacing;
        }
        if (withInsertion && (ins = this.getCurrentInsertion(branch)) != null && (insSize = ins.getSize()) != null) {
            totalWidth += minorSpacing + insSize.width;
        }
        return totalWidth;
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return new Insertion(branch, this.calcInsIndex(branch, key, true), this.calcInsSize(branch, key));
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return this.upwards ? 1 : 4;
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 16;
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 16) {
            return 1;
        }
        if (direction == 8) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    @Override
    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return this.calcFirstChildPosition(branch, key);
        }
        int minorSpacing = this.getMinorSpacing(branch);
        int index = this.calcInsIndex(branch, key, true);
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        List<IBoundaryPart> boundaries = branch.getBoundaries();
        if (index == 0) {
            IBranchPart sub = subBranches.get(0);
            Rectangle bounds = sub.getFigure().getBounds();
            if (!boundaries.isEmpty()) {
                for (IBoundaryPart boundary : boundaries) {
                    Rectangle bBounds = boundary.getFigure().getBounds();
                    List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !sub.equals(enclosingBranches.get(0))) continue;
                    Rectangle rectangle = bounds = bBounds.contains(bounds) ? bBounds : bounds;
                }
            }
            int x = bounds.x - minorSpacing - insSize.width / 2;
            int y = this.isUpwards() ? bounds.bottom() - inventSize.width / 2 : bounds.y + inventSize.width / 2;
            return new Point(x, y);
        }
        if (index == subBranches.size()) {
            IBranchPart sub = subBranches.get(subBranches.size() - 1);
            Rectangle bounds = sub.getFigure().getBounds();
            if (!boundaries.isEmpty()) {
                for (IBoundaryPart boundary : boundaries) {
                    Rectangle bBounds = boundary.getFigure().getBounds();
                    List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !sub.equals(enclosingBranches.get(enclosingBranches.size() - 1))) continue;
                    Rectangle rectangle = bounds = bBounds.contains(bounds) ? bBounds : bounds;
                }
            }
            int x = bounds.right() + minorSpacing + insSize.width / 2;
            int y = this.isUpwards() ? bounds.bottom() - inventSize.width / 2 : bounds.y + inventSize.width / 2;
            return new Point(x, y);
        }
        return this.calcInventPosition(subBranches.get(index - 1), subBranches.get(index), key, this.isUpwards());
    }

    @Override
    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<Integer> disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        Dimension inventSize = key.getInvent().getSize();
        if (index == oldIndex) {
            IBranchPart sub = subBranches.get(index);
            int delta = sub.getTopicPart().getFigure().getSize().height / 2 - inventSize.height / 2;
            return this.getFigureLocation(sub.getFigure()).getTranslated(0, this.isUpwards() ? delta : -delta);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    @Override
    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int y = branch.getFigure().getSize().height / 2 + this.getMajorSpacing(branch) + key.getInvent().getSize().height / 2;
        return this.getFigureLocation(branch.getFigure()).getTranslated(0, this.isUpwards() ? -y : y);
    }

    @Override
    protected Point calcInventPosition(IBranchPart orientation, IBranchPart assist, ParentSearchKey key, boolean isRightOrUp) {
        boolean isBefourBounds;
        Rectangle bounds;
        int minorSpacing = this.getMinorSpacing(orientation.getParentBranch());
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        Rectangle oriBounds = orientation.getFigure().getBounds();
        Rectangle assBounds = assist.getFigure().getBounds();
        Rectangle lBounds = oriBounds;
        Rectangle rBounds = assBounds;
        List<IBoundaryPart> boundaries = orientation.getParentBranch().getBoundaries();
        if (!boundaries.isEmpty()) {
            for (IBoundaryPart boundary : boundaries) {
                List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
                Rectangle bBounds = boundary.getFigure().getBounds();
                if (!enclosingBranches.isEmpty() && orientation.equals(enclosingBranches.get(enclosingBranches.size() - 1))) {
                    Rectangle rectangle = lBounds = bBounds.contains(lBounds) ? bBounds : lBounds;
                }
                if (enclosingBranches.isEmpty() || !assist.equals(enclosingBranches.get(0))) continue;
                Rectangle rectangle = rBounds = bBounds.contains(rBounds) ? bBounds : rBounds;
            }
        }
        if (lBounds.equals((Object)oriBounds)) {
            bounds = lBounds;
            isBefourBounds = false;
        } else if (rBounds.equals((Object)assBounds)) {
            bounds = rBounds;
            isBefourBounds = true;
        } else if (isRightOrUp) {
            if (lBounds.bottom() < rBounds.bottom()) {
                bounds = lBounds;
                isBefourBounds = false;
            } else {
                bounds = rBounds;
                isBefourBounds = true;
            }
        } else if (lBounds.y > rBounds.y) {
            bounds = lBounds;
            isBefourBounds = false;
        } else {
            bounds = rBounds;
            isBefourBounds = true;
        }
        int x = isBefourBounds ? bounds.x - minorSpacing - insSize.width / 2 : bounds.right() + minorSpacing + insSize.width / 2;
        int y = isRightOrUp ? bounds.bottom() - inventSize.height / 2 : bounds.y + inventSize.height / 2;
        return new Point(x, y);
    }
}

