/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.util.BundleUtility;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.mindmap.IMindMapImages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ImageUtils;

public class MindMapImages
implements IMindMapImages {
    private Map<String, ImageDescriptor> descriptors = new HashMap<String, ImageDescriptor>();
    private Map<Object, Cursor> cursors = new HashMap<Object, Cursor>();

    MindMapImages() {
    }

    @Override
    public ImageDescriptor get(String fullPath) {
        ImageDescriptor descriptor = this.descriptors.get(fullPath);
        if (descriptor == null && (descriptor = this.createImageDescriptor(fullPath)) != null) {
            this.descriptors.put(fullPath, descriptor);
        }
        return descriptor;
    }

    private ImageDescriptor createImageDescriptor(String path) {
        URL url = BundleUtility.find((String)"org.xmind.ui", (String)path);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    @Override
    public ImageDescriptor get(String fileName, String mainPath) {
        return this.get(String.valueOf(mainPath) + fileName);
    }

    @Override
    public ImageDescriptor get(String fileName, boolean enabled) {
        String mainPath = enabled ? "icons/e/" : "icons/d/";
        return this.get(fileName, mainPath);
    }

    @Override
    public ImageDescriptor getTopicIcon(ITopic topic, boolean enabled) {
        String type = topic.getType();
        if ("root".equals(type)) {
            return this.get("central.png", enabled);
        }
        if ("summary".equals(type)) {
            return this.get("summary_topic.png", enabled);
        }
        if ("detached".equals(type)) {
            return this.get("floating.png", enabled);
        }
        if ("callout".equals(type)) {
            return this.get("callout.png", enabled);
        }
        ITopic parent = topic.getParent();
        if (parent != null && parent.isRoot()) {
            return this.get("main.png", enabled);
        }
        return this.get("topic.png", enabled);
    }

    @Override
    public ImageDescriptor getElementIcon(Object element, boolean enabled) {
        if (element instanceof ITopic) {
            IAction action;
            ITopic topic = (ITopic)element;
            String hyperlink = topic.getHyperlink();
            if (hyperlink != null && (action = MindMapUI.getProtocolManager().createOpenHyperlinkAction(topic, hyperlink)) != null && action.getImageDescriptor() != null) {
                return action.getImageDescriptor();
            }
            return this.getTopicIcon(topic, enabled);
        }
        if (element instanceof ISheet) {
            return this.get("sheet.png", enabled);
        }
        if (element instanceof IWorkbook) {
            return this.get("workbook.png", enabled);
        }
        if (element instanceof IBoundary) {
            return this.get("boundary.png", enabled);
        }
        if (element instanceof IRelationship) {
            return this.get("relationship.gif", enabled);
        }
        return null;
    }

    @Override
    public ImageDescriptor getWizBan(String fileName) {
        return this.get(fileName, "icons/wizban/");
    }

    @Override
    public Cursor getCursor(IMindMapImages.CursorFactory factory) {
        if (factory == null) {
            return null;
        }
        String id = factory.getId();
        if (id == null) {
            return null;
        }
        Cursor cursor = this.cursors.get(id);
        if (cursor == null && (cursor = factory.createCursor(this)) != null) {
            this.cursors.put(id, cursor);
        }
        return cursor;
    }

    @Override
    public Cursor createCursor(String name, int hotX, int hotY) {
        ImageData mask;
        ImageDescriptor sourceDesc = this.get(String.valueOf(name) + ".bmp", "icons/pointers/");
        if (sourceDesc == null) {
            return null;
        }
        ImageData source = sourceDesc.getImageData();
        if (source == null) {
            return null;
        }
        ImageDescriptor maskDesc = this.get(String.valueOf(name) + "_mask.bmp", "icons/pointers/");
        if (maskDesc != null && (mask = maskDesc.getImageData()) != null) {
            return new Cursor(null, source, mask, hotX, hotY);
        }
        return new Cursor(null, source, hotX, hotY);
    }

    @Override
    public ImageDescriptor getFileIcon(String path) {
        return this.getFileIcon(path, false);
    }

    @Override
    public ImageDescriptor getFileIcon(String path, boolean returnNullIfUnidentifiable) {
        String extension = FileUtils.getExtension((String)path);
        if (extension == null || "".equals(extension)) {
            if (new File(path).isDirectory()) {
                return this.get("fldr_obj.gif", true);
            }
            if (returnNullIfUnidentifiable) {
                return null;
            }
            return this.get("unknownfile.gif", true);
        }
        String key = "org.xmind.ui.fileIcon" + extension;
        ImageDescriptor image = ImageUtils.getDescriptor((String)key);
        if (image == null) {
            image = this.createFileIcon(extension, new File(path).isDirectory(), returnNullIfUnidentifiable);
            ImageUtils.putImageDescriptor((String)key, (ImageDescriptor)image);
        }
        return image;
    }

    private ImageDescriptor createFileIcon(String fileExtension, boolean directory, boolean returnNullIfUnidentifiable) {
        ImageData data;
        Program p = Program.findProgram((String)fileExtension);
        if (p != null && (data = p.getImageData()) != null) {
            if (Util.isMac()) {
                return ImageUtils.scaleImage((Display)Display.getCurrent(), (ImageDescriptor)ImageDescriptor.createFromImageData((ImageData)data), (int)16, (int)16);
            }
            String tempPath = this.getTempFileIconPath();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{data};
            imageLoader.save(tempPath, 3);
            Image image = new Image((Device)Display.getCurrent(), tempPath);
            return ImageDescriptor.createFromImage((Image)image);
        }
        if (directory) {
            return this.get("fldr_obj.gif", true);
        }
        if (returnNullIfUnidentifiable) {
            return null;
        }
        return this.get("unknownfile.gif", true);
    }

    private String getTempFileIconPath() {
        String tempFile = Core.getWorkspace().getTempFile("fileIcons/" + Core.getIdFactory().createId() + ".ico");
        return tempFile;
    }
}

