/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tree;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.EditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tree.ITreePart;
import org.xmind.gef.tree.ITreeViewer;

public class TreePart
extends EditPart
implements ITreePart {
    private Widget widget = null;
    private boolean expanded = false;

    public Widget getWidget() {
        return this.widget;
    }

    public void setWidget(Widget widget) {
        this.preSetWidget(widget);
        this.widget = widget;
    }

    protected void preSetWidget(Widget widget) {
        if (widget != null) {
            widget.setData((Object)this);
            if (widget instanceof TreeItem) {
                final TreeItem item = (TreeItem)widget;
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        TreePart.this.expanded = item.getExpanded();
                    }
                });
                if (this.needsVisibleOnCreating()) {
                    this.ensureVisible(item);
                }
            }
            for (IPart child : this.getChildren()) {
                ITreePart treeChild = (ITreePart)child;
                if (widget instanceof TreeItem) {
                    treeChild.setWidget((Widget)new TreeItem((TreeItem)widget, 0));
                } else {
                    treeChild.setWidget((Widget)new TreeItem((Tree)widget, 0));
                }
                treeChild.refresh();
            }
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setExpanded(this.expanded);
            }
        } else {
            for (IPart child : this.getChildren()) {
                ((ITreePart)child).setWidget(null);
            }
        }
    }

    protected boolean needsVisibleOnCreating() {
        return true;
    }

    protected void ensureVisible(TreeItem item) {
        TreeItem p = item.getParentItem();
        if (p != null) {
            if (!p.getExpanded()) {
                p.setExpanded(true);
            }
        } else {
            return;
        }
        this.ensureVisible(p);
    }

    protected void addChildView(IPart child, int index) {
        Widget widget;
        IViewer viewer = this.getSite().getViewer();
        if (viewer instanceof ITreeViewer) {
            ((ITreeViewer)viewer).scheduleRedraw();
        }
        TreeItem item = (widget = this.getWidget()) instanceof Tree ? new TreeItem((Tree)widget, 0, index) : new TreeItem((TreeItem)widget, 0, index);
        ((ITreePart)child).setWidget((Widget)item);
    }

    protected void removeChildView(IPart child) {
        IViewer viewer = this.getSite().getViewer();
        if (viewer instanceof ITreeViewer) {
            ((ITreeViewer)viewer).scheduleRedraw();
        }
        ITreePart treeChild = (ITreePart)child;
        treeChild.getWidget().dispose();
        treeChild.setWidget(null);
    }

    protected void updateView() {
        super.updateView();
        this.setWidgetImage(this.getImage());
        this.setWidgetText(this.getText());
    }

    protected void reorderChild(IPart child, int index) {
        super.reorderChild(child, index);
        child.refresh();
    }

    protected boolean isValidTreeItem() {
        return this.widget != null && !this.widget.isDisposed() && this.widget instanceof TreeItem;
    }

    protected void setWidgetImage(Image image) {
        if (this.isValidTreeItem()) {
            ((TreeItem)this.widget).setImage(image);
        }
    }

    protected void setWidgetText(String text) {
        if (this.isValidTreeItem()) {
            ((TreeItem)this.widget).setText(text);
        }
    }

    protected Image getImage() {
        return null;
    }

    protected String getText() {
        return "";
    }
}

