/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.policy;

import java.util.List;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.AbstractEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalableEditPolicy
extends AbstractEditPolicy {
    @Override
    public boolean understands(String requestType) {
        return super.understands(requestType) || "zoom".equals(requestType) || "zoom_in".equals(requestType) || "zoom_out".equals(requestType) || "actual_size".equals(requestType) || "fit_size".equals(requestType) || "fit_selection".equals(requestType);
    }

    @Override
    public void handle(Request req) {
        String type = req.getType();
        if ("zoom".equals(type)) {
            this.performZoomRequest(req);
        } else if ("zoom_in".equals(type)) {
            this.performZoomIn(this.getGraphicalViewer(req));
        } else if ("zoom_out".equals(type)) {
            this.performZoomOut(this.getGraphicalViewer(req));
        } else if ("actual_size".equals(type)) {
            this.performActualSize(req);
        } else if ("fit_size".equals(type)) {
            this.performFitSize(this.getGraphicalViewer(req));
        } else if ("fit_selection".equals(type)) {
            this.performFitSelection(req);
        }
    }

    protected IGraphicalViewer getGraphicalViewer(Request req) {
        IViewer viewer = req.getTargetViewer();
        if (viewer != null && viewer instanceof IGraphicalViewer) {
            return (IGraphicalViewer)viewer;
        }
        return null;
    }

    protected void preserveCenter(Runnable action, IGraphicalViewer viewer) {
        PrecisionPoint center = viewer == null ? null : new PrecisionPoint(viewer.getCenterPoint());
        double oldScale = viewer.getZoomManager().getScale();
        try {
            action.run();
        }
        finally {
            if (viewer != null && center != null) {
                if (viewer.getZoomManager() != null) {
                    center.scale(2.0 * viewer.getZoomManager().getScale() / oldScale);
                }
                if (viewer.getZoomManager().getScale() != oldScale) {
                    viewer.center(center.toDraw2DPoint());
                }
            }
        }
    }

    protected void performZoomOut(IGraphicalViewer viewer) {
        if (viewer == null) {
            return;
        }
        final ZoomManager zoomManager = viewer.getZoomManager();
        this.preserveCenter(new Runnable(){

            public void run() {
                zoomManager.zoomOut();
            }
        }, viewer);
    }

    protected void performZoomIn(final IGraphicalViewer viewer) {
        if (viewer == null) {
            return;
        }
        this.preserveCenter(new Runnable(){

            public void run() {
                viewer.getZoomManager().zoomIn();
            }
        }, viewer);
    }

    protected void performActualSize(Request req) {
        final IGraphicalViewer viewer = this.getGraphicalViewer(req);
        if (viewer == null) {
            return;
        }
        List<IPart> selectedParts = req.getTargets();
        if (selectedParts.isEmpty()) {
            selectedParts = viewer.getSelectionSupport().getPartSelection();
        }
        if (selectedParts.isEmpty()) {
            return;
        }
        final Rectangle bounds = this.getSelectionBounds(viewer, selectedParts);
        if (bounds != null) {
            Viewport viewport = viewer.getCanvas().getViewport();
            viewer.getZoomManager().actualSize();
            bounds.getCenter().scale(viewer.getZoomManager().getScale());
            viewport.getUpdateManager().runWithUpdate(new Runnable(){

                public void run() {
                    viewer.center(bounds.getCopy().scale(viewer.getZoomManager().getScale() * 2.0));
                }
            });
        }
    }

    protected void performZoomRequest(Request request) {
        Object param = request.getParameter("zoomScale");
        if (param == null || !(param instanceof Double)) {
            return;
        }
        final double scale = (Double)param;
        final IGraphicalViewer viewer = this.getGraphicalViewer(request);
        if (viewer == null) {
            return;
        }
        this.preserveCenter(new Runnable(){

            public void run() {
                viewer.getZoomManager().setScale(scale);
            }
        }, viewer);
    }

    protected void performFitSize(IGraphicalViewer viewer) {
        if (viewer == null) {
            return;
        }
        Rectangle bounds = this.getContentsBounds(viewer);
        if (bounds != null) {
            this.fitBounds(viewer, bounds, viewer.getZoomManager());
        }
    }

    protected void fitBounds(final IGraphicalViewer viewer, final Rectangle bounds, final ZoomManager zoomManager) {
        Viewport viewport = viewer.getCanvas().getViewport();
        Dimension viewportSize = this.getViewportSize(viewer, (IFigure)viewport, zoomManager);
        zoomManager.fitScale(viewportSize, bounds.getSize());
        bounds.getCenter().scale(zoomManager.getScale());
        viewport.getUpdateManager().runWithUpdate(new Runnable(){

            public void run() {
                viewer.center(bounds.getCopy().scale(zoomManager.getScale() * 2.0));
            }
        });
    }

    protected Dimension getViewportSize(IGraphicalViewer viewer, IFigure viewport, ZoomManager zoomManager) {
        return viewport.getSize();
    }

    protected void ensureVisible(IGraphicalViewer viewer, Rectangle bounds) {
        viewer.ensureVisible(bounds);
    }

    protected Rectangle getContentsBounds(IGraphicalViewer viewer) {
        return this.getBounds(viewer.getRootPart().getContents());
    }

    protected Rectangle getBounds(IPart p) {
        IFigure figure;
        if (p != null && p.getStatus().isActive() && p instanceof IGraphicalPart && (figure = ((IGraphicalPart)p).getFigure()) != null) {
            if (figure instanceof FreeformFigure) {
                return ((FreeformFigure)figure).getFreeformExtent();
            }
            return figure.getBounds();
        }
        return null;
    }

    protected void performFitSelection(Request req) {
        IGraphicalViewer viewer = this.getGraphicalViewer(req);
        if (viewer == null) {
            return;
        }
        List<IPart> selectedParts = req.getTargets();
        if (selectedParts.isEmpty()) {
            selectedParts = viewer.getSelectionSupport().getPartSelection();
        }
        if (selectedParts.isEmpty()) {
            return;
        }
        Rectangle bounds = this.getSelectionBounds(viewer, selectedParts);
        if (bounds != null) {
            this.fitBounds(viewer, bounds, viewer.getZoomManager());
        }
    }

    protected Rectangle getSelectionBounds(IGraphicalViewer viewer, List<? extends IPart> parts) {
        Rectangle r = null;
        for (IPart iPart : parts) {
            r = Geometry.union(r, this.getBounds(iPart));
        }
        return r;
    }
}

