/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.AbstractEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigablePolicy
extends AbstractEditPolicy {
    @Override
    public boolean understands(String requestType) {
        return super.understands(requestType) || "navigate_up".equals(requestType) || "navigate_down".equals(requestType) || "navigate_left".equals(requestType) || "navigate_right".equals(requestType) || "navigate_beginning".equals(requestType) || "navigate_end".equals(requestType) || "navigate_next".equals(requestType) || "navigate_previous".equals(requestType);
    }

    @Override
    public void handle(Request request) {
        IPart source;
        IPart target;
        String navType = request.getType();
        if ("navigate_up".equals(navType) || "navigate_down".equals(navType) || "navigate_left".equals(navType) || "navigate_right".equals(navType) || "navigate_beginning".equals(navType) || "navigate_end".equals(navType)) {
            List<IPart> sources = request.getTargets();
            ArrayList<IPart> result = new ArrayList<IPart>();
            IPart seqStart = this.getSequenceStart(request);
            if (seqStart != null) {
                this.findSequentialNavParts(request, navType, seqStart, sources, result);
            } else {
                this.findNavParts(request, navType, sources, result);
            }
            this.setNavigationResult(request, result);
        } else if (("navigate_next".equals(navType) || "navigate_previous".equals(navType)) && (target = this.findNextOrPrev(source = request.getPrimaryTarget(), "navigate_next".equals(navType))) != null) {
            this.setNavigationResult(request, Arrays.asList(target));
        }
    }

    protected IPart findNextOrPrev(IPart source, boolean nextOrPrev) {
        return null;
    }

    protected void setNavigationResult(Request request, List<? extends IPart> result) {
        if (!result.isEmpty()) {
            request.setResult("navigationResult", result.toArray(new IPart[result.size()]));
        }
    }

    protected void findNavParts(Request request, String navType, List<IPart> sources, List<IPart> result) {
        result.addAll(sources);
    }

    protected void findSequentialNavParts(Request request, String navType, IPart sequenceStart, List<IPart> sources, List<IPart> result) {
        result.addAll(sources);
    }

    protected IPart getSequenceStart(Request request) {
        if (this.isSequential(request)) {
            return (IPart)request.getParameter("navigationSequenceStart");
        }
        return null;
    }

    protected boolean isSequential(Request request) {
        return request.isParameter("navigationSequential");
    }
}

